/*
<:copyright-gpl 
 Copyright 2010 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#ifndef __BR_FP_H__
#define __BR_FP_H__

#include <linux/device.h>

struct br_fp_data {
	int (*fdb_add)      (struct net_device *dst, unsigned char * mac_addr);
	int (*fdb_remove)   (struct net_device *dst, unsigned char * mac_addr);
	int (*fdb_modify)   (struct net_device *dst, unsigned char * mac_addr);
	u8  (*fdb_check_age)(struct net_device *dst, unsigned char * mac_addr);
#ifdef ARCADYAN
	int (*iptv_add)      (struct net_device *dst, unsigned long dip);
	int (*iptv_remove)   (struct net_device *dst, unsigned long dip);
	int (*iptv_modify)   (struct net_device *dst, unsigned long dip);
#endif /* ARCADYAN */
};

/* interface routine */
int br_fp_set_callbacks  (const char * br_name, struct br_fp_data *fpdata);
int br_fp_clear_callbacks(const char * br_name);
#endif /* __BR_FP_H__ */

