/*
<:copyright-gpl 
 Copyright 2010 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#include "br_private.h"
#include "br_fp.h"

int br_fp_set_callbacks(const char * br_name, struct br_fp_data *fpdata)
{
#if defined(ARCADYAN)
	br_fp_update_callbacks(fpdata);
#else
	struct net_bridge *br = NULL;
	struct net_device *dev = dev_get_by_name(&init_net, br_name);

	if (dev) {
	  br = netdev_priv(dev);
	}
	else
	   return 1;

	br->fp_hooks = *fpdata;
	dev_put(dev);
#endif
	return 0;
}
EXPORT_SYMBOL(br_fp_set_callbacks);

int br_fp_clear_callbacks(const char * br_name)
{
#if defined(ARCADYAN)
	br_fp_update_callbacks(NULL);
#else
	struct net_bridge *br = NULL;
	struct net_device *dev = dev_get_by_name(&init_net, br_name);

	if (dev) {
	    br = netdev_priv(dev);
	}
	else    
	   return 1;


	memset(&br->fp_hooks, 0, sizeof(struct br_fp_data));
	dev_put(dev);
#endif
	return 0;
}
EXPORT_SYMBOL(br_fp_clear_callbacks);

