#ifndef _ARCEFM_IOCTL_H
#define _ARCEFM_IOCTL_H

#define EFM_DEV_NAME "arcEfmDev"

#ifndef IFNAMSIZ
#define IFNAMSIZ 16
#endif
#ifndef EOAM_OUI_LENGTH
#define EOAM_OUI_LENGTH 3
#endif

typedef enum {
    EFM_STATUS_DISABLE = 0,
    EFM_STATUS_ENABLE,
    EFM_STATUS_UNKNOWN
}tEfmStatus;

typedef enum {
    EFM_BOOL_FALSE = 0,
    EFM_BOOL_TRUE,        
}tEfmBoolean;

typedef enum {
    EFM_PORT_MODE_PASSIVE       = 1,
    EFM_PORT_MODE_ACTIVE        = 2,        
    EFM_PORT_MODE_PEER_UNKNOWN  = 3,  
}tEfmPortMode;

typedef enum {
    DBG_LEVEL_INIT_SHUT_TRC        = (0x1 << 0),
    DBG_LEVEL_MGMT_TRC             = (0x1 << 1),
    DBG_LEVEL_DATA_PATH_TRC        = (0x1 << 2),
    DBG_LEVEL_CONTROL_PLANE_TRC    = (0x1 << 3),
    DBG_LEVEL_DUMP_TRC             = (0x1 << 4),
    DBG_LEVEL_OS_RESOURCE_TRC      = (0x1 << 5),
    DBG_LEVEL_ALL_FAILURE_TRC      = (0x1 << 6),
    DBG_LEVEL_BUFFER_TRC           = (0x1 << 7),
    
    DBG_LEVEL_EOAM_FN_ENTRY_TRC    = (0x1 << 16),
    DBG_LEVEL_EOAM_FN_EXIT_TRC     = (0x1 << 17),
    DBG_LEVEL_EOAM_CRITICAL_TRC    = (0x1 << 18),
    DBG_LEVEL_EOAM_DISCOVERY_TRC   = (0x1 << 19),
    DBG_LEVEL_EOAM_LOOPBACK_TRC    = (0x1 << 20),
    DBG_LEVEL_EOAM_LM_TRC          = (0x1 << 21),
    DBG_LEVEL_EOAM_VAR_REQRESP_TRC = (0x1 << 22),
    DBG_LEVEL_EOAM_RFI_TRC         = (0x1 << 23),
    DBG_LEVEL_EOAM_MUX_PAR_TRC     = (0x1 << 24),
    DBG_LEVEL_EOAM_RED_TRC         = (0x1 << 25),
    DBG_LEVEL_EOAM_ALL_TRC         = 0xFFFFFFFF,    
}tEfmDebugLevel;
/*err number between 0 and 240 is reserved for mapping to snmp error number*/
typedef enum {
    EFM_IOCTLRET_NO_ERROR = 0,
    EFM_IOCTLRET_IF_NOT_EXIST = 240,
    EFM_IOCTLRET_PROCESS_ERROR,
    EFM_IOCTLRET_MEM_ALLOC_FAILED,    
}eEFM_IOCTLRET;

/* EOAM Oper status */
typedef enum {

    EFM_OPER_DISABLE = 1,
    EFM_OPER_LINKFAULT,
    EFM_OPER_PASSIVEWAIT, 
    EFM_OPER_ACTIVE_SENDLOCAL,
    EFM_OPER_SENDLOCALREMOTE,
    EFM_OPER_SENDLOCALREMOTEOK,
    EFM_OPER_PEERINGLOCALLYREJECTED,
    EFM_OPER_PEERINGREMOTELYREJECTED,
    EFM_OPER_OPERATIONAL,
    EFM_OPER_UNKNOWN, 
}tEfmOperStatus;

typedef struct {
    unsigned int u4Hi;
    unsigned int u4Lo;
}tEfmUint8;

typedef struct {
    tEfmStatus status;
}tEFM_IOCTL_PARAM_SYS_CTL,
 tEFM_IOCTL_PARAM_MOD_STATUS;

typedef struct {
    unsigned char oui[EOAM_OUI_LENGTH];
}tEFM_IOCTL_PARAM_OUI;

typedef struct {
    unsigned int count;
}tEFM_IOCTL_PARAM_ERR_RESEND_COUNT;

typedef struct {
    tEfmStatus status;    
    tEfmDebugLevel dbgLevelMask;    
}tEFM_IOCTL_PARAM_DEBUG_LEVEL;

typedef struct {
    char ifName[IFNAMSIZ];
    tEfmPortMode   mode;
}tEFM_IOCTL_PARAM_PORT_MODE;

typedef struct {
    char ifName[IFNAMSIZ];
    tEfmStatus     status;
}tEFM_IOCTL_PARAM_ADMIN_STATE,
 tEFM_IOCTL_PARAM_PORT_REMOTE_LB,
 tEFM_IOCTL_PARAM_PORT_REMOTE_LBCMD;

typedef struct {
    char ifName[IFNAMSIZ];
    tEfmBoolean    flag;
}tEFM_IOCTL_PARAM_SET_SYMBOL_PERIOD_NOTIFY;

typedef struct {
    char ifName[IFNAMSIZ];
    tEfmUint8    window;
}tEFM_IOCTL_PARAM_SET_SYMBOL_PERIOD_WINDOW;

typedef struct {
    char ifName[IFNAMSIZ];
    tEfmUint8    threshold;
}tEFM_IOCTL_PARAM_SET_SYMBOL_PERIOD_THRESHOLD;

typedef struct { /* in milliseconds */
    
    char ifName[IFNAMSIZ];    
    unsigned int pduTxTimeout;
    unsigned int lostLinkTimeout;
    unsigned int lbCmdTimeout;
    
}tEFM_IOCTL_PARAM_ALL_TIMER_PERIOD;

typedef struct {
    char ifName[IFNAMSIZ];
    tEfmBoolean showAll;
}tEFM_IOCTL_PARAM_DUMP_LOCAL_PORT_INFO,
 tEFM_IOCTL_PARAM_DUMP_LOCAL_INFO;

typedef struct {
    char ifName[IFNAMSIZ];
    tEfmOperStatus state;
}tEFM_IOCTL_PARAM_OPERATION_STATE;

typedef struct { 
    
    char ifName[IFNAMSIZ];    
    unsigned short  rConfigRevision;                                     
    unsigned short  rwMaxOamPduSize;      
    unsigned short  rEoamOperStatus;     
    unsigned char   rEoamAdminStatus;    
    unsigned char   rMode;                  
    unsigned char   rFnsSupportedBmp;

}tEFM_IOCTL_PARAM_LOCAL_INFO;

typedef struct {

    char ifName[IFNAMSIZ];        
    unsigned int    VendorInfo;      
    unsigned short  ConfigRevision;  
    unsigned short  MaxOamPduSize;  
    unsigned short  Flags;           
    unsigned char   State;           
    unsigned char   Mode;            
    unsigned char   MacAddress[6];        
    unsigned char   FnsSupportedBmp; 
    unsigned char   Status;          
    unsigned char   VendorOui[EOAM_OUI_LENGTH];      
}tEFM_IOCTL_PARAM_PEER_INFO;

typedef enum {
    EFM_IOCTL_SET_SYSTEM_CONTROL = 0,
    EFM_IOCTL_SET_MOD_STATUS,
    EFM_IOCTL_SET_OUI,
    EFM_IOCTL_SET_ERR_RESEND_COUNT,
    EFM_IOCTL_SET_DEBUG_LEVEL,

    EFM_IOCTL_SET_PORT_ADMIN_STATUS,    
    EFM_IOCTL_SET_PORT_MODE,    
    EFM_IOCTL_SET_PORT_REMOTE_LBCMD,
    EFM_IOCTL_SET_PORT_REMOTE_LB,

    EFM_IOCTL_SET_SYMBOL_PERIOD_NOTIFY,
    EFM_IOCTL_SET_SYMBOL_PERIOD_WINDOW,
    EFM_IOCTL_SET_SYMBOL_PERIOD_THRESHOLD,

    EFM_IOCTL_SET_FRAME_NOTIFY,
    EFM_IOCTL_SET_FRAME_WINDOW,
    EFM_IOCTL_SET_FRAME_THRESHOLD,

    EFM_IOCTL_SET_FRAME_PERIOD_NOTIFY,
    EFM_IOCTL_SET_FRAME_PERIOD_WINDOW,
    EFM_IOCTL_SET_FRAME_PERIOD_THRESHOLD,

    EFM_IOCTL_SET_FRAME_SECSUM_NOTIFY,
    EFM_IOCTL_SET_FRAME_SECSUM_WINDOW,
    EFM_IOCTL_SET_FRAME_SECSUM_THRESHOLD,

    EFM_IOCTL_SET_CRITICAL_EVENT,
    EFM_IOCTL_SET_DYING_GASP,

    EFM_IOCTL_SET_ALL_TIMER_TIMEOUT,
    EFM_IOCTL_GET_ALL_TIMER_TIMEOUT,    
    EFM_IOCTL_SET_LOCAL_INFO,    
    EFM_IOCTL_GET_LOCAL_INFO,
    EFM_IOCTL_GET_PEER_INFO,

    
    EFM_IOCTL_DUMP_GLOBAL,
    EFM_IOCTL_DUMP_LOCAL_INFO,
    EFM_IOCTL_DUMP_LOCAL_PORT_INFO,
    EFM_IOCTL_DUMP_LOCAL_FUNCSUPP,
    EFM_IOCTL_DUMP_SYM_PERIOD,
    EFM_IOCTL_DUMP_FRAME_PERIOD,    
    EFM_IOCTL_DUMP_FRAME_SECSUM,        
    EFM_IOCTL_DUMP_PEER_INFO,
    EFM_IOCTL_DUMP_PEER_PORT_INFO,
    EFM_IOCTL_DUMP_PEER_FUNCSUPP,
    EFM_IOCTL_DUMP_LOOPBACK_CAPABILITY,
    EFM_IOCTL_DUMP_EVENT_NOFITY,
    EFM_IOCTL_DUMP_STATS,
    EFM_IOCTL_DUMP_RX_STATS,
    EFM_IOCTL_DUMP_TX_STATS,    
    EFM_IOCTL_DUMP_RXTX_STATS,
    EFM_IOCTL_DUMP_EVENT_LOG,
    EFM_IOCTL_DUMP_DEBUG_LEVEL,    
    EFM_IOCTL_DUMP_RUNNING_CFG_ALL,
    EFM_IOCTL_DUMP_RUNNING_CFG_GLOBAL,    
    EFM_IOCTL_DUMP_RUNNING_CFG_IF,
    EFM_IOCTL_DUMP_RUNNING_CFG_IFINFO,    
    EFM_IOCTL_DUMP_RUNNING_CFG_OAM_TABLE,
    EFM_IOCTL_DUMP_RUNNING_CFG_OAM_LBTABLE,
    EFM_IOCTL_DUMP_RUNNING_CFG_SYMBOL_PERIOD,    
    EFM_IOCTL_DUMP_RUNNING_CFG_FRAME_PERIOD,
    EFM_IOCTL_DUMP_RUNNING_CFG_FRAME,    
    EFM_IOCTL_DUMP_RUNNING_CFG_FRAME_SECSUM,
    EFM_IOCTL_DUMP_RUNNING_CFG_FAULT_IND,
    EFM_IOCTL_DUMP_RUNNING_CFG_PORT_NAME,    

    EFM_IOCTL_CLEAR_STATS,
    EFM_IOCTL_CLEAR_LOCAL,
    EFM_IOCTL_CLEAR_EVENT_LOG,
    EFM_IOCTL_CMD_UNKNOWN,    
}eEFM_IOCTL_CMD;

#endif /*_ARCEFM_IOCTL_H*/
