#ifndef __NF_CONNTRACK_SIP_BCM_H__
#define __NF_CONNTRACK_SIP_BCM_H__
#ifdef __KERNEL__

#define SIP_PORT	5060
#define SIP_TIMEOUT	3600

/* Classes defined by Broadcom */
#define SIP_EXPECT_CLASS_SIGNALLING	0
#define SIP_EXPECT_CLASS_AUDIO		1
#define SIP_EXPECT_CLASS_VIDEO		2
#define SIP_EXPECT_CLASS_OTHER		3
#define SIP_EXPECT_CLASS_MAX		3

enum sip_header_pos {
	POS_VIA,
	POS_CONTACT,
	POS_CONTENT,
	POS_OWNER_IP4,
	POS_CONNECTION_IP4,
	POS_ANAT,
	POS_MEDIA_AUDIO,
	POS_MEDIA_VIDEO,
};

extern int (*nf_nat_bcm_addr_hook)(struct sk_buff *skb, unsigned int protoff,
			       struct nf_conn *ct,
			       enum ip_conntrack_info ctinfo, char **dptr,
			       int *dlen, char **addr_begin, int *addr_len,
			       struct nf_conntrack_man *addr);

extern int (*nf_nat_bcm_rtp_hook)(struct sk_buff *skb, unsigned int protoff,
			      struct nf_conn *ct,
			      enum ip_conntrack_info ctinfo, char **dptr,
			      int *dlen, struct nf_conntrack_expect *exp,
			      char **port_begin, int *port_len);

extern int (*nf_nat_bcm_snat_hook)(struct nf_conn *ct,
			       enum ip_conntrack_info ctinfo,
			       struct nf_conntrack_expect *exp);

extern int (*nf_nat_bcm_sip_hook)(struct sk_buff *skb, unsigned int protoff,
			      struct nf_conn *ct,
			      enum ip_conntrack_info ctinfo, char **dptr,
			      int *dlen, struct nf_conntrack_expect *exp,
			      char **addr_begin, int *addr_len);
#endif /* __KERNEL__ */
#endif /* __NF_CONNTRACK_SIP_BCM_H__ */

