#ifndef __BL_NAT_H__
#define __BL_NAT_H__

#include <linux/netfilter.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <net/netfilter/nf_conntrack.h>
#include <net/netfilter/nf_conntrack_l3proto.h>
#include <net/netfilter/nf_conntrack_l4proto.h>
#include <net/netfilter/nf_conntrack_expect.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/nf_conntrack_extend.h>
#include <net/netfilter/nf_conntrack_acct.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>

//#define __CONN_TRACK_DBG__ /* Consumes memory - need to be commented if not used */
//#define __BL_RGW_RTSP__
//#define __BL_RGW_IPv6__ /* Adds IPv6 support to BL Netfilter patch */

//#define __BL_RGW_PRINTS__
#ifdef __BL_RGW_PRINTS__

/* From ./include/linux/kernel.h	*/
/* KERN_EMERG  		- 0 			*/
/* KERN_ALERT  		- 1 			*/
/* KERN_CRIT   		- 2 			*/
/* KERN_ERR    		- 3 			*/
/* KERN_WARNING   	- 4 			*/
/* KERN_NOTICE 		- 5 			*/
/* KERN_INFO   		- 6 			*/
/* KERN_DEBUG  		- 7 			*/

/* Code high level info - normal trace level - low foot print */

#define BL_NAT_KPRINT(fmt, args...)   	printk(KERN_DEBUG "###:NF | F:[%-24s] L:[%-4d] | " fmt "\n", __FUNCTION__, __LINE__, args);

/* Print error macro */
#define BL_NAT_KPRINTERR(fmt, args...)	printk(KERN_CRIT "!!!:NF | F:[%-24s] L:[%-4d] | " fmt "\n", __FUNCTION__, __LINE__, args);

/* Code low level info */
#define BL_NAT_KPRINTINF(fmt, args...) printk(KERN_INFO "@@@:NF | F:[%-24s] L:[%-4d] | " fmt "\n", __FUNCTION__, __LINE__, args);

/* Code notice level info */
#define BL_NAT_KPRINTNOTE(fmt, args...) printk(KERN_NOTICE "+++:NF | F:[%-24s] L:[%-4d] | " fmt "\n", __FUNCTION__, __LINE__, args);

/* Trace message with file line information */
#define BL_NAT_KPRINT_FFL(fmt, args...)   printk(KERN_DEBUG ">>>:NF | P:[%-24s] F:[%-24s] L:[%-4d] | " fmt "\n", __FILE__, __FUNCTION__, __LINE__, args);

#else

#define BL_NAT_KPRINT(fmt, args...)
#define BL_NAT_KPRINTERR(fmt, args...)
#define BL_NAT_KPRINTINF(fmt, args...)
#define BL_NAT_KPRINT_FFL(fmt, args...)
#endif /* __BL_RGW_PRINTS__ */


/* Fast-path control variables */
extern int nf_conntrack_bl_fast_path_enabled;
extern int nf_conntrack_bl_fast_gre_enabled;

int bl_nat_check_ct_activity(struct nf_conn * ct, struct net * net);
void bl_nat_update_conntrack_timer(struct nf_conn * ct);
void bl_nat_activity_track(struct nf_conn * ct);
void bl_nat_arp_add_entry(int state, __be32 sip, __be32 tip, u8 * sha);
#ifdef ARCADYAN
void bl_nat_arp_delete_entry(__be32 dip);
#endif /* ARCADYAN */
void bl_nat_route_real_neighbours(struct dst_entry *dst);
void bl_nat_conntrack_init(struct nf_conn * ct);
void bl_nat_conntrack_confirm(struct nf_conn * ct, __be16 protocol);
#ifdef CONFIG_BL_FW
void bl_fw_check_match(struct ipt_entry_match *m, const struct ipt_ip *ip, const char *name);
void bl_fw_add_ftp_entry(struct nf_conn * ct, enum ip_conntrack_info ctinfo, u_int16_t port);
void bl_fw_remove_all(const char * tablename);
#endif /* CONFIG_BL_FW */
#endif /* !__BL_NAT_H__ */

