#ifndef _QMIDEVICE_USER_H
#define _QMIDEVICE_USER_H

enum {
	QMI_SVC_TYPE_CTL = 0,
	QMI_SVC_TYPE_WDS,
	QMI_SVC_TYPE_DMS,
	QMI_SVC_TYPE_NAS,
	QMI_SVC_TYPE_MAX
};

/* ioctl to generate a client ID for this service type */
#define IOCTL_QMI_GET_CLIENT_ID (0x8BE0 + 1)

/* ioctl to release the client ID for this service type */
#define IOCTL_QMI_REL_CLIENT_ID (0x8BE0 + 2)

/* ioctl to generate a transaction ID for this service type */
#define IOCTL_QMI_GET_TRANSACTION_ID (0x8BE0 + 3)

/* ioctl to perform write-sync */
#define IOCTL_QMI_WRITE_SYNC (0x8BE0 + 4)

/* ioctl to perform read-sync */
#define IOCTL_QMI_READ_SYNC (0x8BE0 + 5)

/* ioctl to perform link-state request */
#define IOCTL_QMI_GET_LINKSTATE (0x8BE0 + 6)

typedef struct qmi_ioctl_cmd_s {
	unsigned char svc_type;
	unsigned short client_id;
	unsigned short trans_id;
	unsigned short msg_id;
	void *buf;
	int buf_len;
	int read_len;
} qmi_ioctl_cmd_t;

#endif /* _QMIDEVICE_USER_H */

