/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/pci.h>
#include <linux/clk.h>
#include <linux/platform_device.h>
#include <bcm63268_cpu.h>
#include <bcm63268_regs.h>
#include <bcm63268_io.h>
#include <bcm63268_pcie.h>

extern struct pci_ops bcm63268_pci_ops;
extern struct pci_ops bcm63268_pcie_ops;

static struct resource bcm63268_pci_io_resource = {
    .name   = "BCM63268 PCI IO",
    .start  = BCM63268_PCI_IO_BASE,
    .end    = BCM63268_PCI_IO_BASE + BCM63268_PCI_IO_SIZE - 1,
    .flags  = IORESOURCE_IO
};

static struct resource bcm63268_pci_mem_resource = {
    .name   = "BCM63268 PCI MEM",
    .start  = BCM63268_PCI_MEM_BASE,
    .end    = BCM63268_PCI_MEM_BASE + BCM63268_PCI_MEM_SIZE - 1,
    .flags  = IORESOURCE_MEM
};

struct pci_controller bcm63268_pci_controller = {
    .pci_ops	= &bcm63268_pci_ops,
    .io_resource	= &bcm63268_pci_io_resource,
    .mem_resource	= &bcm63268_pci_mem_resource,
};

static struct resource bcm63268_pcie_io_resource = {
    .name   = "BCM63268 PCIe NULL IO",
    .start  = 0,
    .end    = 0,
    .flags  = 0
};

static struct resource bcm63268_pcie_mem_resource = {
    .name   = "BCM63268 PCIe MEM",
    .start  = BCM63268_PCIE_MEM1_BASE,
    .end    = BCM63268_PCIE_MEM1_BASE + BCM63268_PCIE_MEM1_SIZE - 1,
    .flags  = IORESOURCE_MEM
};

struct pci_controller bcm63268_pcie_controller = {
    .pci_ops	= &bcm63268_pcie_ops,
    .io_resource	= &bcm63268_pcie_io_resource,
    .mem_resource	= &bcm63268_pcie_mem_resource,
};

static int __init bcm63268_pcie_setup(void)
{
	u32 reg32;

	/* adjust global io port range */
	ioport_resource.start = BCM63268_PCI_IO_BASE;
	ioport_resource.end = BCM63268_PCI_IO_BASE + BCM63268_PCI_IO_SIZE - 1;

	/* bus 0 */
	register_pci_controller(&bcm63268_pci_controller);

	/* bus 1 */
	/*
	 * Initialize a PCIe port for use in host(RC) mode. It doesn't
	 * enumerate the bus.
	 */
	reg32 = bcm_pcie_readl(PCIE_BRIDGE_OPT1_REG);
	reg32 |= (PCIE_BRIDGE_OPT1_L1_INTR_POLARITY | PCIE_BRIDGE_OPT1_HOLE_DETECT_EN 
		| PCIE_BRIDGE_OPT1_RD_REPLY_BE_FIX_EN | PCIE_BRIDGE_OPT1_RD_BE_EN);
	bcm_pcie_writel(reg32, PCIE_BRIDGE_OPT1_REG);

	reg32 = bcm_pcie_readl(PCIE_BRIDGE_RC_INTR_MASK_REG);
	reg32 |= (PCIE_BRIDGE_RC_INTR_MASK_A | PCIE_BRIDGE_RC_INTR_MASK_B 
		| PCIE_BRIDGE_RC_INTR_MASK_C | PCIE_BRIDGE_RC_INTR_MASK_D);
	bcm_pcie_writel(reg32, PCIE_BRIDGE_RC_INTR_MASK_REG);

	/* enable credit checking and error checking */
	reg32 = bcm_pcie_readl(PCIE_BRIDGE_OPT2_REG);
	reg32 |= (PCIE_BRIDGE_OPT2_TX_CRD_CHK_EN | PCIE_BRIDGE_OPT2_UBUS_UR_DECODE_DIS);
	bcm_pcie_writel(reg32, PCIE_BRIDGE_OPT2_REG);

	/* setup outgoing window */
	reg32 = bcm_pcie_readl(PCIE_BRIDGE_UBUS2PCIE_BAR0_REG);
	reg32 |= (BCM63268_PCIE_MEM1_BASE & PCIE_BRIDGE_UBUS2PCIE_BAR0_BASE_MASK);
	reg32 |= (((BCM63268_PCIE_MEM1_BASE + BCM63268_PCIE_MEM1_SIZE - 1) >> 
					PCIE_BRIDGE_UBUS2PCIE_BAR0_BASE_SHIFT) << PCIE_BRIDGE_UBUS2PCIE_BAR0_MASK_SHIFT);
	reg32 |= PCIE_BRIDGE_UBUS2PCIE_BAR0_SWAP_ENABLE;
	bcm_pcie_writel(reg32, PCIE_BRIDGE_UBUS2PCIE_BAR0_REG);

	/* set device bus/func */
	reg32 = bcm_pcie_readl(PCIE_BRIDGE_OPT2_REG);
	reg32 &= ~(PCIE_BRIDGE_OPT2_BUS_NO_MASK | PCIE_BRIDGE_OPT2_DEV_NO_MASK | PCIE_BRIDGE_OPT2_FUNC_NO_MASK);
	reg32 |= ((BCM63268_PCIE_BUS_DEV << PCIE_BRIDGE_OPT2_BUS_NO_SHIFT) | PCIE_BRIDGE_OPT2_BD_SEL);
	bcm_pcie_writel(reg32, PCIE_BRIDGE_OPT2_REG);

	/* setup class code as bridge */
	reg32 = bcm_pcie_readl(PCIE_BLOCK_428_IDVAL3_REG);
	reg32 &= ~(PCIE_BLOCK_428_IDVAL3_REV_MASK 
				| PCIE_BLOCK_428_IDVAL3_PROG_IF_MASK 
				| PCIE_BLOCK_428_IDVAL3_SUB_CLS_CODE_MASK 
				| PCIE_BLOCK_428_IDVAL3_CLS_CODE_MASK);
	bcm_pcie_writel(reg32, PCIE_BLOCK_428_IDVAL3_REG);
	reg32 |= (PCI_CLASS_BRIDGE_PCI << PCIE_BLOCK_428_IDVAL3_SUB_CLS_CODE_SHIFT);
	bcm_pcie_writel(reg32, PCIE_BLOCK_428_IDVAL3_REG);

	/* disable bar0 size */
	reg32 = bcm_pcie_readl(PCIE_BLOCK_404_CFG2_REG);
	reg32 &= ~(PCIE_BLOCK_404_CFG2_BAR1_SIZE_MASK);
	bcm_pcie_writel(reg32, PCIE_BLOCK_404_CFG2_REG);

#if 0
	reg32 = bcm_pcie_readl(PCIE_BRIDGE_PCIE_CONTROL);
	reg32 |= PCIE_BRIDGE_PCIE_CONTROL_CLKREQ_ENABLE;
	bcm_pcie_writel(reg32, PCIE_BRIDGE_PCIE_CONTROL);
#endif

	register_pci_controller(&bcm63268_pcie_controller);

    return 0;
}

arch_initcall(bcm63268_pcie_setup);

