/*
<:copyright-gpl 
 Copyright 2011 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/pci.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/paccess.h>

#include <bl234x_cpu.h>
#include <bl234x_regs.h>
#include <bl234x_io.h>
#include <bl234x_irq.h>
#include <BL234x_ic.h>
#include <BL234x_pci.h>

int pcibios_plat_dev_init(struct pci_dev *dev)
{
    return 0;
}

int __init pcibios_map_irq(const struct pci_dev *dev, u8 slot, u8 pin)
{
	pi_bl234x_pci_drv_set_int_mask(CE_PCI_INT_A + dev->pin - 1, 1);
	return dev->pin + bl234x_get_irq_number(IRQ_PCI_MSI ) - 1;
}

static void bl234x_pci_fixup(struct pci_dev *d)
{

	struct pci_bus *b = d->bus;
	struct list_head *ln;
	int pos;

    
	for (ln = b->devices.next; ln != &b->devices; ln = ln->next) 
	{
		d = pci_dev_b(ln);

		/* fixing up resource bases */
		for (pos = 0; pos < 5; pos++)  {
			if (d->resource[pos].start) {
				d->resource[pos].end |= 0xa0000000;
				d->resource[pos].start |= 0xa0000000;
			}
		}
	}
		 
    set_io_port_base(0);
}
DECLARE_PCI_FIXUP_FINAL(PCI_ANY_ID, PCI_ANY_ID, bl234x_pci_fixup);

