/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/pci.h>
#include <linux/clk.h>
#include <linux/platform_device.h>
#include <bcm63268_cpu.h>
#include <bcm63268_regs.h>
#include <bcm63268_io.h>
#include <bcm63268_pcie.h>

#if defined(CONFIG_BCM_PWRMNGT) || defined(CONFIG_BCM_PWRMNGT_MODULE)
static int pcie_power_saving_enable = 0;
#endif /* CONFIG_BCM_PWRMNGT */

int __init pcibios_map_irq(const struct pci_dev *dev, u8 slot, u8 pin)
{
#if defined(CONFIG_BCM_PWRMNGT) || defined(CONFIG_BCM_PWRMNGT_MODULE)
	u32 reg_val;
#endif /* CONFIG_BCM_PWRMNGT */

	if (dev->bus->number == BCM63268_PCIE_BUS_ROOT) {
		return bcm63268_get_irq_number(IRQ_PCIE_EP);
	} else if (dev->bus->number == BCM63268_PCIE_BUS_DEV) {
#if defined(CONFIG_BCM_PWRMNGT) || defined(CONFIG_BCM_PWRMNGT_MODULE)
		if (!pcie_power_saving_enable) {
			reg_val = bcm_pcie_readl(PCIE_BLOCK_1800_PHY_CTLx_REG(1));
			reg_val |= PCIE_BLOCK_1800_PHY_CTL_PD_P1PLL_ENABLE;
			bcm_pcie_writel(reg_val, PCIE_BLOCK_1800_PHY_CTLx_REG(1));
			pcie_power_saving_enable = 1;
		}
#endif /* CONFIG_BCM_PWRMNGT || CONFIG_BCM_PWRMNGT_MODULE */
		return bcm63268_get_irq_number(IRQ_PCIE_RC);
	} else if (dev->bus->number == BCM63268_PCI_BUS) {
		switch (slot) {
			case BCM63268_PCI_WOC_SLOT:
				return bcm63268_get_irq_number(IRQ_WLAN);
				break;
#if defined(CONFIG_USB) || defined(CONFIG_USB_MODULE)
			case BCM63268_PCI_USB11H_SLOT:
				return bcm63268_get_irq_number(IRQ_USB_OHCI);
				break;

			case BCM63268_PCI_USB20H_SLOT:
				return bcm63268_get_irq_number(IRQ_USB_EHCI);
				break;
#endif /* CONFIG_USB || CONFIG_USB_MODULE */

			default:
				return -1;
				break;
		}
	}

	return -1;
}

int pcibios_plat_dev_init(struct pci_dev *dev)
{
	return 0;
}

static void bcm63268_pci_fixup_header(struct pci_dev *dev)
{
	u32 memaddr;
	u32 size;

	memaddr = pci_resource_start(dev, 0);
	size = pci_resource_len(dev, 0);

	if (dev->bus->number == BCM63268_PCI_BUS) {
		switch (PCI_SLOT(dev->devfn)) {
			case BCM63268_PCI_WOC_SLOT:
				/* prevent linux from reallocating resources */
				dev->resource[0].flags |= IORESOURCE_PCI_FIXED;
				break;
#if defined(CONFIG_USB) || defined(CONFIG_USB_MODULE)
			case BCM63268_PCI_USB11H_SLOT:
				/* prevent linux from reallocating resources */
				dev->resource[0].flags |= IORESOURCE_PCI_FIXED;
				break;

			case BCM63268_PCI_USB20H_SLOT:
				/* prevent linux from reallocating resources */
				dev->resource[0].flags |= IORESOURCE_PCI_FIXED; 
				break;
#endif /* CONFIG_USB || CONFIG_USB_MODULE */
		}
	}
}
DECLARE_PCI_FIXUP_HEADER(PCI_ANY_ID, PCI_ANY_ID, bcm63268_pci_fixup_header);

#if 0
static void bcm63268_pci_fixup_final(struct pci_dev *dev)
{
	if (dev->bus->number == BCM63268_PCIE_BUS_DEV) {
		switch (PCI_SLOT(dev->devfn)) {
			case BCM63268_PCI_WOC_SLOT:
				if(((dev->device<<16)|dev->vendor) == BCM63268_PCI_WOC_ID) {
					dev->resource[0].end = CPHYSADDR((bcm63268_regset_address(RSET_WLAN) + RSET_WLAN_SIZE - 1));
					dev->resource[0].start = CPHYSADDR((bcm63268_regset_address(RSET_WLAN)));
				}
				break;
		}
	}
}
DECLARE_PCI_FIXUP_FINAL(PCI_ANY_ID, PCI_ANY_ID, bcm63268_pci_fixup_final);
#endif

