/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#include <linux/clocksource.h>
#include <linux/init.h>

#include <asm/time.h>
#include <bcm632x_cpu.h>
#include <bcm632x_io.h>
#include <bcm632x_regs.h>

static cycle_t bcm632x_timer_hpt_read(struct clocksource *cs)
{
    return bcm_timer_readl(TIMER_CNT2_REG);
}

static struct clocksource clocksource_mips = {
	.name		= "MIPS",
	.read		= bcm632x_timer_hpt_read,
	.mask		= CLOCKSOURCE_MASK(30),
	.flags		= CLOCK_SOURCE_IS_CONTINUOUS,
};

int __init init_r4k_clocksource(void)
{
	if (!cpu_has_counter || !mips_hpt_frequency)
		return -ENXIO;

	/* Calculate a somewhat reasonable rating value */
	clocksource_mips.rating = 300;

	clocksource_set_clock(&clocksource_mips, 50000000);

	clocksource_register(&clocksource_mips);

	return 0;
}

