#ifndef __BCM63268_TIMER_H__
#define __BCM63268_TIMER_H__

#define TIMER_T0_ID				0
#define TIMER_T1_ID				1
#define TIMER_T2_ID				2
#define TIMER_WDT_ID			3

typedef void (* bcm_timer_hook_func_t)(u32 stat, void *data);

int bcm63268_timer_init(void);
int bcm63268_timer_register(int id, bcm_timer_hook_func_t callback, void *data);
void bcm63268_timer_unregister(int id);
int bcm63268_timer_set(int id, int monotonic, int direct_timerval, unsigned int countdown_us);
int bcm63268_timer_enable(int id, int intr);
int bcm63268_timer_disable(int id);
unsigned int bcm63268_timer_countdown(unsigned int countdown_us);
int bcm63268_timer_is_mytimer(u32 stat, int id);
void bcm63268_timer_clear(int id);

#define bcm_timer_is_mytimer	bcm63268_timer_is_mytimer
#define bcm_timer_clear			bcm63268_timer_clear
#define bcm_timer_set			bcm63268_timer_set
#define bcm_timer_enable		bcm63268_timer_enable
#define bcm_timer_disable		bcm63268_timer_disable
#define bcm_timer_register		bcm63268_timer_register
#define bcm_timer_unregister	bcm63268_timer_unregister

#endif /* !__BCM63268_TIMER_H__ */

