#ifndef BCM63268_REGS_H_
#define BCM63268_REGS_H_

#define _DD_MAKEMASK1(n) (1 << (n))
#define _DD_MAKEMASK(v,n) ((((1)<<(v))-1) << (n))
#define _DD_MAKEVALUE(v,n) ((v) << (n))

/*************************************************************************
 * _REG relative to RSET_PERF
 *************************************************************************/

/* Chip Identifier / Revision register */
#define PERF_REV_REG			0x0
#define REV_CHIPID_SHIFT		12
#define REV_CHIPID_MASK			(0xfffff << REV_CHIPID_SHIFT)
#define REV_REVID_SHIFT			0
#define REV_REVID_MASK			(0xff << REV_REVID_SHIFT)

/* Clock Control register */
#define PERF_CKCTL_REG			0x4

/* 63268 */
#define CKCTL_63268_GLESS_DIS			(1 << 0)
#define CKCTL_63268_VDSL_QPROC_EN		(1 << 1)
#define CKCTL_63268_VDSL_AFE_EN			(1 << 2)
#define CKCTL_63268_VDSL_EN				(1 << 3)
#define CKCTL_63268_MIPS_EN				(1 << 4)
#define CKCTL_63268_WOC_EN				(1 << 5)
#define CKCTL_63268_DECT_EN				(1 << 6)
#define CKCTL_63268_FAP0_EN				(1 << 7)
#define CKCTL_63268_FAP1_EN				(1 << 8)
#define CKCTL_63268_SAR_EN				(1 << 9)
#define CKCTL_63268_ROBOSW_EN			(1 << 10)
#define CKCTL_63268_PCM_EN				(1 << 11)
#define CKCTL_63268_USBD_EN				(1 << 12)
#define CKCTL_63268_USBH_EN				(1 << 13)
#define CKCTL_63268_IPSEC_EN			(1 << 14)
#define CKCTL_63268_LSSPI_EN			(1 << 15)
#define CKCTL_63268_HSSPI_EN			(1 << 16)
#define CKCTL_63268_PCIE_EN				(1 << 17)
#define CKCTL_63268_PHYMIPS_EN			(1 << 18)
#define CKCTL_63268_GMAC_EN				(1 << 19)
#define CKCTL_63268_NAND_EN				(1 << 20)
#define CKCTL_63268_TBUS_EN				(1 << 27)
#define CKCTL_63268_ROBOSW250_EN		(1 << 31)

#define CKCTL_63268_ALL_SAFE_EN	(CKCTL_63268_ROBOSW_EN |	\
					CKCTL_63268_HSSPI_EN |	CKCTL_63268_MIPS_EN | \
					CKCTL_63268_VDSL_EN |	CKCTL_63268_PHYMIPS_EN)

/* PLL control register */
#define PERF_PLLCTRL_REG		0x8
#define PLLCTRL_RESET			0x1

/* Soft Reset register */
#define PERF_SOFTRESET_REG		0x10

#define SOFTRESET_63268_HSSPI				(1 << 0)
#define SOFTRESET_63268_IPSEC				(1 << 1)
#define SOFTRESET_63268_EPHY				(1 << 2)
#define SOFTRESET_63268_SAR					(1 << 3)
#define SOFTRESET_63268_ROBOSW				(1 << 4)
#define SOFTRESET_63268_USBD				(1 << 5)
#define SOFTRESET_63268_USBH				(1 << 6)
#define SOFTRESET_63268_PCM					(1 << 7)
#define SOFTRESET_63268_PCIE_CORE			(1 << 8)
#define SOFTRESET_63268_PCIE				(1 << 9)
#define SOFTRESET_63268_PCIE_EXT			(1 << 10)
#define SOFTRESET_63268_WLAN_SHIM			(1 << 11)
#define SOFTRESET_63268_DDR_PHY				(1 << 12)
#define SOFTRESET_63268_FAP0				(1 << 13)
#define SOFTRESET_63268_WLAN_SHIM_UBUS		(1 << 14)
#define SOFTRESET_63268_DECT				(1 << 15)
#define SOFTRESET_63268_FAP1				(1 << 16)
#define SOFTRESET_63268_PCIE_HARD			(1 << 17)
#define SOFTRESET_63268_GPHY				(1 << 18)

#define SOFTRESET_63268_ALL	(SOFTRESET_63268_HSSPI |		\
					SOFTRESET_63268_EPHY |		\
					SOFTRESET_63268_GPHY |		\
					SOFTRESET_63268_ROBOSW)

/* Interrupt Mask register */
#define PERF_EXT_IRQMASK_HI_REG	0x20
#define PERF_EXT_IRQMASK_LO_REG	0x24
#define PERF_IRQMASK_HI_REG		0x28
#define PERF_IRQMASK_LO_REG		0x2c
#define PERF_EXT_IRQSTAT_HI_REG	0x30
#define PERF_EXT_IRQSTAT_LO_REG	0x34
#define PERF_IRQSTAT_HI_REG		0x38
#define PERF_IRQSTAT_LO_REG		0x3c

/* External Interrupt Configuration register */
#define PERF_EXTIRQ_CFG_REG		0x18
#define EXTIRQ_CFG_SENSE(x)		(1 << (x))
#define EXTIRQ_CFG_STAT(x)		(1 << (x + 4))
#define EXTIRQ_CFG_CLEAR(x)		(1 << (x + 8))
#define EXTIRQ_CFG_MASK(x)		(1 << (x + 12))
#define EXTIRQ_CFG_BOTHEDGE(x)	(1 << (x + 16))
#define EXTIRQ_CFG_LEVELSENSE(x)(1 << (x + 20))

/* MISC Serdes Control register */
#define MISC_SERDESCTL_REG						0x04
#define MISCSERDESCTL_PCIE_ENABLE				(1 << 0)
#define MISCSERDESCTL_PCIE_EXD_ENABLE			(1 << 15)

/* MISC Strap Bus register */
#define MISC_STRAPBUS_REG						0x14
#define MISCSTRAPBUS_MIPS_PLL_FVCO_SHIFT		21
#define MISCSTRAPBUS_MIPS_PLL_FVCO_MASK			(0xf << MISCSTRAPBUS_MIPS_PLL_FVCO_SHIFT)
#define MISCSTRAPBUS_MIPS_PLL_USE_LOCK_SHIFT	17
#define MISCSTRAPBUS_MIPS_PLL_USE_LOCK_MASK		(1 << MISCSTRAPBUS_MIPS_PLL_USE_LOCK_SHIFT)

#define MISC_STRAPOVERRIDE_REG					0x18

#define MISC_VREG_CTRL0_REG						0x1c
#define MISC_VREG_CTRL1_REG						0x20
#define MISC_VREG_CTRL2_REG						0x24

#define MISC_VREG_CTRL0_VSEL1P2_SHIFT			0
#define MISC_VREG_CTRL0_VSEL1P2_MASK			0x1f
#define MISC_VREG_CTRL0_VSEL1P2_MIDDLE			0x0f
#define MISC_VREG_CTRL0_RESET					(1 << 31)
#define MISC_VREG_CTRL0_POWER_DOWN2				(1 << 30)
#define MISC_VREG_CTRL0_POWER_DOWN1				(1 << 29)

/* MISC IDDQ Control register */
#define MISC_IDDQCTL_REG						0x4c
#define MISCIDDQCTL_SAR							(1 << 0)
#define MISCIDDQCTL_IPSEC						(1 << 1)
#define MISCIDDQCTL_MIPS						(1 << 2)
#define MISCIDDQCTL_DECT						(1 << 3)
#define MISCIDDQCTL_USBH						(1 << 4)
#define MISCIDDQCTL_USBD						(1 << 5)
#define MISCIDDQCTL_ROBOSW						(1 << 6)
#define MISCIDDQCTL_PCM							(1 << 7)
#define MISCIDDQCTL_PERIPHERAL					(1 << 8)
#define MISCIDDQCTL_VDSL_PHY					(1 << 9)
#define MISCIDDQCTL_VDSL_MIPS					(1 << 10)
#define MISCIDDQCTL_FAP							(1 << 11)
#define MISCIDDQCTL_PCIE						(1 << 12)
#define MISCIDDQCTL_WLAN_PADS					(1 << 13)
#define MISCIDDQCTL_GMAC						(1 << 18)

/*************************************************************************
 * _REG relative to RSET_TIMER
 *************************************************************************/

#define BCM63268_TIMER_COUNT		4

/* Timer irqstat register */
#define TIMER_IRQSTAT_REG		0
#define TIMER_IRQSTAT_TIMER_CAUSE(x)	(1 << (x))
#define TIMER_IRQSTAT_TIMER0_CAUSE	(1 << 0)
#define TIMER_IRQSTAT_TIMER1_CAUSE	(1 << 1)
#define TIMER_IRQSTAT_TIMER2_CAUSE	(1 << 2)
#define TIMER_IRQSTAT_WDT_CAUSE		(1 << 3)
#define TIMER_IRQSTAT_TIMER_IR_EN(x)	(1 << ((x) + 8))
#define TIMER_IRQSTAT_TIMER0_IR_EN	(1 << 8)
#define TIMER_IRQSTAT_TIMER1_IR_EN	(1 << 9)
#define TIMER_IRQSTAT_TIMER2_IR_EN	(1 << 10)

/* Timer control register */
#define TIMER_CTLx_REG(x)		(0x4 + (x * 4))
#define TIMER_CTL0_REG			0x4
#define TIMER_CTL1_REG			0x8
#define TIMER_CTL2_REG			0xC
#define TIMER_CTL_COUNTDOWN_MASK	(0x3fffffff)
#define TIMER_CTL_MONOTONIC_MASK	(1 << 30)
#define TIMER_CTL_ENABLE_MASK		(1 << 31)

/* Timer count register */
#define TIMER_CNTx_REG(x)		(0x10 + (x * 4))
#define TIMER_CNT0_REG			0x10
#define TIMER_CNT1_REG			0x14
#define TIMER_CNT2_REG			0x18

/* Timer soft-reset register */
#define TIMER_SOFT_RESET_REG	0x28
#define TIMER_SOFT_RESET		0x1

/* Timer clock-reset register */
#define TIMER_CLK_RESET_REG		0x2c
#define TIMER_CLK_RESET_EPHY0_ENERGY		(1 << 0)
#define TIMER_CLK_RESET_EPHY1_ENERGY		(1 << 1)
#define TIMER_CLK_RESET_EPHY2_ENERGY		(1 << 2)
#define TIMER_CLK_RESET_GPHY0_ENERGY		(1 << 3)
#define TIMER_CLK_RESET_DSL_ENERGY_DETECT	(1 << 4)
#define TIMER_CLK_RESET_WAKEON_EPHY			(1 << 5)
#define TIMER_CLK_RESET_WAKEON_DSL			(1 << 6)
#define TIMER_CLK_RESET_FAP0_PLL_FREQ_SHIFT	8
#define TIMER_CLK_RESET_FAP0_PLL_FREQ_MASK	(0x7 << TIMER_CLK_RESET_FAP0_PLL_FREQ_SHIFT)
#define TIMER_CLK_RESET_FAP0_PLL_CLK_ENABLE	(1 << 11)
#define TIMER_CLK_RESET_FAP1_PLL_FREQ_SHIFT	12
#define TIMER_CLK_RESET_FAP1_PLL_FREQ_MASK	(0x7 << TIMER_CLK_RESET_FAP1_PLL_FREQ_SHIFT)
#define TIMER_CLK_RESET_FAP1_PLL_CLK_ENABLE	(1 << 15)
#define TIMER_CLK_RESET_USB_REFCLK_ENABLE	(1 << 18)

/*************************************************************************
 * _REG relative to RSET_WDT
 *************************************************************************/

/* Watchdog default count register */
#define WDT_DEFVAL_REG			0x0

/* Watchdog control register */
#define WDT_CTL_REG			0x4

/* Watchdog control register constants */
#define WDT_START_1			(0xff00)
#define WDT_START_2			(0x00ff)
#define WDT_STOP_1			(0xee00)
#define WDT_STOP_2			(0x00ee)

/* Watchdog reset length register */
#define WDT_RSTLEN_REG			0x8

/*************************************************************************
 * _REG relative to RSET_HSSPI
 *************************************************************************/

/* BCM 63268 High-Speed SPI core */
#define HSSPI_BCM_63268_GLOBAL_CTL_REG			0x000
#define HSSPI_BCM_63268_EXT_TRIG_REG			0x004
#define HSSPI_BCM_63268_INT_ST_REG				0x008
#define HSSPI_BCM_63268_INT_MASK_ST_REG			0x00c
#define HSSPI_BCM_63268_INT_MASK_REG			0x010
#define HSSPI_BCM_63268_FLASH_CTL_REG			0x014
#define HSSPI_BCM_63268_FLASH_ADDR_BASE_REG		0x018
#define HSSPI_BCM_63268_PINGPONG0_CMD_REG		0x080
#define HSSPI_BCM_63268_PINGPONG0_STS_REG		0x084
#define HSSPI_BCM_63268_PINGPONG0_FIFO_STS_REG	0x088
#define HSSPI_BCM_63268_PINGPONG0_CTL_REG		0x08c
#define HSSPI_BCM_63268_PROFILES0_CLK_CTL_REG	0x100
#define HSSPI_BCM_63268_PROFILES0_MODE_CTL_REG	0x108
#define HSSPI_BCM_63268_FIFO_SIZE				0x1FE
#define HSSPI_BCM_63268_FIFO0					0x200

/*************************************************************************
 * _REG relative to RSET_USB_CTRL
 *************************************************************************/
 /* USB2.0H Control Register */
#define USB_CTRL_UTIMCTL_REG				0x10
#define USB_CTRL_UTIMCTL_DEV_MODE			(1 << 0)

#define USB_CTRL_TESTPORT_REG				0x14

#define USB_CTRL_PLLCTL_REG					0x18
#define USB_CTRL_PLLCTL_REFCLKSEL_SHIFT		0
#define USB_CTRL_PLLCTL_REFCLKSEL_MASK		(0x3 << USB_CTRL_PLLCTL_REFCLKSEL_SHIFT)
#define USB_CTRL_PLLCTL_CLKSEL_SHIFT		2
#define USB_CTRL_PLLCTL_CLKSEL_MASK			(0x3 << USB_CTRL_PLLCTL_CLKSEL_SHIFT)
#define USB_CTRL_XTAL_POWER_DOWN			(1 << 4)
#define USB_CTRL_PLL_POWER_DOWN				(1 << 5)
#define USB_CTRL_PLL_CAL_EN					(1 << 6)
#define USB_CTRL_PLL_PHY_BYPASS				(1 << 7)
#define USB_CTRL_PLL_RESET					(1 << 8)
#define USB_CTRL_PLL_IDDQ_POWER_DOWN		(1 << 9)
#define USB_CTRL_PLL_POWER_DOWN_DELAY		(1 << 10)

#define USB_CTRL_SWAPCTL_REG				0x1c
#define USB_CTRL_SWAPCTL_OHCI_DATA_SWAP		(1 << 0)
#define USB_CTRL_SWAPCTL_OHCI_ENDIAN_SWAP	(1 << 1)
#define USB_CTRL_SWAPCTL_OHCI_LOGICAL_ADDR	(1 << 2)
#define USB_CTRL_SWAPCTL_EHCI_DATA_SWAP		(1 << 3)
#define USB_CTRL_SWAPCTL_EHCI_ENDIAN_SWAP	(1 << 4)
#define USB_CTRL_SWAPCTL_EHCI_LOGICAL_ADDR	(1 << 5)
#define USB_CTRL_SWAPCTL_USB_DEVICE_SEL		(1 << 6)

#define USB_CTRL_GENERICCTL_REG				0x20
#define USB_CTRL_GENERICCTL_PLL_SUSPEND		(1 << 1)

#define USB_CTRL_SETUP_REG					0x28
#define USB_CTRL_SETUP_USBH_IPP				(1 << 5)
#define USB_CTRL_SETUP_USBH_IOC				(1 << 4)

#define USB_CTRL_SIMCTL_REG					0x34
#define USB_CTRL_SIMCTL_MEM_REQ_DIS			(1 << 1)

/*************************************************************************
 * _REG relative to RSET_UARTx
 *************************************************************************/

/* UART Control Register */
#define UART_CTL_REG				0x0
#define UART_CTL_RXTMOUTCNT_SHIFT	0
#define UART_CTL_RXTMOUTCNT_MASK	(0x1f << UART_CTL_RXTMOUTCNT_SHIFT)
#define UART_CTL_RSTTXDN_SHIFT		5
#define UART_CTL_RSTTXDN_MASK		(1 << UART_CTL_RSTTXDN_SHIFT)
#define UART_CTL_RSTRXFIFO_SHIFT	6
#define UART_CTL_RSTRXFIFO_MASK		(1 << UART_CTL_RSTRXFIFO_SHIFT)
#define UART_CTL_RSTTXFIFO_SHIFT	7
#define UART_CTL_RSTTXFIFO_MASK		(1 << UART_CTL_RSTTXFIFO_SHIFT)
#define UART_CTL_STOPBITS_SHIFT		8
#define UART_CTL_STOPBITS_MASK		(0xf << UART_CTL_STOPBITS_SHIFT)
#define UART_CTL_STOPBITS_1			(0x7 << UART_CTL_STOPBITS_SHIFT)
#define UART_CTL_STOPBITS_2			(0xf << UART_CTL_STOPBITS_SHIFT)
#define UART_CTL_BITSPERSYM_SHIFT	12
#define UART_CTL_BITSPERSYM_MASK	(0x3 << UART_CTL_BITSPERSYM_SHIFT)
#define UART_CTL_XMITBRK_SHIFT		14
#define UART_CTL_XMITBRK_MASK		(1 << UART_CTL_XMITBRK_SHIFT)
#define UART_CTL_RSVD_SHIFT			15
#define UART_CTL_RSVD_MASK			(1 << UART_CTL_RSVD_SHIFT)
#define UART_CTL_RXPAREVEN_SHIFT	16
#define UART_CTL_RXPAREVEN_MASK		(1 << UART_CTL_RXPAREVEN_SHIFT)
#define UART_CTL_RXPAREN_SHIFT		17
#define UART_CTL_RXPAREN_MASK		(1 << UART_CTL_RXPAREN_SHIFT)
#define UART_CTL_TXPAREVEN_SHIFT	18
#define UART_CTL_TXPAREVEN_MASK		(1 << UART_CTL_TXPAREVEN_SHIFT)
#define UART_CTL_TXPAREN_SHIFT		18
#define UART_CTL_TXPAREN_MASK		(1 << UART_CTL_TXPAREN_SHIFT)
#define UART_CTL_LOOPBACK_SHIFT		20
#define UART_CTL_LOOPBACK_MASK		(1 << UART_CTL_LOOPBACK_SHIFT)
#define UART_CTL_RXEN_SHIFT			21
#define UART_CTL_RXEN_MASK			(1 << UART_CTL_RXEN_SHIFT)
#define UART_CTL_TXEN_SHIFT			22
#define UART_CTL_TXEN_MASK			(1 << UART_CTL_TXEN_SHIFT)
#define UART_CTL_BRGEN_SHIFT		23
#define UART_CTL_BRGEN_MASK			(1 << UART_CTL_BRGEN_SHIFT)

/* UART Baudword register */
#define UART_BAUD_REG					0x4

/* UART Misc Control register */
#define UART_MCTL_REG					0x8
#define UART_MCTL_DTR_SHIFT				0
#define UART_MCTL_DTR_MASK				(1 << UART_MCTL_DTR_SHIFT)
#define UART_MCTL_RTS_SHIFT				1
#define UART_MCTL_RTS_MASK				(1 << UART_MCTL_RTS_SHIFT)
#define UART_MCTL_RXFIFOTHRESH_SHIFT	8
#define UART_MCTL_RXFIFOTHRESH_MASK		(0xf << UART_MCTL_RXFIFOTHRESH_SHIFT)
#define UART_MCTL_TXFIFOTHRESH_SHIFT	12
#define UART_MCTL_TXFIFOTHRESH_MASK		(0xf << UART_MCTL_TXFIFOTHRESH_SHIFT)
#define UART_MCTL_RXFIFOFILL_SHIFT		16
#define UART_MCTL_RXFIFOFILL_MASK		(0x1f << UART_MCTL_RXFIFOFILL_SHIFT)
#define UART_MCTL_TXFIFOFILL_SHIFT		24
#define UART_MCTL_TXFIFOFILL_MASK		(0x1f << UART_MCTL_TXFIFOFILL_SHIFT)

/* UART External Input Configuration register */
#define UART_EXTINP_REG					0xc
#define UART_EXTINP_RI_SHIFT			0
#define UART_EXTINP_RI_MASK				(1 << UART_EXTINP_RI_SHIFT)
#define UART_EXTINP_CTS_SHIFT			1
#define UART_EXTINP_CTS_MASK			(1 << UART_EXTINP_CTS_SHIFT)
#define UART_EXTINP_DCD_SHIFT			2
#define UART_EXTINP_DCD_MASK			(1 << UART_EXTINP_DCD_SHIFT)
#define UART_EXTINP_DSR_SHIFT			3
#define UART_EXTINP_DSR_MASK			(1 << UART_EXTINP_DSR_SHIFT)
#define UART_EXTINP_IRSTAT(x)			(1 << (x + 4))
#define UART_EXTINP_IRMASK(x)			(1 << (x + 8))
#define UART_EXTINP_IR_RI				0
#define UART_EXTINP_IR_CTS				1
#define UART_EXTINP_IR_DCD				2
#define UART_EXTINP_IR_DSR				3
#define UART_EXTINP_RI_NOSENSE_SHIFT	16
#define UART_EXTINP_RI_NOSENSE_MASK		(1 << UART_EXTINP_RI_NOSENSE_SHIFT)
#define UART_EXTINP_CTS_NOSENSE_SHIFT	17
#define UART_EXTINP_CTS_NOSENSE_MASK	(1 << UART_EXTINP_CTS_NOSENSE_SHIFT)
#define UART_EXTINP_DCD_NOSENSE_SHIFT	18
#define UART_EXTINP_DCD_NOSENSE_MASK	(1 << UART_EXTINP_DCD_NOSENSE_SHIFT)
#define UART_EXTINP_DSR_NOSENSE_SHIFT	19
#define UART_EXTINP_DSR_NOSENSE_MASK	(1 << UART_EXTINP_DSR_NOSENSE_SHIFT)

/* UART Interrupt register */
#define UART_IR_REG				0x10
#define UART_IR_MASK(x)			(1 << (x + 16))
#define UART_IR_STAT(x)			(1 << (x))
#define UART_IR_EXTIP			0
#define UART_IR_TXUNDER			1
#define UART_IR_TXOVER			2
#define UART_IR_TXTRESH			3
#define UART_IR_TXRDLATCH		4
#define UART_IR_TXEMPTY			5
#define UART_IR_RXUNDER			6
#define UART_IR_RXOVER			7
#define UART_IR_RXTIMEOUT		8
#define UART_IR_RXFULL			9
#define UART_IR_RXTHRESH		10
#define UART_IR_RXNOTEMPTY		11
#define UART_IR_RXFRAMEERR		12
#define UART_IR_RXPARERR		13
#define UART_IR_RXBRK			14
#define UART_IR_TXDONE			15

/* UART Fifo register */
#define UART_FIFO_REG				0x14
#define UART_FIFO_VALID_SHIFT		0
#define UART_FIFO_VALID_MASK		0xff
#define UART_FIFO_FRAMEERR_SHIFT	8
#define UART_FIFO_FRAMEERR_MASK		(1 << UART_FIFO_FRAMEERR_SHIFT)
#define UART_FIFO_PARERR_SHIFT		9
#define UART_FIFO_PARERR_MASK		(1 << UART_FIFO_PARERR_SHIFT)
#define UART_FIFO_BRKDET_SHIFT		10
#define UART_FIFO_BRKDET_MASK		(1 << UART_FIFO_BRKDET_SHIFT)
#define UART_FIFO_ANYERR_MASK		(UART_FIFO_FRAMEERR_MASK |	\
										UART_FIFO_PARERR_MASK |		\
										UART_FIFO_BRKDET_MASK)

/*************************************************************************
 * _REG relative to RSET_NAND
 *************************************************************************/
#define NAND_CTRL_REVISION			0x00
#define NAND_CTRL_CMD_START			0x04
#define NAND_CTRL_CMD_EXTADDR			0x08
#define NAND_CTRL_CMD_ADDR			0x0c
#define NAND_CTRL_CMD_ENDADDR			0x10
#define NAND_CTRL_CS_SELECT			0x14
#define NAND_CTRL_CS_XOR				0x18
#define NAND_CTRL_OOB_READ_OFFSET0	0x20
#define NAND_CTRL_OOB_READ_OFFSET4	0x24
#define NAND_CTRL_OOB_READ_OFFSET8	0x28
#define NAND_CTRL_OOB_READ_OFFSETC	0x2c
#define NAND_CTRL_OOB_READ_OFFSET(x)	(0x20 + (x * 4))
#define NAND_CTRL_OOB_WRITE_OFFSET0	0x30
#define NAND_CTRL_OOB_WRITE_OFFSET4	0x34
#define NAND_CTRL_OOB_WRITE_OFFSET8	0x38
#define NAND_CTRL_OOB_WRITE_OFFSETC	0x3c
#define NAND_CTRL_OOB_WRITE_OFFSET(x)	(0x30 + (x * 4))
#define NAND_CTRL_ACCESS_CTRL			0x40
#define NAND_CTRL_CONFIG				0x48
#define NAND_CTRL_TIMING1				0x50
#define NAND_CTRL_TIMING2				0x54
#define NAND_CTRL_SEMAPHORE			0x58
#define NAND_CTRL_DEVICEID			0x60
#define NAND_CTRL_DEVICEID_EXT		0x64
#define NAND_CTRL_LOCKSTATUS			0x68
#define NAND_CTRL_INTFSTATUS			0x6c
#define NAND_CTRL_ECC_CORR_EXTADDR	0x70
#define NAND_CTRL_ECC_CORR_ADDR		0x74
#define NAND_CTRL_ECC_UNCORR_EXTADDR	0x78
#define NAND_CTRL_ECC_UNCORR_ADDR		0x7c
#define NAND_CTRL_READ_ERR_COUNT		0x80
#define NAND_CTRL_CORR_STAT_THRESHOLD	0x84
#define NAND_CTRL_ONFI_STATUS			0x88
#define NAND_CTRL_ONFI_DEBUG_DATA		0x8c
#define NAND_CTRL_READ_EXTADDR		0x90
#define NAND_CTRL_READ_ADDR			0x94
#define NAND_CTRL_PROGPAGE_EXTADDR	0x98
#define NAND_CTRL_PROGPAGE_ADDR		0x9c
#define NAND_CTRL_COPYBACK_EXTADDR	0xa0
#define NAND_CTRL_COPYBACK_ADDR		0xa4
#define NAND_CTRL_BLOCKERASE_EXTADDR	0xa8
#define NAND_CTRL_BLOCKERASE_ADDR		0xac
#define NAND_CTRL_INVALIDREAD_EXTADDR	0xb0
#define NAND_CTRL_INVALIDREAD_ADDR	0xb4
#define NAND_CTRL_WRITE_PROTECT		0xc0
#define NAND_CTRL_ACCESS_CTRL_CS1		0xd0
#define NAND_CTRL_CONFIG_CS1			0xd4
#define NAND_CTRL_TIMING1_CS1			0xd8
#define NAND_CTRL_TIMING2_CS1			0xdc
#define NAND_CTRL_ACCESS_CTRL_CS2		0xe0
#define NAND_CTRL_CONFIG_CS2			0xe4
#define NAND_CTRL_TIMING1_CS2			0xe8
#define NAND_CTRL_TIMING2_CS2			0xec
#define NAND_CTRL_OOB_READ_OFFSET10	0x120
#define NAND_CTRL_OOB_READ_OFFSET14	0x124
#define NAND_CTRL_OOB_READ_OFFSET18	0x128
#define NAND_CTRL_OOB_READ_OFFSET1C	0x12c

/*************************************************************************
 * _REG relative to RSET_GPIO
 *************************************************************************/
/* GPIO registers */
#define GPIO_CTL_HI_REG			0x0
#define GPIO_CTL_LO_REG			0x4
#define GPIO_DATA_HI_REG		0x8
#define GPIO_DATA_LO_REG		0xC
#define GPIO_MODE_REG			0x18
#define GPIO_BASEMODE_REG		0x38
#define GPIO_ROBOSW_EPHY_CTRL	0x3C
#define GPIO_RING_OSC_CTRL0		0x48
#define GPIO_RING_OSC_CTRL1		0x4C

#define GPIO_BASEMODE_VDSL_PHY_OVERRIDE_1	(1 << 7)
#define GPIO_BASEMODE_VDSL_PHY_OVERRIDE_0	(1 << 6)

#define GPIO_ROWOSW_EPHY_PWR_DOWN_DLL		(1 << 25)

#define GPIO_RING_OSC_CTRL0_32_CYCLES			5
#define GPIO_RING_OSC_CTRL0_64_CYCLES			6
#define GPIO_RING_OSC_CTRL0_128_CYCLES			7
#define GPIO_RING_OSC_CTRL0_256_CYCLES			8
#define GPIO_RING_OSC_CTRL0_512_CYCLES			9
#define GPIO_RING_OSC_CTRL0_1024_CYCLES			10

#define GPIO_RING_OSC_MAX						8
#define GPIO_RING_OSC_CTRL1_COUNT_BUSY			(1 << 16)
#define GPIO_RING_OSC_CTRL1_COUNT_OVERFLOW		(1 << 17)
#define GPIO_RING_OSC_CTRL1_COUNT_MASK			0x0000ffff
#define GPIO_RING_OSC_CTRL1_IRQ					(1 << 18)
#define GPIO_RING_OSC_CTRL1_SELECT_MASK			(0x7 << GPIO_RING_OSC_CTRL1_SELECT_SHIFT)
#define GPIO_RING_OSC_CTRL1_SELECT_SHIFT		20
#define GPIO_RING_OSC_CTRL1_COUNT_RESET			(1 << 23)
#define GPIO_RING_OSC_CTRL1_ENABLE_MASK			(0xff << GPIO_RING_OSC_CTRL1_ENABLE_SHIFT)
#define GPIO_RING_OSC_CTRL1_ENABLE_SHIFT		24

/*************************************************************************
 * _REG relative to RSET_LED
 *************************************************************************/
#define LED_INIT_REG			0x0
#define LED_MODE_HI_REG			0x4
#define LED_MODE_LO_REG			0x8
#define LED_HWDIS_REG			0xc

/*************************************************************************
 * _REG relative to RSET_PCIE
 *************************************************************************/
#define PCIE_BLOCK_404_CFG2_REG				0x0408
#define PCIE_BLOCK_404_CFG2_BAR1_SIZE_MASK	0xf

#define PCIE_BLOCK_428_IDVAL3_REG					0x043C
#define PCIE_BLOCK_428_IDVAL3_PROG_IF_SHIFT			0
#define PCIE_BLOCK_428_IDVAL3_PROG_IF_MASK			0xff
#define PCIE_BLOCK_428_IDVAL3_SUB_CLS_CODE_SHIFT	8
#define PCIE_BLOCK_428_IDVAL3_SUB_CLS_CODE_MASK		(0xff << PCIE_BLOCK_428_IDVAL3_SUB_CLS_CODE_SHIFT)
#define PCIE_BLOCK_428_IDVAL3_CLS_CODE_SHIFT		16
#define PCIE_BLOCK_428_IDVAL3_CLS_CODE_MASK			(0xff << PCIE_BLOCK_428_IDVAL3_CLS_CODE_SHIFT)
#define PCIE_BLOCK_428_IDVAL3_REV_SHIFT				24
#define PCIE_BLOCK_428_IDVAL3_REV_MASK				(0xff << PCIE_BLOCK_428_IDVAL3_REV_SHIFT)

#define PCIE_BLOCK_1000_DL_STATUS_REG				0x1048
#define PCIE_BLOCK_1000_DL_STATUS_PHYLINKUP			(1 << 13)

#define PCIE_BLOCK_1800_PHY_CTLx_REG(x)				(0x1800 + (x * 4))
#define PCIE_BLOCK_1800_PHY_CTL_PD_P1PLL_ENABLE		(1 << 12)

#define PCIE_BRIDGE_BAR1_REMAP_REG			0x2818
#define PCIE_BRIDGE_BAR2_REMAP_REG			0x281C
#define PCIE_BRIDGE_OPT1_REG				0x2820
#define PCIE_BRIDGE_OPT1_RD_BE_EN			(1 << 7)
#define PCIE_BRIDGE_OPT1_RD_REPLY_BE_FIX_EN	(1 << 9)
#define PCIE_BRIDGE_OPT1_HOLE_DETECT_EN		(1 << 11)
#define PCIE_BRIDGE_OPT1_L1_INTR_POLARITY	(1 << 12)

#define PCIE_BRIDGE_OPT2_REG				0x2824
#define PCIE_BRIDGE_OPT2_UBUS_UR_DECODE_DIS	(1 << 2)
#define PCIE_BRIDGE_OPT2_TX_CRD_CHK_EN		(1 << 4)
#define PCIE_BRIDGE_OPT2_PCIE_ABORT			(1 << 5)
#define PCIE_BRIDGE_OPT2_PCIE_TIMEOUT		(1 << 6)
#define PCIE_BRIDGE_OPT2_BD_SEL				(1 << 7)
#define PCIE_BRIDGE_OPT2_BUS_NO_SHIFT		16
#define PCIE_BRIDGE_OPT2_BUS_NO_MASK		(0xff << PCIE_BRIDGE_OPT2_BUS_NO_SHIFT)
#define PCIE_BRIDGE_OPT2_DEV_NO_SHIFT		24
#define PCIE_BRIDGE_OPT2_DEV_NO_MASK		(0x1f << PCIE_BRIDGE_OPT2_DEV_NO_SHIFT)
#define PCIE_BRIDGE_OPT2_FUNC_NO_SHIFT		29
#define PCIE_BRIDGE_OPT2_FUNC_NO_MASK		(0x7 << PCIE_BRIDGE_OPT2_FUNC_NO_SHIFT)

#define PCIE_BRIDGE_UBUS2PCIE_BAR0_REG			0x2828
#define PCIE_BRIDGE_UBUS2PCIE_BAR0_BASE_SHIFT	20
#define PCIE_BRIDGE_UBUS2PCIE_BAR0_BASE_MASK	(0xfff << PCIE_BRIDGE_UBUS2PCIE_BAR0_BASE_SHIFT)
#define PCIE_BRIDGE_UBUS2PCIE_BAR0_MASK_SHIFT	4
#define PCIE_BRIDGE_UBUS2PCIE_BAR0_MASK_MASK	(0xfff << PCIE_BRIDGE_UBUS2PCIE_BAR0_MASK_SHIFT)
#define PCIE_BRIDGE_UBUS2PCIE_BAR0_SWAP_ENABLE	(1 << 1)
#define PCIE_BRIDGE_UBUS2PCIE_BAR0_REMAP_ENABLE	(1 << 0)

#define PCIE_BRIDGE_RC_INTR_STS_REG			0x2850
#define PCIE_BRIDGE_RC_INTR_STS_A			(1 << 0)
#define PCIE_BRIDGE_RC_INTR_STS_B			(1 << 1)
#define PCIE_BRIDGE_RC_INTR_STS_C			(1 << 2)
#define PCIE_BRIDGE_RC_INTR_STS_D			(1 << 3)

#define PCIE_BRIDGE_RC_INTR_MASK_REG		0x2854
#define PCIE_BRIDGE_RC_INTR_MASK_A			(1 << 0)
#define PCIE_BRIDGE_RC_INTR_MASK_B			(1 << 1)
#define PCIE_BRIDGE_RC_INTR_MASK_C			(1 << 2)
#define PCIE_BRIDGE_RC_INTR_MASK_D			(1 << 3)

#define PCIE_BRIDGE_PCIE_CONTROL			0x2894
#define PCIE_BRIDGE_PCIE_CONTROL_CLKREQ_ENABLE	(1 << 2)

/*************************************************************************
 * _REG relative to RSET_DDR
 *************************************************************************/
#define DDR_DMODE_0_REG						0x104
#define DDR_DRAM_CFG_REG					0x134
#define DDR_DRAM_CFG_SLEEP					(1 << 11)

#define DDR_PHYCTRL_IDLE_PAD_CTRL_REG						0x238
#define DDR_PHYBYTELANE_0_CTRL_IDLE_PAD_CTRL_REG			0x33C
#define DDR_PHYBYTELANE_1_CTRL_IDLE_PAD_CTRL_REG			0x43C

/*************************************************************************
 * _REG relative to RSET_WLAN_SHIM
 *************************************************************************/
#define WLAN_SHIM_MISC_REG					0x0
#define WLAN_SHIM_MISC_FORCE_CLOCKS_ON		(1 << 2)
#define WLAN_SHIM_MISC_MACRO_DISABLE		(1 << 1)
#define WLAN_SHIM_MISC_MACRO_SOFT_RESET		(1 << 0)

#define WLAN_SHIM_MAC_CTRL_REG				0x10
#define SICF_WOC_CORE_RESET					0x10000
#define SICF_BIST_EN						0x8000
#define SICF_PME_EN							0x4000
#define SICF_CORE_BITS						0x3ffc
#define SICF_FGC							0x0002
#define SICF_CLOCK_EN						0x0001  

#endif /* BCM632X_REGS_H_ */
