#ifndef __BCM63268_IRQ_H__
#define __BCM63268_IRQ_H__

#include <bcm63268_cpu.h>

typedef enum {  
    BCM_IRQ_NONE = 0,
    BCM_IRQ_HANDLED = 1,
    BCM_IRQ_WAKE_THREAD = 2
} FN_HANDLER_RT;
typedef FN_HANDLER_RT (*FN_HANDLER) (int, void *);

#define IRQ_MIPS_BASE			0
#define IRQ_MIPS_SOFT0			(IRQ_MIPS_BASE + 0)
#define IRQ_MIPS_SOFT1			(IRQ_MIPS_BASE + 1)
#define IRQ_INTERNAL_BASE		8

#define IRQ_EXT_BASE			(IRQ_INTERNAL_BASE + 44)
#define IRQ_EXT_0				(IRQ_EXT_BASE + 0)
#define IRQ_EXT_1				(IRQ_EXT_BASE + 1)
#define IRQ_EXT_2				(IRQ_EXT_BASE + 2)
#define IRQ_EXT_3				(IRQ_EXT_BASE + 3)

#define IRQ_INTERNAL_MAX		91

/* prototypes */
/* NOTE: The enable/disable functions do not appear symmetric, allowing enabling but not disabling of external interrupts. */
extern void enable_brcm_irq(unsigned int irq);
extern void disable_brcm_irq(unsigned int irq);
extern void disable_brcm_irqsave(unsigned int irq, u64 stateSaveArray[]);
extern void restore_brcm_irqsave(unsigned int irq, u64 stateSaveArray[]);
extern unsigned int BcmHalMapInterrupt(FN_HANDLER isr, unsigned int param, unsigned int interruptId);

/* compatibility definitions */
#define BcmHalInterruptEnable(irq)      enable_brcm_irq( irq )
#define BcmHalInterruptDisable(irq)     disable_brcm_irq( irq )

#endif /* ! __BCM63268_IRQ_H__ */

