#ifndef BCM63268_IO_H_
#define BCM63268_IO_H_

#include "bcm63268_cpu.h"

/*
 * Physical memory map, RAM is mapped at 0x0.
 *
 * Note that size MUST be a power of two.
 */


/*
 * Internal registers are accessed through KSEG3
 */
#define BCM_REGS_VA(x)	((void __iomem *)(x))

#define bcm_readb(a)	(*(volatile unsigned char *)	BCM_REGS_VA(a))
#define bcm_readw(a)	(*(volatile unsigned short *)	BCM_REGS_VA(a))
#define bcm_readl(a)	(*(volatile unsigned int *)		BCM_REGS_VA(a))
#define bcm_writeb(v, a) (*(volatile unsigned char *) 	BCM_REGS_VA((a)) = (v))
#define bcm_writew(v, a) (*(volatile unsigned short *)	BCM_REGS_VA((a)) = (v))
#define bcm_writel(v, a) (*(volatile unsigned int *)	BCM_REGS_VA((a)) = (v))

/*
 * IO helpers to access register set for current CPU
 */
#define bcm_rset_readb(s, o)	bcm_readb(bcm63268_regset_address(s) + (o))
#define bcm_rset_readw(s, o)	bcm_readw(bcm63268_regset_address(s) + (o))
#define bcm_rset_readl(s, o)	bcm_readl(bcm63268_regset_address(s) + (o))
#define bcm_rset_writeb(s, v, o)	bcm_writeb((v), \
										bcm63268_regset_address(s) + (o))
#define bcm_rset_writew(s, v, o)	bcm_writew((v), \
										bcm63268_regset_address(s) + (o))
#define bcm_rset_writel(s, v, o)	bcm_writel((v), \
										bcm63268_regset_address(s) + (o))

/*
 * helpers for frequently used register sets
 */
#define bcm_perf_readl(o)	bcm_rset_readl(RSET_PERF, (o))
#define bcm_perf_writel(v, o)	bcm_rset_writel(RSET_PERF, (v), (o))
#define bcm_timer_readl(o)	bcm_rset_readl(RSET_TIMER, (o))
#define bcm_timer_writel(v, o)	bcm_rset_writel(RSET_TIMER, (v), (o))
#define bcm_wdt_readl(o)	bcm_rset_readl(RSET_WDT, (o))
#define bcm_wdt_writel(v, o)	bcm_rset_writel(RSET_WDT, (v), (o))
#define bcm_gpio_readl(o)	bcm_rset_readl(RSET_GPIO, (o))
#define bcm_gpio_writel(v, o)	bcm_rset_writel(RSET_GPIO, (v), (o))
#define bcm_uart0_readl(o)	bcm_rset_readl(RSET_UART0, (o))
#define bcm_uart0_writel(v, o)	bcm_rset_writel(RSET_UART0, (v), (o))
#define bcm_uart1_readl(o)	bcm_rset_readl(RSET_UART1, (o))
#define bcm_uart1_writel(v, o)	bcm_rset_writel(RSET_UART1, (v), (o))
#define bcm_misc_readl(o)	bcm_rset_readl(RSET_MISC, (o))
#define bcm_misc_writel(v, o)	bcm_rset_writel(RSET_MISC, (v), (o))
#define bcm_led_readl(o)	bcm_rset_readl(RSET_LED, (o))
#define bcm_led_writel(v, o)	bcm_rset_writel(RSET_LED, (v), (o))
#define bcm_ddr_readl(o)	bcm_rset_readl(RSET_DDR, (o))
#define bcm_ddr_writel(v, o)	bcm_rset_writel(RSET_DDR, (v), (o))
#define bcm_usbh_readl(o)	bcm_rset_readl(RSET_USBH_CFG, (o))
#define bcm_usbh_writel(v, o)	bcm_rset_writel(RSET_USBH_CFG, (v), (o))
#define bcm_pcie_readl(o)	bcm_rset_readl(RSET_PCIE, (o))
#define bcm_pcie_writel(v, o)	bcm_rset_writel(RSET_PCIE, (v), (o))
#define bcm_wlan_shim_readl(o)	bcm_rset_readl(RSET_WLAN_SHIM, (o))
#define bcm_wlan_shim_writel(v, o)	bcm_rset_writel(RSET_WLAN_SHIM, (v), (o))

#endif /* ! BCM63268_IO_H_ */

