#ifndef BCM63268_GPIO_H
#define BCM63268_GPIO_H

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <asm-generic/gpio.h>

int __init bcm63268_gpio_init(void);

static inline unsigned long bcm63268_gpio_count(void)
{
	switch (bcm63268_get_cpu_id()) {
	case BCM63268_CPU_ID:
	default:
		return 48;
	}
}

#define GPIO_DIR_OUT	0x0
#define GPIO_DIR_IN		0x1

int bcm63268_gpio_direction_input(struct gpio_chip * chip, unsigned gpio);
int bcm63268_gpio_direction_output(struct gpio_chip * chip, unsigned gpio, int value);

#endif /* !BCM63268_GPIO_H */

