/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#ifndef __BCM63268_DEV_NAND_H__
#define __BCM63268_DEV_NAND_H__

/* Shared NAND definitions */
/* NAND controller interrupt control registers */
#define R_NAND_INTR_CTRL_INTR			0x00
#define R_NAND_INTR_CTRL_BASEADDR0		0x04
#define R_NAND_INTR_CTRL_BASEADDR1		0x0c

/* NAND controller interrupt register */
#define S_NAND_INTR_CTRL_INTR_NP_READ		0
#define M_NAND_INTR_CTRL_INTR_NP_READ		_DD_MAKEMASK(1, S_NAND_INTR_CTRL_INTR_NP_READ)
#define S_NAND_INTR_CTRL_INTR_BLOCK_ERASE	1
#define M_NAND_INTR_CTRL_INTR_BLOCK_ERASE	_DD_MAKEMASK(1, S_NAND_INTR_CTRL_INTR_BLOCK_ERASE)
#define S_NAND_INTR_CTRL_INTR_COPY_BACK		2
#define M_NAND_INTR_CTRL_INTR_COPY_BACK		_DD_MAKEMASK(1, S_NAND_INTR_CTRL_INTR_COPY_BACK)
#define S_NAND_INTR_CTRL_INTR_PAGE_PROGRAM	3
#define M_NAND_INTR_CTRL_INTR_PAGE_PROGRAM	_DD_MAKEMASK(1, S_NAND_INTR_CTRL_INTR_PAGE_PROGRAM)
#define S_NAND_INTR_CTRL_INTR_CTRL_READY	4
#define M_NAND_INTR_CTRL_INTR_CTRL_READY	_DD_MAKEMASK(1, S_NAND_INTR_CTRL_INTR_CTRL_READY)
#define S_NAND_INTR_CTRL_INTR_DEV_RBPIN		5
#define M_NAND_INTR_CTRL_INTR_DEV_RBPIN		_DD_MAKEMASK(1, S_NAND_INTR_CTRL_INTR_DEV_RBPIN)
#define S_NAND_INTR_CTRL_INTR_ECC_UNCORR	6
#define M_NAND_INTR_CTRL_INTR_ECC_UNCORR	_DD_MAKEMASK(1, S_NAND_INTR_CTRL_INTR_ECC_UNCORR)
#define S_NAND_INTR_CTRL_INTR_ECC_CORR		7
#define M_NAND_INTR_CTRL_INTR_ECC_CORR		_DD_MAKEMASK(1, S_NAND_INTR_CTRL_INTR_ECC_CORR)
#define M_NAND_INTR_CTRL_INTR_ALL_MASK		0xfff
#define M_NAND_INTR_CTRL_INTR_ENABLE_MASK	0xffff0000

/* NAND controller control registers */
#define R_NAND_CTRL_REVISION			0x00
#define R_NAND_CTRL_CMD_START			0x04
#define R_NAND_CTRL_CMD_EXTADDR			0x08
#define R_NAND_CTRL_CMD_ADDR			0x0c
#define R_NAND_CTRL_CMD_ENDADDR			0x10
#define R_NAND_CTRL_CS_SELECT			0x14
#define R_NAND_CTRL_CS_XOR				0x18
#define R_NAND_CTRL_OOB_READ_OFFSET0	0x20
#define R_NAND_CTRL_OOB_READ_OFFSET4	0x24
#define R_NAND_CTRL_OOB_READ_OFFSET8	0x28
#define R_NAND_CTRL_OOB_READ_OFFSETC	0x2c
#define R_NAND_CTRL_OOB_READ_OFFSET(x)	(0x20 + (x * 4))
#define R_NAND_CTRL_OOB_WRITE_OFFSET0	0x30
#define R_NAND_CTRL_OOB_WRITE_OFFSET4	0x34
#define R_NAND_CTRL_OOB_WRITE_OFFSET8	0x38
#define R_NAND_CTRL_OOB_WRITE_OFFSETC	0x3c
#define R_NAND_CTRL_OOB_WRITE_OFFSET(x)	(0x30 + (x * 4))
#define R_NAND_CTRL_ACCESS_CTRL			0x40
#define R_NAND_CTRL_CONFIG				0x48
#define R_NAND_CTRL_TIMING1				0x50
#define R_NAND_CTRL_TIMING2				0x54
#define R_NAND_CTRL_SEMAPHORE			0x58
#define R_NAND_CTRL_DEVICEID			0x60
#define R_NAND_CTRL_DEVICEID_EXT		0x64
#define R_NAND_CTRL_LOCKSTATUS			0x68
#define R_NAND_CTRL_INTFSTATUS			0x6c
#define R_NAND_CTRL_ECC_CORR_EXTADDR	0x70
#define R_NAND_CTRL_ECC_CORR_ADDR		0x74
#define R_NAND_CTRL_ECC_UNCORR_EXTADDR	0x78
#define R_NAND_CTRL_ECC_UNCORR_ADDR		0x7c
#define R_NAND_CTRL_READ_ERR_COUNT		0x80
#define R_NAND_CTRL_CORR_STAT_THRESHOLD	0x84
#define R_NAND_CTRL_ONFI_STATUS			0x88
#define R_NAND_CTRL_ONFI_DEBUG_DATA		0x8c
#define R_NAND_CTRL_READ_EXTADDR		0x90
#define R_NAND_CTRL_READ_ADDR			0x94
#define R_NAND_CTRL_PROGPAGE_EXTADDR	0x98
#define R_NAND_CTRL_PROGPAGE_ADDR		0x9c
#define R_NAND_CTRL_COPYBACK_EXTADDR	0xa0
#define R_NAND_CTRL_COPYBACK_ADDR		0xa4
#define R_NAND_CTRL_BLOCKERASE_EXTADDR	0xa8
#define R_NAND_CTRL_BLOCKERASE_ADDR		0xac
#define R_NAND_CTRL_INVALIDREAD_EXTADDR	0xb0
#define R_NAND_CTRL_INVALIDREAD_ADDR	0xb4
#define R_NAND_CTRL_WRITE_PROTECT		0xc0
#define R_NAND_CTRL_ACCESS_CTRL_CS1		0xd0
#define R_NAND_CTRL_CONFIG_CS1			0xd4
#define R_NAND_CTRL_TIMING1_CS1			0xd8
#define R_NAND_CTRL_TIMING2_CS1			0xdc
#define R_NAND_CTRL_ACCESS_CTRL_CS2		0xe0
#define R_NAND_CTRL_CONFIG_CS2			0xe4
#define R_NAND_CTRL_TIMING1_CS2			0xe8
#define R_NAND_CTRL_TIMING2_CS2			0xec
#define R_NAND_CTRL_OOB_READ_OFFSET10	0x120
#define R_NAND_CTRL_OOB_READ_OFFSET14	0x124
#define R_NAND_CTRL_OOB_READ_OFFSET18	0x128
#define R_NAND_CTRL_OOB_READ_OFFSET1C	0x12c

/* NAND controller command start register */
#define V_NAND_CTRL_CMD_START_PAGE_READ			0x01000000
#define V_NAND_CTRL_CMD_START_OOB_READ			0x02000000
#define V_NAND_CTRL_CMD_START_STATUS_READ		0x03000000
#define V_NAND_CTRL_CMD_START_PROGRAM_PAGE		0x04000000
#define V_NAND_CTRL_CMD_START_PROGRAM_OOB		0x05000000
#define V_NAND_CTRL_CMD_START_COPY_BACK			0x06000000
#define V_NAND_CTRL_CMD_START_DEVID_READ		0x07000000
#define V_NAND_CTRL_CMD_START_BLOCK_ERASE		0x08000000
#define V_NAND_CTRL_CMD_START_FLASH_RESET		0x09000000
#define V_NAND_CTRL_CMD_START_BLOCK_LOCK		0x0a000000
#define V_NAND_CTRL_CMD_START_BLOCK_LOCKDOWN	0x0b000000
#define V_NAND_CTRL_CMD_START_BLOCK_UNLOCK		0x0c000000
#define V_NAND_CTRL_CMD_START_BLOCK_LOCKSTATUS	0x0d000000
#define V_NAND_CTRL_CMD_START_PARAM_READ		0x0e000000
#define V_NAND_CTRL_CMD_START_PARAM_CHANGE_COL	0x0f000000
#define V_NAND_CTRL_CMD_START_LOW_LEVEL_OP		0x10000000
#define M_NAND_CTRL_CMD_START_ALLMASK			0x1f000000

/* NAND controller EBI CS select register */
#define S_NAND_CTRL_CSSELECT_EBI_CS0_SEL				0
#define M_NAND_CTRL_CSSELECT_EBI_CS0_SEL				_DD_MAKEMASK(1, S_NAND_CTRL_CSSELECT_EBI_CS0_SEL)
#define S_NAND_CTRL_CSSELECT_EBI_CS0_USES_NAND			8
#define M_NAND_CTRL_CSSELECT_EBI_CS0_USES_NAND			_DD_MAKEMASK(1, S_NAND_CTRL_CSSELECT_EBI_CS0_USES_NAND)
#define S_NAND_CTRL_CSSELECT_WRITE_PROTECT_BLOCK0		28
#define M_NAND_CTRL_CSSELECT_WRITE_PROTECT_BLOCK0		_DD_MAKEMASK(1, S_NAND_CTRL_CSSELECT_WRITE_PROTECT_BLOCK0)
#define S_NAND_CTRL_CSSELECT_AUTO_DEVID_READ			30
#define M_NAND_CTRL_CSSELECT_AUTO_DEVID_READ			_DD_MAKEMASK(1, S_NAND_CTRL_CSSELECT_AUTO_DEVID_READ)
#define S_NAND_CTRL_CSSELECT_CS_LOCK					31
#define M_NAND_CTRL_CSSELECT_CS_LOCK					_DD_MAKEMASK(1, S_NAND_CTRL_CSSELECT_CS_LOCK)

/* NAND controller access control register */
#define S_NAND_CTRL_ACCESS_CTRL_SPARE_SIZE				0
#define M_NAND_CTRL_ACCESS_CTRL_SPARE_SIZE				_DD_MAKEMASK(6, S_NAND_CTRL_ACCESS_CTRL_SPARE_SIZE)
#define S_NAND_CTRL_ACCESS_CTRL_SPARE_SIZE_BLOCK0		8
#define M_NAND_CTRL_ACCESS_CTRL_SPARE_SIZE_BLOCK0		_DD_MAKEMASK(6, S_NAND_CTRL_ACCESS_CTRL_SPARE_SIZE_BLOCK0)
#define S_NAND_CTRL_ACCESS_CTRL_ECC_LVL					16
#define M_NAND_CTRL_ACCESS_CTRL_ECC_LVL					_DD_MAKEMASK(4, S_NAND_CTRL_ACCESS_CTRL_ECC_LVL)
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_DISABLE		0
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_1			1
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_2			2
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_3			3
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_4			4
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_5			5
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_6			6
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_7			7
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_8			8
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_9			9
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_10		10
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_11		11
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_BCH_12		12
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_RSVD_1		13
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_RSVD_2		14
	#define NAND_CTRL_ACCESS_CTRL_ECC_LVL_HAMMING		15
#define S_NAND_CTRL_ACCESS_CTRL_ECC_LVL_BLOCK0			20
#define M_NAND_CTRL_ACCESS_CTRL_ECC_LVL_BLOCK0			_DD_MAKEMASK(4, S_NAND_CTRL_ACCESS_CTRL_ECC_LVL_BLOCK0)
#define S_NAND_CTRL_ACCESS_CTRL_WRITE_PREEMPT			25
#define M_NAND_CTRL_ACCESS_CTRL_WRITE_PREEMPT			_DD_MAKEMASK(1, S_NAND_CTRL_ACCESS_CTRL_WRITE_PREEMPT)
#define S_NAND_CTRL_ACCESS_CTRL_PARTIAL_PAGE_ENABLE		26
#define M_NAND_CTRL_ACCESS_CTRL_PARTIAL_PAGE_ENABLE		_DD_MAKEMASK(1, S_NAND_CTRL_ACCESS_CTRL_PARTIAL_PAGE_ENABLE)
#define S_NAND_CTRL_ACCESS_CTRL_READ_ECC_ERASED_ENABLE	27
#define M_NAND_CTRL_ACCESS_CTRL_READ_ECC_ERASED_ENABLE	_DD_MAKEMASK(1, S_NAND_CTRL_ACCESS_CTRL_READ_ECC_ERASED_ENABLE)
#define S_NAND_CTRL_ACCESS_CTRL_FAST_PGM_RDIN			28
#define M_NAND_CTRL_ACCESS_CTRL_FAST_PGM_RDIN			_DD_MAKEMASK(1, S_NAND_CTRL_ACCESS_CTRL_FAST_PGM_RDIN)
#define S_NAND_CTRL_ACCESS_CTRL_READ_ECC_BLOCK0_ENABLE	29
#define M_NAND_CTRL_ACCESS_CTRL_READ_ECC_BLOCK0_ENABLE	_DD_MAKEMASK(1, S_NAND_CTRL_ACCESS_CTRL_READ_ECC_ENABLE)
#define S_NAND_CTRL_ACCESS_CTRL_WRITE_ECC_ENABLE		30
#define M_NAND_CTRL_ACCESS_CTRL_WRITE_ECC_ENABLE		_DD_MAKEMASK(1, S_NAND_CTRL_ACCESS_CTRL_WRITE_ECC_ENABLE)
#define S_NAND_CTRL_ACCESS_CTRL_READ_ECC_ENABLE			31
#define M_NAND_CTRL_ACCESS_CTRL_READ_ECC_ENABLE			_DD_MAKEMASK(1, S_NAND_CTRL_ACCESS_CTRL_READ_ECC_ENABLE)

/* NAND controller config register */
#define S_NAND_CTRL_CONFIG_BLOCK_ADDR_BYTES			8
#define M_NAND_CTRL_CONFIG_BLOCK_ADDR_BYTES			_DD_MAKEMASK(3, S_NAND_CTRL_CONFIG_BLOCK_ADDR_BYTES)
#define V_NAND_CTRL_CONFIG_BLOCK_ADDR_BYTES(v)		_DD_MAKEVALUE(v, S_NAND_CTRL_CONFIG_BLOCK_ADDR_BYTES)
#define S_NAND_CTRL_CONFIG_COL_ADDR_BYTES			12
#define M_NAND_CTRL_CONFIG_COL_ADDR_BYTES			_DD_MAKEMASK(3, S_NAND_CTRL_CONFIG_COL_ADDR_BYTES)
#define V_NAND_CTRL_CONFIG_COL_ADDR_BYTES(v)		_DD_MAKEVALUE(v, S_NAND_CTRL_CONFIG_COL_ADDR_BYTES)
#define S_NAND_CTRL_CONFIG_FULL_ADDR_BYTES			16
#define M_NAND_CTRL_CONFIG_FULL_ADDR_BYTES			_DD_MAKEMASK(3, S_NAND_CTRL_CONFIG_FULL_ADDR_BYTES)
#define V_NAND_CTRL_CONFIG_FULL_ADDR_BYTES(v)		_DD_MAKEVALUE(v, S_NAND_CTRL_CONFIG_FULL_ADDR_BYTES)
#define S_NAND_CTRL_CONFIG_BUS_WIDTH				23
#define M_NAND_CTRL_CONFIG_BUS_WIDTH				_DD_MAKEMASK(1, S_NAND_CTRL_CONFIG_BUS_WIDTH)
#define V_NAND_CTRL_CONFIG_BUS_WIDTH(v)				_DD_MAKEVALUE(v, S_NAND_CTRL_CONFIG_BUS_WIDTH)
	#define NAND_CTRL_CONFIG_BUS_WIDTH_8			0
	#define NAND_CTRL_CONFIG_BUS_WIDTH_16			1
#define S_NAND_CTRL_CONFIG_PAGE_SIZE				20
#define M_NAND_CTRL_CONFIG_PAGE_SIZE				_DD_MAKEMASK(2, S_NAND_CTRL_CONFIG_PAGE_SIZE)
#define V_NAND_CTRL_CONFIG_PAGE_SIZE(v)				_DD_MAKEVALUE(v, S_NAND_CTRL_CONFIG_PAGE_SIZE)
	#define NAND_CTRL_CONFIG_PAGE_SIZE_512B			0
	#define NAND_CTRL_CONFIG_PAGE_SIZE_2K			1
	#define NAND_CTRL_CONFIG_PAGE_SIZE_4K			2
	#define NAND_CTRL_CONFIG_PAGE_SIZE_8K			3
#define S_NAND_CTRL_CONFIG_FLASH_SIZE				24
#define M_NAND_CTRL_CONFIG_FLASH_SIZE				_DD_MAKEMASK(4, S_NAND_CTRL_CONFIG_FLASH_SIZE)
#define V_NAND_CTRL_CONFIG_FLASH_SIZE(v)			_DD_MAKEVALUE(v, S_NAND_CTRL_CONFIG_FLASH_SIZE)
#define S_NAND_CTRL_CONFIG_BLOCK_SIZE				28
	#define NAND_CTRL_CONFIG_FLASH_SIZE_4M			0
	#define NAND_CTRL_CONFIG_FLASH_SIZE_8M			1
	#define NAND_CTRL_CONFIG_FLASH_SIZE_16M			2
	#define NAND_CTRL_CONFIG_FLASH_SIZE_32M			3
	#define NAND_CTRL_CONFIG_FLASH_SIZE_64M			4
	#define NAND_CTRL_CONFIG_FLASH_SIZE_128M		5
	#define NAND_CTRL_CONFIG_FLASH_SIZE_256M		6
	#define NAND_CTRL_CONFIG_FLASH_SIZE_512M		7
	#define NAND_CTRL_CONFIG_FLASH_SIZE_1G			8
	#define NAND_CTRL_CONFIG_FLASH_SIZE_2G			9
	#define NAND_CTRL_CONFIG_FLASH_SIZE_4G			10
	#define NAND_CTRL_CONFIG_FLASH_SIZE_8G			11
	#define NAND_CTRL_CONFIG_FLASH_SIZE_16G			12
	#define NAND_CTRL_CONFIG_FLASH_SIZE_32G			13
	#define NAND_CTRL_CONFIG_FLASH_SIZE_64G			14
	#define NAND_CTRL_CONFIG_FLASH_SIZE_128G		15
#define M_NAND_CTRL_CONFIG_BLOCK_SIZE				_DD_MAKEMASK(3, S_NAND_CTRL_CONFIG_BLOCK_SIZE)
#define V_NAND_CTRL_CONFIG_BLOCK_SIZE(v)			_DD_MAKEVALUE(v, S_NAND_CTRL_CONFIG_BLOCK_SIZE)
	#define NAND_CTRL_CONFIG_BLOCK_SIZE_16K			0
	#define NAND_CTRL_CONFIG_BLOCK_SIZE_128K		1
	#define NAND_CTRL_CONFIG_BLOCK_SIZE_8K			2
	#define NAND_CTRL_CONFIG_BLOCK_SIZE_512K		3
	#define NAND_CTRL_CONFIG_BLOCK_SIZE_256K		4
	#define NAND_CTRL_CONFIG_BLOCK_SIZE_1024K		5
	#define NAND_CTRL_CONFIG_BLOCK_SIZE_2048K		6

/* NAND controller interface status register */
#define M_NAND_CTRL_INTFSTATUS_FLASHSTS_ALL_MASK	0xff
#define S_NAND_CTRL_INTFSTATUS_OOB_VALID			28
#define M_NAND_CTRL_INTFSTATUS_OOB_VALID			_DD_MAKEMASK(1, S_NAND_CTRL_INTFSTATUS_OOB_VALID)
#define S_NAND_CTRL_INTFSTATUS_CACHE_VALID			29
#define M_NAND_CTRL_INTFSTATUS_CACHE_VALID			_DD_MAKEMASK(1, S_NAND_CTRL_INTFSTATUS_CACHE_VALID)
#define S_NAND_CTRL_INTFSTATUS_FLASH_READY			30
#define M_NAND_CTRL_INTFSTATUS_FLASH_READY			_DD_MAKEMASK(1, S_NAND_CTRL_INTFSTATUS_FLASH_READY)
#define S_NAND_CTRL_INTFSTATUS_CTRLER_READY			31
#define M_NAND_CTRL_INTFSTATUS_CTRLER_READY			_DD_MAKEMASK(1, S_NAND_CTRL_INTFSTATUS_FLASH_READY)

struct bcm63268_nand_platform_data {
	unsigned int width;	/* data bus width in bytes */
	unsigned int hw_ecc:1;	/* 0 if supress hardware ECC */
	unsigned int flash_bbt:1; /* set to 1 to use a flash based bbt */
	struct mtd_partition *parts;	/* partition table */
	int nr_parts;			/* size of parts */
};

int __init bcm63268_add_device_nand(void *pdata, size_t size_data);
#endif /* __BCM63268_DEV_NAND_H__ */

