#ifndef __BCM63268_DEV_HSSPI_H__
#define __BCM63268_DEV_HSSPI_H__

#include <linux/types.h>
#include <linux/spi/spi.h>

/* Shared SPI definitions */

/* Global Control */
#define S_HSSPI_GLOBAL_CTL_SS_POLARITY		0
#define M_HSSPI_GLOBAL_CTL_SS_POLARITY		_DD_MAKEMASK(8, S_HSSPI_GLOBAL_CTL_SS_POLARITY)
#define V_HSSPI_GLOBAL_CTL_SS_POLARITY(v)	_DD_MAKEVALUE(v, S_HSSPI_GLOBAL_CTL_SS_POLARITY)
#define S_HSSPI_GLOBAL_CTL_PLL_CLK_CTL		8
#define M_HSSPI_GLOBAL_CTL_PLL_CLK_CTL		_DD_MAKEMASK(8, S_HSSPI_GLOBAL_CTL_PLL_CLK_CTL)
#define V_HSSPI_GLOBAL_CTL_PLL_CLK_CTL(v)	_DD_MAKEVALUE(v, S_HSSPI_GLOBAL_CTL_PLL_CLK_CTL)
#define M_HSSPI_GLOBAL_CTL_CLK_GATE_SSOFF	_DD_MAKEMASK1(16)
#define M_HSSPI_GLOBAL_CTL_CLK_STATE_GATED	_DD_MAKEMASK1(17)
#define M_HSSPI_GLOBAL_CTL_MOSI_IDLE		_DD_MAKEMASK1(18)

/* Interrupt status & mask */
#define M_HSSPI_INTR_PING0_CMD_DONE			_DD_MAKEMASK1(0)
#define M_HSSPI_INTR_PING0_RX_OVER			_DD_MAKEMASK1(1)
#define M_HSSPI_INTR_PING0_TX_UNDER			_DD_MAKEMASK1(2)
#define M_HSSPI_INTR_PING0_POLL_TOUT		_DD_MAKEMASK1(3)
#define M_HSSPI_INTR_PING0_CTL_INVAL		_DD_MAKEMASK1(4)
#define M_HSSPI_INTR_PING0_ALL				_DD_MAKEMASK(5, 0)

/* FLASH control */
#define S_HSSPI_FLASH_CTL_OPCODE			0
#define M_HSSPI_FLASH_CTL_OPCODE			_DD_MAKEMASK(8, S_HSSPI_FLASH_CTL_OPCODE)
#define V_HSSPI_FLASH_CTL_OPCODE(v)			_DD_MAKEVALUE(v, S_HSSPI_FLASH_CTL_OPCODE)
#define S_HSSPI_FLASH_CTL_ADDR_BYTES		8
#define M_HSSPI_FLASH_CTL_ADDR_BYTES		_DD_MAKEMASK(2, S_HSSPI_FLASH_CTL_ADDR_BYTES)
#define V_HSSPI_FLASH_CTL_ADDR_BYTES(v)		_DD_MAKEVALUE(v, S_HSSPI_FLASH_CTL_ADDR_BYTES)
	#define HSSPI_FLASH_CTL_ADDR_BYTES_2	0
	#define HSSPI_FLASH_CTL_ADDR_BYTES_3	1
	#define HSSPI_FLASH_CTL_ADDR_BYTES_4	2
#define S_HSSPI_FLASH_CTL_DUMMY_BYTES		10
#define M_HSSPI_FLASH_CTL_DUMMY_BYTES		_DD_MAKEMASK(2, S_HSSPI_FLASH_CTL_DUMMY_BYTES)
#define V_HSSPI_FLASH_CTL_DUMMY_BYTES(v)	_DD_MAKEVALUE(v, S_HSSPI_FLASH_CTL_DUMMY_BYTES)
#define S_HSSPI_FLASH_CTL_PROFILE_NUM		16
#define M_HSSPI_FLASH_CTL_PROFILE_NUM		_DD_MAKEMASK(3, S_HSSPI_FLASH_CTL_PROFILE_NUM)
#define V_HSSPI_FLASH_CTL_PROFILE_NUM(v)	_DD_MAKEVALUE(v, S_HSSPI_FLASH_CTL_PROFILE_NUM)
#define S_HSSPI_FLASH_CTL_SS_NUM			20
#define M_HSSPI_FLASH_CTL_SS_NUM			_DD_MAKEMASK(3, S_HSSPI_FLASH_CTL_SS_NUM)
#define V_HSSPI_FLASH_CTL_SS_NUM(v)			_DD_MAKEVALUE(v, S_HSSPI_FLASH_CTL_SS_NUM)
#define M_HSSPI_FLASH_CTL_MB_EN		

/* PINGPONG command */
#define S_HSSPI_PINGPONG_CMD_SS_NUM			12
#define M_HSSPI_PINGPONG_CMD_SS_NUM			_DD_MAKEMASK(4, S_HSSPI_PINGPONG_CMD_SS_NUM)
#define V_HSSPI_PINGPONG_CMD_SS_NUM(v)		_DD_MAKEVALUE(v, S_HSSPI_PINGPONG_CMD_SS_NUM)
#define S_HSSPI_PINGPONG_CMD_PROFILE_NUM 	8
#define M_HSSPI_PINGPONG_CMD_PROFILE_NUM 	_DD_MAKEMASK(4, S_HSSPI_PINGPONG_CMD_PROFILE_NUM)
#define V_HSSPI_PINGPONG_CMD_PROFILE_NUM(v) _DD_MAKEVALUE(v, S_HSSPI_PINGPONG_CMD_PROFILE_NUM)
#define S_HSSPI_PINGPONG_CMD_TRIGGER_NUM	4
#define M_HSSPI_PINGPONG_CMD_TRIGGER_NUM 	_DD_MAKEMASK(4, S_HSSPI_PINGPONG_CMD_TRIGGER_NUM)
#define V_HSSPI_PINGPONG_CMD_TRIGGER_NUM(v)	_DD_MAKEVALUE(v, S_HSSPI_PINGPONG_CMD_TRIGGER_NUM)
#define S_HSSPI_PINGPONG_CMD_VALUE 			0
#define M_HSSPI_PINGPONG_CMD_VALUE 			_DD_MAKEMASK(4, S_HSSPI_PINGPONG_CMD_VALUE)
#define V_HSSPI_PINGPONG_CMD_VALUE(v)		_DD_MAKEVALUE(v, S_HSSPI_PINGPONG_CMD_VALUE)
	#define HSSPI_PINGPONG_CMD_NOOP 			(0)
	#define HSSPI_PINGPONG_CMD_START_NOW 		(1)
	#define HSSPI_PINGPONG_CMD_START_TRIGGER	(2)
	#define HSSPI_PINGPONG_CMD_HALT				(3)
	#define HSSPI_PINGPONG_CMD_FLUSH			(4)

/* PINGPONG status */
#define M_HSSPI_PINGPONG_STATUS_ERROR_BYTE_OFFSET	_DD_MAKEMASK1(16)
#define M_HSSPI_PINGPONG_STATUS_WAIT_FOR_TRIGGER	_DD_MAKEMASK1(2)
#define M_HSSPI_PINGPONG_STATUS_SOURCE_BUSY			_DD_MAKEMASK1(1)
#define M_HSSPI_PINGPONG_STATUS_SOURCE_GNT			_DD_MAKEMASK1(0)

/* PINGPONG FIFO status */
#define S_HSSPI_PINGPONG_FIFO_STATUS_RX_TAIL		0
#define M_HSSPI_PINGPONG_FIFO_STATUS_RX_TAIL \
				_DD_MAKEMASK(10, S_HSSPI_PINGPONG_FIFO_STATUS_RX_TAIL)
#define M_HSSPI_PINGPONG_FIFO_STATUS_RX_FULL		_DD_MAKEMASK1(14)
#define M_HSSPI_PINGPONG_FIFO_STATUS_RX_EMPTY		_DD_MAKEMASK1(15)
#define S_HSSPI_PINGPONG_FIFO_STATUS_MSG_TAIL		16
#define M_HSSPI_PINGPONG_FIFO_STATUS_MSG_TAIL \
				_DD_MAKEMASK(10, S_HSSPI_PINGPONG_FIFO_STATUS_MSG_TAIL)
#define M_HSSPI_PINGPONG_FIFO_STATUS_MSG_FULL		_DD_MAKEMASK1(30)
#define M_HSSPI_PINGPONG_FIFO_STATUS_MSG_EMPTY		_DD_MAKEMASK1(31)

/* PROFILE clock control */
#define M_HSSPI_PROFILES_CLOCK_CTL_ACCUM_RST_ON_LOOP	_DD_MAKEMASK1(15)
#define M_HSSPI_PROFILES_CLOCK_CTL_SPI_CLK_2X_SEL		_DD_MAKEMASK1(14)
#define S_HSSPI_PROFILES_CLOCK_CTL_FREQ_CTL_WORD		0
#define V_HSSPI_PROFILES_CLOCK_CTL_FREQ_CTL_WORD(v) \
					_DD_MAKEVALUE(v, S_HSSPI_PROFILES_CLOCK_CTL_FREQ_CTL_WORD)

/* PROFILE mode control */
#define S_HSSPI_PROFILES_MODE_CTL_PREPENDBYTE_CNT	24
#define M_HSSPI_PROFILES_MODE_CTL_PREPENDBYTE_CNT \
				_DD_MAKEMASK(4, S_HSSPI_PROFILES_MODE_CTL_PREPENDBYTE_CNT)
#define V_HSSPI_PROFILES_MODE_CTL_PREPENDBYTE_CNT(v) \
				_DD_MAKEVALUE(v, S_HSSPI_PROFILES_MODE_CTL_PREPENDBYTE_CNT)
#define M_HSSPI_PROFILES_MODE_CTL_ONE_WIRE			_DD_MAKEMASK1(20)
#define S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_SIZE	18
#define M_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_SIZE	\
				_DD_MAKEMASK(2, S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_SIZE)
#define V_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_SIZE(v)	\
				_DD_MAKEVALUE(v, S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_SIZE)
#define S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_SIZE	16
#define M_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_SIZE	\
				_DD_MAKEMASK(2, S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_SIZE)
#define V_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_SIZE(v)	\
				_DD_MAKEVALUE(v, S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_SIZE)
#define S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_STRT	12
#define M_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_STRT	\
				_DD_MAKEMASK(4, S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_STRT)
#define V_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_STRT(v)	\
				_DD_MAKEVALUE(v, S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_WR_STRT)
#define S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_STRT	8
#define M_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_STRT \
				_DD_MAKEMASK(4, S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_STRT)
#define V_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_STRT(v) \
				_DD_MAKEVALUE(v, S_HSSPI_PROFILES_MODE_CTL_MULTIDATA_RD_STRT)
#define S_HSSPI_PROFILES_MODE_CTL_FILLBYTE			0
#define M_HSSPI_PROFILES_MODE_CTL_FILLBYTE \
				_DD_MAKEMASK(8, S_HSSPI_PROFILES_MODE_CTL_FILLBYTE)
#define V_HSSPI_PROFILES_MODE_CTL_FILLBYTE(v) \
				_DD_MAKEVALUE(v, S_HSSPI_PROFILES_MODE_CTL_FILLBYTE)

/* message control */
#define S_HSSPI_MSG_CTL_MSG_TYPE			13
#define V_HSSPI_MSG_CTL_MSG_TYPE(v)		_DD_MAKEVALUE(v, S_HSSPI_MSG_CTL_MSG_TYPE)
	#define HSSPI_MSG_CTL_MSG_TYPE_SLEEP		(0)
	#define HSSPI_MSG_CTL_MSG_TYPE_READ_WRITE	(1)
	#define HSSPI_MSG_CTL_MSG_TYPE_WRITE		(2)
	#define HSSPI_MSG_CTL_MSG_TYPE_READ			(3)
	#define HSSPI_MSG_CTL_MSG_TYPE_SETIRQ		(4)
#define S_HSSPI_MSG_CTL_BYTE_CNT		0
#define M_HSSPI_MSG_CTL_BYTE_CNT		_DD_MAKEMASK(10, S_HSSPI_MSG_CTL_BYTE_CNT)
#define V_HSSPI_MSG_CTL_BYTE_CNT(v)		_DD_MAKEVALUE(v, S_HSSPI_MSG_CTL_BYTE_CNT)


struct bcm63268_hsspi_pdata {
	unsigned int	fifo_size;
	int		bus_num;
	int		num_chipselect;
	int		freq_hz;
	int		profile;
};

int __init bcm63268_add_device_spi(const struct spi_board_info *info, unsigned n);

#endif /* __BCM63268_DEV_SPI_H__ */

