#ifndef BCM63268_CPU_H_
#define BCM63268_CPU_H_

#include <linux/types.h>
#include <linux/init.h>

/*
 * Macro to fetch bcm63268 cpu id and revision, should be optimized at
 * compile time if only one CPU support is enabled (idea stolen from
 * arm mach-types)
 */
#define BCM63268_CPU_ID		0x63268
#define BCM63168_CPU_ID		0x63168
#define BCM63167_CPU_ID		0x63168

void __init bcm63268_cpu_init(void);
u16 __bcm63268_get_cpu_id(void);
u16 bcm63268_get_cpu_rev(void);
unsigned int bcm63268_get_cpu_freq(void);

#ifdef CONFIG_BCM63268_CPU_63268
# ifdef bcm63268_get_cpu_id
#  undef bcm63268_get_cpu_id
#  define bcm63268_get_cpu_id()	__bcm63268_get_cpu_id()
#  define BCMCPU_RUNTIME_DETECT
# else
#  define bcm63268_get_cpu_id()	BCM63268_CPU_ID
# endif
# define BCMCPU_IS_63268()	(bcm63268_get_cpu_id() == BCM63268_CPU_ID)
#else
# define BCMCPU_IS_63268() (0)
#endif

#ifdef CONFIG_BCM63268_CPU_63168
# ifdef bcm63268_get_cpu_id
#  undef bcm63268_get_cpu_id
#  define bcm63268_get_cpu_id()	__bcm63268_get_cpu_id()
#  define BCMCPU_RUNTIME_DETECT
# else
#  define bcm63268_get_cpu_id()	BCM63168_CPU_ID
# endif
# define BCMCPU_IS_63168()	(bcm63268_get_cpu_id() == BCM63168_CPU_ID)
#else
# define BCMCPU_IS_63168()	(0)
#endif

#ifdef CONFIG_BCM63268_CPU_63167
# ifdef bcm63268_get_cpu_id
#  undef bcm63268_get_cpu_id
#  define bcm63268_get_cpu_id()	__bcm63268_get_cpu_id()
#  define BCMCPU_RUNTIME_DETECT
# else
#  define bcm63268_get_cpu_id()	BCM63167_CPU_ID
# endif
# define BCMCPU_IS_63167()	(bcm63268_get_cpu_id() == BCM63167_CPU_ID)
#else
# define BCMCPU_IS_63167()	(0)
#endif

#ifndef bcm63268_get_cpu_id
#error "No CPU support configured"
#endif

/*
 * While registers sets are (mostly) the same across 63268 CPU, base
 * address of these sets do change.
 */
enum bcm63268_regs_set {
	RSET_PERF = 0,
	RSET_TIMER,
	RSET_WDT,
	RSET_GPIO,
	RSET_UART0,
	RSET_UART1,
	RSET_HSSPI,
	RSET_MISC,
	RSET_LED,
	RSET_USB_EHCI,
	RSET_USB_OHCI,
	RSET_USBH_CFG,
	RSET_DDR,
	RSET_PCIE,
	RSET_WLAN,
	RSET_WLAN_SHIM,
	RSET_NAND,
	RSET_NAND_CACHE,
	RSET_NAND_INTR
};

#define RSET_WDT_SIZE			12
#define RSET_UART_SIZE			24
#define RSET_HSSPI_SIZE			1536
#define RSET_USB_EHCI_SIZE		256
#define RSET_USB_OHCI_SIZE		256
#define RSET_USB_CTRL_SIZE		64
#define RSET_WLAN_SIZE			8192
#define RSET_WLAN_SHIM_SIZE		2048
#define RSET_NAND_SIZE			384
#define RSET_NAND_CACHE_SIZE	512
#define RSET_NAND_INTR_SIZE		16

/*
 * 63268 register sets base address
 */
#define BCM_63268_PERF_BASE			(0xb0000000)
#define BCM_63268_TIMER_BASE		(0xb0000080)
#define BCM_63268_WDT_BASE			(0xb000009c)
#define BCM_63268_NAND_INTR_BASE	(0xb00000b0)
#define BCM_63268_GPIO_BASE			(0xb00000c0)
#define BCM_63268_UART0_BASE		(0xb0000180)
#define BCM_63268_UART1_BASE		(0xb00001a0)
#define BCM_63268_NAND_BASE			(0xb0000200)
#define BCM_63268_NAND_CACHE_BASE	(0xb0000600)
#define BCM_63268_HSSPI_BASE		(0xb0001000)
#define BCM_63268_MISC_BASE			(0xb0001800)
#define BCM_63268_LED_BASE			(0xb0001900)
#define BCM_63268_USB_EHCI_BASE		(0xb0002500)
#define BCM_63268_USB_OHCI_BASE		(0xb0002600)
#define BCM_63268_USBH_CFG_BASE		(0xb0002700)
#define BCM_63268_DDR_BASE			(0xb0003000)
#define BCM_63268_WLAN_BASE			(0xb0004000)
#define BCM_63268_WLAN_SHIM_BASE	(0xb0007000)
#define BCM_63268_PCIE_BASE			(0xb06e0000)


extern const unsigned long *bcm63268_regs_base;

static inline unsigned long bcm63268_regset_address(enum bcm63268_regs_set set)
{
#ifdef BCMCPU_RUNTIME_DETECT
	return bcm63268_regs_base[set];
#else
#ifdef CONFIG_BCM63268_CPU_63268
	switch (set) {
	case RSET_PERF:
		return BCM_63268_PERF_BASE;
	case RSET_TIMER:
		return BCM_63268_TIMER_BASE;
	case RSET_WDT:
		return BCM_63268_WDT_BASE;
	case RSET_GPIO:
		return BCM_63268_GPIO_BASE;
	case RSET_UART0:
		return BCM_63268_UART0_BASE;
	case RSET_UART1:
		return BCM_63268_UART1_BASE;
	case RSET_HSSPI:
		return BCM_63268_HSSPI_BASE;
	case RSET_MISC:
		return BCM_63268_MISC_BASE;
	case RSET_LED:
		return BCM_63268_LED_BASE;
	case RSET_USB_EHCI:
		return BCM_63268_USB_EHCI_BASE;
	case RSET_USB_OHCI:
		return BCM_63268_USB_OHCI_BASE;
	case RSET_USBH_CFG:
		return BCM_63268_USBH_CFG_BASE;
	case RSET_DDR:
		return BCM_63268_DDR_BASE;
	case RSET_PCIE:
		return BCM_63268_PCIE_BASE;
	case RSET_WLAN:
		return BCM_63268_WLAN_BASE;
	case RSET_WLAN_SHIM:
		return BCM_63268_WLAN_SHIM_BASE;
	case RSET_NAND:
		return BCM_63268_NAND_BASE;
	case RSET_NAND_CACHE:
		return BCM_63268_NAND_CACHE_BASE;
	case RSET_NAND_INTR:
		return BCM_63268_NAND_INTR_BASE;
	}
#elif defined(CONFIG_BCM63268_CPU_63168)
	switch (set) {
	case RSET_PERF:
		return BCM_63268_PERF_BASE;
	case RSET_TIMER:
		return BCM_63268_TIMER_BASE;
	case RSET_WDT:
		return BCM_63268_WDT_BASE;
	case RSET_GPIO:
		return BCM_63268_GPIO_BASE;
	case RSET_UART0:
		return BCM_63268_UART0_BASE;
	case RSET_UART1:
		return BCM_63268_UART1_BASE;
	case RSET_HSSPI:
		return BCM_63268_HSSPI_BASE;
	case RSET_MISC:
		return BCM_63268_MISC_BASE;
	case RSET_LED:
		return BCM_63268_LED_BASE;
	case RSET_USB_EHCI:
		return BCM_63268_USB_EHCI_BASE;
	case RSET_USB_OHCI:
		return BCM_63268_USB_OHCI_BASE;
	case RSET_USBH_CFG:
		return BCM_63268_USBH_CFG_BASE;
	case RSET_DDR:
		return BCM_63268_DDR_BASE;
	case RSET_PCIE:
		return BCM_63268_PCIE_BASE;
	case RSET_WLAN:
		return BCM_63268_WLAN_BASE;
	case RSET_WLAN_SHIM:
		return BCM_63268_WLAN_SHIM_BASE;
	case RSET_NAND:
		return BCM_63268_NAND_BASE;
	case RSET_NAND_CACHE:
		return BCM_63268_NAND_CACHE_BASE;
	case RSET_NAND_INTR:
		return BCM_63268_NAND_INTR_BASE;
	}
#elif defined(CONFIG_BCM63268_CPU_63167)
	switch (set) {
	case RSET_PERF:
		return BCM_63268_PERF_BASE;
	case RSET_TIMER:
		return BCM_63268_TIMER_BASE;
	case RSET_WDT:
		return BCM_63268_WDT_BASE;
	case RSET_GPIO:
		return BCM_63268_GPIO_BASE;
	case RSET_UART0:
		return BCM_63268_UART0_BASE;
	case RSET_UART1:
		return BCM_63268_UART1_BASE;
	case RSET_HSSPI:
		return BCM_63268_HSSPI_BASE;
	case RSET_MISC:
		return BCM_63268_MISC_BASE;
	case RSET_LED:
		return BCM_63268_LED_BASE;
	case RSET_USB_EHCI:
		return BCM_63268_USB_EHCI_BASE;
	case RSET_USB_OHCI:
		return BCM_63268_USB_OHCI_BASE;
	case RSET_USBH_CFG:
		return BCM_63268_USBH_CFG_BASE;
	case RSET_DDR:
		return BCM_63268_DDR_BASE;
	case RSET_PCIE:
		return BCM_63268_PCIE_BASE;
	case RSET_WLAN:
		return BCM_63268_WLAN_BASE;
	case RSET_WLAN_SHIM:
		return BCM_63268_WLAN_SHIM_BASE;
	case RSET_NAND:
		return BCM_63268_NAND_BASE;
	case RSET_NAND_CACHE:
		return BCM_63268_NAND_CACHE_BASE;
	case RSET_NAND_INTR:
		return BCM_63268_NAND_INTR_BASE;
	}
#endif
#endif
	/* unreached */
	return 0;
}

/*
 * IRQ number changes across CPU too
 */
enum bcm63268_irq {
	IRQ_TIMER = 0,
	IRQ_UART0,
	IRQ_UART1,
	IRQ_HSSPI,
	IRQ_WLAN_GPIO,
	IRQ_WLAN,
	IRQ_IPSEC,
	IRQ_USB_OHCI,
	IRQ_USB_EHCI,
	IRQ_NAND,
	IRQ_PCM,
	IRQ_EPHY,
	IRQ_GPHY,
	IRQ_DYING_GASP,
	IRQ_EPHY_ENERGY,
	IRQ_GPHY_ENERGY,
	IRQ_IPSEC_DMA0,
	IRQ_IPSEC_DMA1,
	IRQ_XDSL,
	IRQ_FAP,
	IRQ_PCIE_RC,
	IRQ_PCIE_EP,
	IRQ_ETHSW_RX_DMA,
	IRQ_ETHSW_TX_DMA,
	IRQ_PCM_DMA,
	IRQ_DECT,
	IRQ_EXTERNAL,
	IRQ_SAR,
	IRQ_SAR_DMA0,
	IRQ_SAR_DMA1,
	IRQ_SAR_DMA2,
	IRQ_RING_OSC,
	IRQ_GMAC,
	IRQ_GMAC_DMA,
	IRQ_ROBOSW
};

/*
 * 63268 irqs
 */
#define BCM_63268_TIMER_IRQ				(IRQ_INTERNAL_BASE + 0)
#define BCM_63268_ETHSW_RX_DMA_IRQ_BASE	(IRQ_INTERNAL_BASE + 1)
#define BCM_63268_UART0_IRQ				(IRQ_INTERNAL_BASE + 5)
#define BCM_63268_HSSPI_IRQ				(IRQ_INTERNAL_BASE + 6)
#define BCM_63268_WLAN_IRQ				(IRQ_INTERNAL_BASE + 7)
#define BCM_63268_IPSEC_IRQ				(IRQ_INTERNAL_BASE + 8)
#define BCM_63268_USBH_OHCI_IRQ			(IRQ_INTERNAL_BASE + 9)
#define BCM_63268_USBH_EHCI_IRQ			(IRQ_INTERNAL_BASE + 10)
#define BCM_63268_USBD_IRQ				(IRQ_INTERNAL_BASE + 11)
#define BCM_63268_PCM_IRQ				(IRQ_INTERNAL_BASE + 12)
#define BCM_63268_EPHY_IRQ				(IRQ_INTERNAL_BASE + 13)
#define BCM_63268_DYING_GASP_IRQ		(IRQ_INTERNAL_BASE + 14)
#define BCM_63268_EPHY_ENERGY_IRQ_BASE	(IRQ_INTERNAL_BASE + 15)
#define BCM_63268_GPHY_ENERGY_IRQ_BASE	(IRQ_INTERNAL_BASE + 18)
#define BCM_63268_USB_CNTL_RX_DMA		(IRQ_INTERNAL_BASE + 19)
#define BCM_63268_USB_BULK_RX_DMA		(IRQ_INTERNAL_BASE + 20)
#define BCM_63268_USB_ISO_RX_DMA		(IRQ_INTERNAL_BASE + 21)
#define BCM_63268_IPSEC_DMA0_IRQ		(IRQ_INTERNAL_BASE + 22)
#define BCM_63268_XDSL_IRQ				(IRQ_INTERNAL_BASE + 23)
#define BCM_63268_FAP_IRQ_BASE			(IRQ_INTERNAL_BASE + 24)
#define BCM_63268_SAR_DMA_IRQ_BASE0		(IRQ_INTERNAL_BASE + 26)
#define BCM_63268_WAKE_ON_IRQ			(IRQ_INTERNAL_BASE + 30)
#define BCM_63268_GPHY_IRQ				(IRQ_INTERNAL_BASE + 31)

#define BCM_63268_DECT_IRQ_BASE			(IRQ_INTERNAL_BASE + 32)
#define BCM_63268_UART1_IRQ				(IRQ_INTERNAL_BASE + 34)
#define BCM_63268_WLAN_GPIO_IRQ			(IRQ_INTERNAL_BASE + 35)
#define BCM_63268_USB_CNTL_TX_DMA		(IRQ_INTERNAL_BASE + 36)
#define BCM_63268_USB_BULK_TX_DMA		(IRQ_INTERNAL_BASE + 37)
#define BCM_63268_USB_ISO_TX_DMA		(IRQ_INTERNAL_BASE + 38)
#define BCM_63268_IPSEC_DMA1_IRQ		(IRQ_INTERNAL_BASE + 39)
#define BCM_63268_PCIE_RC_IRQ			(IRQ_INTERNAL_BASE + 40)
#define BCM_63268_PCIE_EP_IRQ			(IRQ_INTERNAL_BASE + 41)
#define BCM_63268_PCM_DMA_IRQ_BASE		(IRQ_INTERNAL_BASE + 42)
#define BCM_63268_EXTERNAL_IRQ_BASE		(IRQ_INTERNAL_BASE + 44)
#define BCM_63268_ROBOSW_IRQ			(IRQ_INTERNAL_BASE + 48)
#define BCM_63268_SAR_IRQ				(IRQ_INTERNAL_BASE + 49)
#define BCM_63268_NAND_IRQ				(IRQ_INTERNAL_BASE + 50)
#define BCM_63268_RING_OSC_IRQ			(IRQ_INTERNAL_BASE + 52)
#define BCM_63268_USB_CONN_IRQ			(IRQ_INTERNAL_BASE + 53)
#define BCM_63268_USB_DISCONN_IRQ		(IRQ_INTERNAL_BASE + 54)
#define BCM_63268_SAR_DMA_IRQ_BASE1		(IRQ_INTERNAL_BASE + 55)

#define BCM_63268_ETHSW_TX_DMA_IRQ_BASE	(IRQ_INTERNAL_BASE + 64)
#define BCM_63268_SAR_DMA_IRQ_BASE2		(IRQ_INTERNAL_BASE + 68)
#define BCM_63268_GMAC_DMA_IRQ_BASE		(IRQ_INTERNAL_BASE + 81)
#define BCM_63268_GMAC_IRQ				(IRQ_INTERNAL_BASE + 83)

extern const int *bcm63268_irqs;

static inline int bcm63268_get_irq_number(enum bcm63268_irq irq)
{
	return bcm63268_irqs[irq];
}

/*
 * return installed memory size
 */
unsigned int bcm63268_get_memory_size(void);

/*
 * Coprocessor 0 Broadcom Config Register Bits
 */
#define CP0_BCM_CFG_ICSHEN          (0x1 << 31)
#define CP0_BCM_CFG_DCSHEN          (0x1 << 30)
#define CP0_BCM_CFG_TLBPD           (0x1 << 28)
#define CP0_BCM_CFG_BTHD            (0x1 << 21)
#define CP0_BCM_CFG_CLF             (0x1 << 20)
#define CP0_BCM_CFG_NBK             (0x1 << 17)

/*
 * Coprocessor 0 CMT Interrupt Register Bits
 */
#define CP0_CMT_XIR_4               (0x1 << 31)
#define CP0_CMT_XIR_3               (0x1 << 30)
#define CP0_CMT_XIR_2               (0x1 << 29)
#define CP0_CMT_XIR_1               (0x1 << 28)
#define CP0_CMT_XIR_0               (0x1 << 27)
#define CP0_CMT_SIR_1               (0x1 << 16)
#define CP0_CMT_SIR_0               (0x1 << 15)
#define CP0_CMT_NMIR_TP1            (0x1 << 1)
#define CP0_CMT_NMIR_TP0            (0x1 << 0)

/*
 * Coprocessor 0 CMT Control Register Bits
 */
#define CP0_CMT_DSU_TP1             (0x1 << 30)
#define CP0_CMT_TPS_SHFT            16
#define CP0_CMT_TPS_MASK            (0xF << CP0_CMT_TPS_SHFT)
#define CP0_CMT_PRIO_TP1            (0x1 << 5)
#define CP0_CMT_PRIO_TP0            (0x1 << 4)
#define CP0_CMT_RSTSE               (0x1 << 0)

#endif /* !BCM63268_CPU_H_ */

