#ifndef __BCM63268_BOARD_H__
#define __BCM63268_BOARD_H__

#include <linux/types.h>
#include <linux/gpio.h>
#include <linux/gpio_buttons.h>
#include <linux/gpio_keys.h>
#include <linux/leds.h>
#include <boardparms.h>

/*
 * board definition
 */
struct board_info {
	u32		woc_subsysid;
	u8		hwver[8];
	u8		serial_num[128];
	u8		name[16];
	unsigned int	expected_cpu_id;

	BOARD_ETHERNET_INFO *enet_info;

	unsigned int	has_xdsl:1;
	unsigned int	has_xdsl_pwr_map:1;
	unsigned int	has_xdsl_mode_map:1;
	unsigned int	has_xdsl_ctrl_pin_used:1;
	unsigned int	has_xdsl_ctrl_pin_swapped:1;
	unsigned int	has_xdsl_pwr_activelow:1;
	unsigned int	has_xdsl_mode_activelow:1;
	unsigned int	has_pci:1;
	unsigned int	has_ohci:1;
	unsigned int	has_ehci:1;
	unsigned int	has_wlan:1;

	u8		xdsl_mac_addr[6];
	u8		wlan_mac_addr[6];

	/* GPIO LEDs */
	struct gpio_led leds[16];

	/* GPIO buttons */
#if defined(CONFIG_INPUT_GPIO_BUTTONS) || defined(CONFIG_INPUT_GPIO_BUTTONS_MODULE)
	struct gpio_button buttons[4];
#endif

#if defined(CONFIG_INPUT_GPIO_BUTTONS_HOTPLUG_V2) || defined(CONFIG_INPUT_GPIO_BUTTONS_HOTPLUG_V2_MODULE)
	struct gpio_keys_button buttons[4];
#endif

	u8				activeimg[8];
	u8				fwver[32];
	u8				fwdate[32];
	u8				bootver[32];
	u8				bootdate[32];
};

const char *bcm63268_board_get_name(void);

const char *bcm63268_board_get_sys_type(void);

void bcm63268_board_prom_init(void);

void bcm63268_board_setup(void);

int bcm63268_board_register_devices(void);

BOARD_ETHERNET_INFO *bcm63268_board_get_enet_info(void);

int bcm63268_board_get_enet_port_connected_to_ext_switch(void);

void bcm63268_board_get_wlan_mac(u8 *wlan_mac);

int bcm63268_board_get_xdsl_phy_enabled(void);

void bcm63268_board_get_xdsl_mac(u8 *xdsl_mac);

int bcm63268_board_get_xdsl_pwr_map(void);

int bcm63268_board_get_xdsl_mode_map(void);

int bcm63268_board_get_xdsl_ctrlpin_used(void);

int bcm63268_board_get_xdsl_ctrlpin_swapped(void);

int bcm63268_board_get_xdsl_ctrlpin_pwr_activelow(void);

int bcm63268_board_get_xdsl_ctrlpin_mode_activelow(void);

u32 bcm63268_board_get_woc_subsysid(void);

u32 bcm63268_board_get_regset_addr(int set);

int bcm63268_board_get_eth_channel_irq(int channel);

void bcm63268_r4k_wait_set(int enable);

int bcm63268_r4k_wait_check(void);

void bcm63268_dying_gasp_register(char * name, void * cbfn, void * context);
void bcm63268_dying_gasp_deregister(char * name);

unsigned int bcm63268_get_ubus_freq(void);

#define board_get_enet_info bcm63268_board_get_enet_info

#define board_get_enet_port_connected_to_ext_switch bcm63268_board_get_enet_port_connected_to_ext_switch

#define board_get_wlan_mac bcm63268_board_get_wlan_mac

#define board_get_xdsl_phy_enabled bcm63268_board_get_xdsl_phy_enabled

#define board_get_xdsl_mac bcm63268_board_get_xdsl_mac

#define board_get_xdsl_pwr_map bcm63268_board_get_xdsl_pwr_map

#define board_get_xdsl_mode_map bcm63268_board_get_xdsl_mode_map

#define board_get_xdsl_ctrlpin_used bcm63268_board_get_xdsl_ctrlpin_used

#define board_get_xdsl_ctrlpin_swapped bcm63268_board_get_xdsl_ctrlpin_swapped

#define board_get_xdsl_ctrlpin_pwr_activelow bcm63268_board_get_xdsl_ctrlpin_pwr_activelow

#define board_get_xdsl_ctrlpin_mode_activelow bcm63268_board_get_xdsl_ctrlpin_mode_activelow

#define board_get_eth_channel_irq bcm63268_board_get_eth_channel_irq

#define board_get_eth_gmac_dma_irq() bcm63268_get_irq_number(IRQ_GMAC_DMA)

#define board_get_eth_gmac_irq() bcm63268_get_irq_number(IRQ_GMAC)

#define board_get_eth_phy_irq() bcm63268_get_irq_number(IRQ_EPHY)

#define board_get_eth_phy_energy_det_irq() bcm63268_get_irq_number(IRQ_EPHY_ENERGY)

#define board_get_eth_gphy_energy_det_irq() bcm63268_get_irq_number(IRQ_GPHY_ENERGY)

#define board_get_eth_gphy_irq() bcm63268_get_irq_number(IRQ_GPHY)

#define board_get_eth_channel_irq bcm63268_board_get_eth_channel_irq

#define board_get_atm_dma_rx_irq() bcm63268_get_irq_number(IRQ_SAR_DMA0)

#define board_get_atm_dma_tx_irq() (bcm63268_get_irq_number(IRQ_SAR_DMA1) + 4)

#define board_get_adsl_phy_irq() (bcm63268_get_irq_number(IRQ_XDSL))

#define board_get_fap_irq(fapidx) (bcm63268_get_irq_number(IRQ_FAP) + fapidx)

#define board_get_memory_size() (bcm63268_get_memory_size())

#define board_set_r4k_wait		bcm63268_r4k_wait_set

#define board_check_r4k_wait	bcm63268_r4k_wait_check

#define board_register_dying_gasp	bcm63268_dying_gasp_register

#define board_deregister_dying_gasp	bcm63268_dying_gasp_deregister

#endif /* ! __BCM63268_BOARD_H__ */

