/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/gpio.h>
#include <linux/clk.h>
#include <linux/platform_device.h>
#include <asm/bootinfo.h>
#include <asm/time.h>
#include <asm/reboot.h>
#include <asm/cacheflush.h>
#include <bcm63268_board.h>
#include <bcm63268_cpu.h>
#include <bcm63268_regs.h>
#include <bcm63268_io.h>

int __init bcm63268_xdsl_init(void)
{
	u32 reg32;
	struct clk *xdsl_clk;

	/* enable USB host controller clock */
	xdsl_clk = clk_get(NULL, "xdsl");
	if (IS_ERR(xdsl_clk))
		return -ENODEV;
	clk_enable(xdsl_clk);

	reg32 = bcm_perf_readl(PERF_SOFTRESET_REG);
	reg32 |= SOFTRESET_63268_SAR;
	bcm_perf_writel(reg32, PERF_SOFTRESET_REG);

	reg32 = bcm_timer_readl(TIMER_CLK_RESET_REG);
	reg32 |= TIMER_CLK_RESET_DSL_ENERGY_DETECT;
	bcm_timer_writel(reg32, TIMER_CLK_RESET_REG);

	reg32 = bcm_misc_readl(MISC_IDDQCTL_REG);
	reg32 &= ~(MISCIDDQCTL_VDSL_MIPS | MISCIDDQCTL_VDSL_PHY | MISCIDDQCTL_SAR);
	bcm_misc_writel(reg32, MISC_IDDQCTL_REG);
	mdelay(100);

#if 0
	reg32 = bcm_gpio_readl(GPIO_BASEMODE_REG);
	reg32 |= GPIO_BASEMODE_VDSL_PHY_OVERRIDE_0 | GPIO_BASEMODE_VDSL_PHY_OVERRIDE_1;
	bcm_gpio_writel(reg32, GPIO_BASEMODE_REG);
#endif

	return 0;
}

/* void *operator new(unsigned int sz) */
void *_Znwj(unsigned int sz) {
	return (kmalloc(sz, GFP_KERNEL));
}

/* void operator delete(void *m) */
void _ZdlPv(void *m) {
	kfree(m);
}

EXPORT_SYMBOL(_Znwj);
EXPORT_SYMBOL(_ZdlPv);

