/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/bootmem.h>
#include <linux/ioport.h>
#include <linux/pm.h>
#include <linux/clk.h>
#include <asm/bootinfo.h>
#include <asm/time.h>
#include <asm/reboot.h>
#include <asm/cacheflush.h>
#include <bcm63268_board.h>
#include <bcm63268_cpu.h>
#include <bcm63268_regs.h>
#include <bcm63268_io.h>
#include <bcm63268_woc.h>

int __init bcm63268_woc_init(void)
{
	u32 reg32;
	struct clk *woc_clk;

	/* enable WOC clock */
	woc_clk = clk_get(NULL, "woc");
	if (IS_ERR(woc_clk))
		return -ENODEV;
	clk_enable(woc_clk);
	mdelay(10);

	reg32 = bcm_perf_readl(PERF_SOFTRESET_REG);
	
	reg32 &= ~(SOFTRESET_63268_WLAN_SHIM | SOFTRESET_63268_WLAN_SHIM_UBUS);
	bcm_perf_writel(reg32, PERF_SOFTRESET_REG);
	mdelay(1);
	
	reg32 |= (SOFTRESET_63268_WLAN_SHIM | SOFTRESET_63268_WLAN_SHIM_UBUS);
	bcm_perf_writel(reg32, PERF_SOFTRESET_REG);
	mdelay(1);

	reg32 = WLAN_SHIM_MISC_FORCE_CLOCKS_ON | WLAN_SHIM_MISC_MACRO_SOFT_RESET;
	bcm_wlan_shim_writel(reg32, WLAN_SHIM_MISC_REG);
	mdelay(1);
	
	reg32 = SICF_FGC | SICF_CLOCK_EN;
	bcm_wlan_shim_writel(reg32, WLAN_SHIM_MAC_CTRL_REG);
	
	reg32 = WLAN_SHIM_MISC_FORCE_CLOCKS_ON;
	bcm_wlan_shim_writel(reg32, WLAN_SHIM_MISC_REG);
	
	reg32 = 0;
	bcm_wlan_shim_writel(reg32, WLAN_SHIM_MISC_REG);
	
	reg32 = SICF_CLOCK_EN;
	bcm_wlan_shim_writel(reg32, WLAN_SHIM_MAC_CTRL_REG);
	
	return 0;
}

