/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/


#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/bootmem.h>
#include <linux/ioport.h>
#include <linux/pm.h>
#include <linux/clk.h>
#include <asm/bootinfo.h>
#include <asm/time.h>
#include <asm/reboot.h>
#include <asm/cacheflush.h>
#include <bcm63268_board.h>
#include <bcm63268_cpu.h>
#include <bcm63268_regs.h>
#include <bcm63268_io.h>

int __init bcm63268_usb_hc_init(void)
{
	u32 reg32;
	struct clk *usbh_clk;

	/* enable USB host controller clock */
	usbh_clk = clk_get(NULL, "usbh");
	if (IS_ERR(usbh_clk))
		return -ENODEV;
	clk_enable(usbh_clk);

	reg32 = bcm_perf_readl(PERF_SOFTRESET_REG);
	reg32 |= SOFTRESET_63268_USBH;
	bcm_perf_writel(reg32, PERF_SOFTRESET_REG);

	reg32 = bcm_timer_readl(TIMER_CLK_RESET_REG);
	reg32 |= TIMER_CLK_RESET_USB_REFCLK_ENABLE;
	bcm_timer_writel(reg32, TIMER_CLK_RESET_REG);

	reg32 = bcm_misc_readl(MISC_IDDQCTL_REG);
	reg32 &= ~MISCIDDQCTL_USBH;
	bcm_misc_writel(reg32, MISC_IDDQCTL_REG);
	mdelay(100);

	reg32 = USB_CTRL_SWAPCTL_EHCI_ENDIAN_SWAP | USB_CTRL_SWAPCTL_OHCI_ENDIAN_SWAP;
	bcm_usbh_writel(reg32, USB_CTRL_SWAPCTL_REG);

	reg32 = bcm_usbh_readl(USB_CTRL_SETUP_REG);
	reg32 |= USB_CTRL_SETUP_USBH_IOC;
	bcm_usbh_writel(reg32, USB_CTRL_SETUP_REG);

	reg32 &= ~USB_CTRL_SETUP_USBH_IPP;
	bcm_usbh_writel(reg32, USB_CTRL_SETUP_REG);

	reg32 = bcm_usbh_readl(USB_CTRL_PLLCTL_REG);
	reg32 &= ~(USB_CTRL_PLL_IDDQ_POWER_DOWN | USB_CTRL_PLL_POWER_DOWN_DELAY);
	bcm_usbh_writel(reg32, USB_CTRL_PLLCTL_REG);

	return 0;
}

