/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/platform_device.h>
#include <bcm63268_cpu.h>

static struct resource uart0_resources[] = {
	{
		.start		= -1, /* filled at runtime */
		.end		= -1, /* filled at runtime */
		.flags		= IORESOURCE_MEM,
	},
	{
		.start		= -1, /* filled at runtime */
		.flags		= IORESOURCE_IRQ,
	},
};

static struct resource uart1_resources[] = {
	{
		.start		= -1, /* filled at runtime */
		.end		= -1, /* filled at runtime */
		.flags		= IORESOURCE_MEM,
	},
	{
		.start		= -1, /* filled at runtime */
		.flags		= IORESOURCE_IRQ,
	},
};

static struct platform_device bcm63268_uart_device[2] = {
	{
	.name		= "bcm63268-uart",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(uart0_resources),
	.resource	= uart0_resources,
	},
	{
	.name		= "bcm63268-uart",
	.id		= 1,
	.num_resources	= ARRAY_SIZE(uart1_resources),
	.resource	= uart1_resources,
	}
};

int __init bcm63268_uart_register(void)
{
	int rv = 0;
	uart0_resources[0].start = bcm63268_regset_address(RSET_UART0);
	uart0_resources[0].end = uart0_resources[0].start;
	uart0_resources[0].end += RSET_UART_SIZE - 1;
	uart0_resources[1].start = bcm63268_get_irq_number(IRQ_UART0);
	uart1_resources[0].start = bcm63268_regset_address(RSET_UART1);
	uart1_resources[0].end = uart1_resources[0].start;
	uart1_resources[0].end += RSET_UART_SIZE - 1;
	uart1_resources[1].start = bcm63268_get_irq_number(IRQ_UART1);
	rv += platform_device_register(&bcm63268_uart_device[0]);
	rv += platform_device_register(&bcm63268_uart_device[1]);

	return rv;
}

arch_initcall(bcm63268_uart_register);

