/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/platform_device.h>

#include <bcm63268_cpu.h>
#include <bcm63268_dev_hsspi.h>
#include <bcm63268_regs.h>

static struct resource spi_resources[] = {
	{
		.start		= -1, /* filled at runtime */
		.end		= -1, /* filled at runtime */
		.flags		= IORESOURCE_MEM,
	},
	{
		.start		= -1, /* filled at runtime */
		.flags		= IORESOURCE_IRQ,
	},
};

static struct bcm63268_hsspi_pdata spi_pdata = {
	.fifo_size		= HSSPI_BCM_63268_FIFO_SIZE,
	.bus_num		= 0,
	.num_chipselect	= 4,
	.freq_hz		= (40 * 1000 * 1000),	/* 40 MHz */
	.profile		= 0,
};

static struct platform_device bcm63268_spi_device = {
	.name		= "bcm63268-hsspi",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(spi_resources),
	.resource	= spi_resources,
	.dev		= {
		.platform_data = &spi_pdata,
	},
};

int __init bcm63268_add_device_spi(const struct spi_board_info *info, unsigned n)
{
	spi_resources[0].start = bcm63268_regset_address(RSET_HSSPI);
	spi_resources[0].end = spi_resources[0].start;
	spi_resources[0].end += RSET_HSSPI_SIZE - 1;
	spi_resources[1].start = bcm63268_get_irq_number(IRQ_HSSPI);

	/* Fill in platform data */
	if (BCMCPU_IS_63168())
		spi_pdata.fifo_size = HSSPI_BCM_63268_FIFO_SIZE;

	spi_register_board_info(info, n);
	
	return platform_device_register(&bcm63268_spi_device);
}


