/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#include <linux/init.h>
#include <linux/bootmem.h>
#include <asm/bootinfo.h>
#include <asm/mips-boards/prom.h>
#include <bcm63268_board.h>
#include <bcm63268_cpu.h>
#include <bcm63268_io.h>
#include <bcm63268_regs.h>
#include <bcm63268_gpio.h>
#include <bcm63268_led.h>

#undef DEBUG

#undef ICE_DEBUG

#ifdef ICE_DEBUG
static char *prom_env_memsize = "memsize=64";
static int prom_env_fixed[2] = {0, 0};
static int prom_argv_fixed[2] = {0, 0};
#endif

int _prom_argc;
int *_prom_argv, *_prom_envp;
EXPORT_SYMBOL(_prom_envp);

extern void prom_printf(const char * fmt, ...);
extern int  do_syslog(int, char *, int);

/* A 32-bit PROM pass arguments and environment as 32-bit pointer.
   These macros take care of sign extension.  */
#define prom_envp(index) ((char *)(long)_prom_envp[(index)])

char *prom_getenv(char *envname)
{
	/*
	 * Return a pointer to the given environment variable.
	 * In 64-bit mode: we're using 64-bit pointers, but all pointers
	 * in the PROM structures are only 32-bit, so we need some
	 * workarounds, if we are running in 64-bit mode.
	 */
	int i, index=0;

	i = strlen(envname);

	while (prom_envp(index)) {
		if(strncmp(envname, prom_envp(index), i) == 0) {
			return (prom_envp(index) + i + 1);
		}
		index++;
	}

	return NULL;
}
EXPORT_SYMBOL(prom_getenv);

static void __init prom_init_env(void)
{
#ifdef DEBUG
	int index = 0;
#endif

#ifdef ICE_DEBUG
	_prom_argc = 0;
	_prom_argv = (int *)prom_argv_fixed;
	prom_env_fixed[0] = (int)&prom_env_memsize[0];
	_prom_envp = (int *)prom_env_fixed;
#else
	_prom_argc = fw_arg0;
	_prom_argv = (int *) fw_arg1;
	_prom_envp = (int *) fw_arg2;
#endif /* ICE_DEBUG */
	
#ifdef DEBUG
	pr_info("PROM ENVP dump(0x%x):\n", (unsigned int)_prom_envp);
	while (prom_envp(index)) {
		pr_info("envp[%02d] => %s\n", index, prom_envp(index));
		index++;
	}
#endif
}

/* Force a console handover by adding a console= argument if needed */
static void __init prom_init_console(void)
{
	char console_string[40];
	int baud = 0;
	char parity = '\0', bits = '\0', flow = '\0';
	char *s;

	if ((strstr(prom_getcmdline(), "console=")) == NULL) {
		s = prom_getenv("baudrate");
		if (s) {
			while (*s >= '0' && *s <= '9')
				baud = baud*10 + *s++ - '0';
			if (*s == ',') s++;
			if (*s) parity = *s++;
			if (*s == ',') s++;
			if (*s) bits = *s++;
			if (*s == ',') s++;
			if (*s == 'h') flow = 'r';
		}

		if (baud == 0)
			baud = 115200;
		if (parity != 'n' && parity != 'o' && parity != 'e')
			parity = 'n';
		if (bits != '7' && bits != '8')
			bits = '8';
		if (flow == '\0')
			flow = 'r';
		sprintf(console_string, " console=ttyS0,%d%c%c%c", baud, parity, bits, flow);
#if 0
		strcat(prom_getcmdline(), console_string);
		pr_info("Config serial console:%s\n", console_string);
#endif
	}
}

void __init prom_init(void)
{
	u32 mask;

	prom_init_env();
	prom_init_cmdline();
	prom_init_console();

#if defined(CONFIG_PRINTK)
    do_syslog(8, NULL, 8);
#endif

	bcm63268_cpu_init();

	/* stop any running watchdog */
	bcm_wdt_writel(WDT_STOP_1, WDT_CTL_REG);
	bcm_wdt_writel(WDT_STOP_2, WDT_CTL_REG);

	/* disable all hardware blocks clock for now */
	if (BCMCPU_IS_63268() || BCMCPU_IS_63168())
		mask = CKCTL_63268_ALL_SAFE_EN;

	bcm_perf_writel(mask, PERF_CKCTL_REG);
	udelay(500);

	/* register gpiochip */
	bcm63268_gpio_init();

	bcm63268_led_init();
	
	/* do low level board init */
	bcm63268_board_prom_init();
}

void __init prom_free_prom_memory(void)
{
	/* do nothing here */
}

