/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/


#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/bootmem.h>
#include <linux/ioport.h>
#include <linux/pm.h>
#include <linux/clk.h>
#include <asm/bootinfo.h>
#include <asm/time.h>
#include <asm/reboot.h>
#include <asm/cacheflush.h>
#include <bcm63268_board.h>
#include <bcm63268_cpu.h>
#include <bcm63268_regs.h>
#include <bcm63268_io.h>
#include <bcm63268_pcie.h>

int __init bcm63268_pcie_init(void)
{
	u32 reg32;
	struct clk *pcie_clk;

	/* enable PCIE clock */
	pcie_clk = clk_get(NULL, "pcie");
	if (IS_ERR(pcie_clk))
		return -ENODEV;

	clk_enable(pcie_clk);

    /* pcie serdes enable */
	reg32 = bcm_misc_readl(MISC_SERDESCTL_REG);
	reg32 |= MISCSERDESCTL_PCIE_ENABLE | MISCSERDESCTL_PCIE_EXD_ENABLE;
	bcm_misc_writel(reg32, MISC_SERDESCTL_REG);

	reg32 = bcm_perf_readl(PERF_SOFTRESET_REG);
	reg32 &= ~(SOFTRESET_63268_PCIE_CORE | SOFTRESET_63268_PCIE 
		| SOFTRESET_63268_PCIE_EXT | SOFTRESET_63268_PCIE_HARD);
	bcm_perf_writel(reg32, PERF_SOFTRESET_REG);
	mdelay(10);

	reg32 |= SOFTRESET_63268_PCIE_HARD;
	bcm_perf_writel(reg32, PERF_SOFTRESET_REG);
	mdelay(10);
	
	reg32 |= (SOFTRESET_63268_PCIE_CORE | SOFTRESET_63268_PCIE);
	bcm_perf_writel(reg32, PERF_SOFTRESET_REG);
	mdelay(10);
	
	reg32 |= SOFTRESET_63268_PCIE_EXT;
	bcm_perf_writel(reg32, PERF_SOFTRESET_REG);
	
	/* this is a critical delay */
	mdelay(200);

	return 0;
}

