/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/platform_device.h>

#include <bcm63268_cpu.h>
#include <bcm63268_dev_nand.h>
#include <bcm63268_regs.h>

static struct resource nand_resources[] = {
	[0] = {
		.start		= -1, /* filled at runtime */
		.end		= -1, /* filled at runtime */
		.flags		= IORESOURCE_MEM,
	},
	[1] = {
		.start		= -1, /* filled at runtime */
		.end		= -1, /* filled at runtime */
		.flags		= IORESOURCE_MEM,
	},
	[2] = {
		.start		= -1, /* filled at runtime */
		.end		= -1, /* filled at runtime */
		.flags		= IORESOURCE_MEM,
	},
	[3] = {
		.start		= -1, /* filled at runtime */
		.end		= -1, /* filled at runtime */
		.flags		= IORESOURCE_IRQ,
	},
};

static struct platform_device bcm63268_nand_device = {
	.name = "bcm63268-nand",
	.id	= -1,
	.num_resources = ARRAY_SIZE(nand_resources),
	.resource = nand_resources
};

int __init bcm63268_add_device_nand(void *pdata, size_t size_data)
{	
	nand_resources[0].start = bcm63268_regset_address(RSET_NAND);
	nand_resources[0].end = nand_resources[0].start;
	nand_resources[0].end += RSET_NAND_SIZE - 1;
	nand_resources[1].start = bcm63268_regset_address(RSET_NAND_CACHE);
	nand_resources[1].end = nand_resources[1].start;
	nand_resources[1].end += RSET_NAND_CACHE_SIZE - 1;
	nand_resources[2].start = bcm63268_regset_address(RSET_NAND_INTR);
	nand_resources[2].end = nand_resources[2].start;
	nand_resources[2].end += RSET_NAND_INTR_SIZE - 1;
	nand_resources[3].start = nand_resources[3].end = bcm63268_get_irq_number(IRQ_NAND);

	/* Fill in platform data */
	bcm63268_nand_device.dev.platform_data = pdata;

	return platform_device_register(&bcm63268_nand_device);
}

