/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/spi/spi.h>
#include <linux/spi/flash.h>

#include <bcm63268_dev_hsspi.h>

static struct spi_board_info bcm63268_board_spi_info[] = {
	{
		.bus_num	= 0,
		.chip_select	= 0,
		.max_speed_hz	= (50 * 1000 * 1000), /* 50 MHz */
		.modalias	= "m25p80",
	},
};

void __init bcm63268_add_device_m25p80(struct flash_platform_data *pdata, int spi_flash_clock)
{
	bcm63268_board_spi_info[0].platform_data = pdata;
	if (spi_flash_clock != 0)
		bcm63268_board_spi_info[0].max_speed_hz = spi_flash_clock;
	bcm63268_add_device_spi(bcm63268_board_spi_info, ARRAY_SIZE(bcm63268_board_spi_info));
}

