/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/spinlock.h>
#include <linux/platform_device.h>
#include <linux/gpio.h>

#include <bcm63268_cpu.h>
#include <bcm63268_gpio.h>
#include <bcm63268_io.h>
#include <bcm63268_regs.h>

DEFINE_SPINLOCK(bcm63268_led_lock);
static u32 led_mode_low, led_mode_high;

void bcm63268_led_set(unsigned led, int val)
{
	u32 reg;
	u32 mask;
	u32 *v;
	unsigned long flags;

	if (led < 8) {
		reg = LED_MODE_HI_REG;
		mask = 0x3 << (led << 1);
		val = val << (led << 1);
		v = &led_mode_low;
	} else {
		reg = LED_MODE_LO_REG;
		mask = 0x3 << ((led - 8) << 1);
		val = val << ((led - 8) << 1);
		v = &led_mode_high;
	}

	spin_lock_irqsave(&bcm63268_led_lock, flags);
	*v &= ~mask;
	*v |= val;
	bcm_led_writel(*v, reg);
	spin_unlock_irqrestore(&bcm63268_led_lock, flags);
}

void __init bcm63268_led_init(void)
{

	led_mode_high = bcm_led_readl(LED_MODE_HI_REG);

	led_mode_low = bcm_led_readl(LED_MODE_LO_REG);
}

