/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/ethtool.h>
#include <bcm63268_dev_enet.h>

/*
 * Convert Ethernet address string representation to binary data
 */
int
bcm63268_ether_atoe(const char *a, unsigned char *e)
{
	char *c = (char *) a;
    int i = 0;

    memset(e, 0, ETH_ALEN);
    for (;;) {
        e[i++] = (unsigned char)simple_strtoul(c, &c, 16);
        if (!*c++ || i == ETH_ALEN)
            break;
    }
	
    return (i == ETH_ALEN);
}
EXPORT_SYMBOL(bcm63268_ether_atoe);

/*
 * Convert Ethernet address binary data to string representation
 */
char *
bcm63268_ether_etoa(const unsigned char *e, char *a)
{
    char *c = a;
    int i;

    for (i = 0; i < ETH_ALEN; i++) {
        if (i)
            *c++ = ':';
        c += sprintf(c, "%02X", e[i] & 0xff);
    }
    return a;
}
EXPORT_SYMBOL(bcm63268_ether_etoa);

void
bcm63268_mac_increment(unsigned char *e)
{
	int i = 5;

	do {
		e[i]++;
		
		if (e[i])
			break;

		i--;
	} while (i >= 0);
}
EXPORT_SYMBOL(bcm63268_mac_increment);

int
bcm63268_board_get_eth_channel_irq(int channel)
{
	if (channel == 4)
		return bcm63268_get_irq_number(IRQ_GMAC_DMA);
	
	return (bcm63268_get_irq_number(IRQ_ETHSW_RX_DMA) + channel);
}
EXPORT_SYMBOL(bcm63268_board_get_eth_channel_irq);
