/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/bootmem.h>
#include <bcm63268_io.h>
#include <bcm63268_regs.h>

#if CONFIG_BCM_EARLY_PRINTK_UART_PORT == 0
#define BCM_EARLY_UART_READL bcm_uart0_readl
#define BCM_EARLY_UART_WRITEL bcm_uart0_writel
#else
#define BCM_EARLY_UART_READL bcm_uart1_readl
#define BCM_EARLY_UART_WRITEL bcm_uart1_writel
#endif

#ifdef CONFIG_BCM_EARLY_PRINTK
static char printbuf[1024];
#endif

#ifdef CONFIG_BCM_EARLY_PRINTK
static void __init wait_xfered(void)
{
	unsigned int val;

	/* wait for any previous char to be transmitted */
	do {
		val = BCM_EARLY_UART_READL(UART_IR_REG);
		if (val & UART_IR_STAT(UART_IR_TXEMPTY))
			break;
	} while (1);
}
#endif

void __init prom_putchar(char c)
{
#ifdef CONFIG_BCM_EARLY_PRINTK
	unsigned int val;

	if (c == '\n')
		prom_putchar('\r');
	
	wait_xfered();
	BCM_EARLY_UART_WRITEL(c, UART_FIFO_REG);

	if ((BCM_EARLY_UART_READL(UART_IR_REG) & (UART_IR_TXOVER | UART_IR_TXUNDER))) {
		val = BCM_EARLY_UART_READL(UART_CTL_REG);
		val |= UART_CTL_RSTTXFIFO_MASK;
		BCM_EARLY_UART_WRITEL(val, UART_CTL_REG);
	}
	
	wait_xfered();
#endif
}

void prom_printf(const char * fmt, ...)
{
#ifdef CONFIG_BCM_EARLY_PRINTK
	va_list args;
	int l;
	char *p, *buf_end;

	/* Low level, brute force, not SMP safe... */
	va_start(args, fmt);
	l = vsprintf(printbuf, fmt, args); /* hopefully i < sizeof(printbuf) */
	va_end(args);
	buf_end = printbuf + l;

	for (p = printbuf; p < buf_end; p++)
	{
		prom_putchar(*p);
	}
#endif
}

