/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/ptrace.h>
#include <linux/stddef.h>

#include <asm/bugs.h>
#include <asm/cpu.h>
#include <asm/fpu.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <asm/watch.h>

#include <bcm63268_cpu.h>
#include <bcm63268_io.h>
#include <bcm63268_regs.h>
#include <bcm63268_irq.h>

#if defined(CONFIG_BCM_HOSTMIPS_PWRSAVE) || defined(CONFIG_BCM_DDR_SELF_REFRESH_PWRSAVE)
extern void BcmPwrMngtReduceCpuSpeed (void);
extern void BcmPwrMngtResumeFullSpeed (void);
#endif /* CONFIG_BCM_HOSTMIPS_PWRSAVE || CONFIG_BCM_DDR_SELF_REFRESH_PWRSAVE */

/* this version minimizes the chance of an irq sneaking in between checking
need_resched and wait instruction, or eliminates it completely (depending on 
pipeline design). This avoids delayed processing of softirq. (The delayed 
softirq problem can happen when preemption is disabled and softirq runs in 
process context.) */

/* (!) As a safety measure, temporarily disable power saving changes when SMP 
or kernel preemption is enabled. More discussion and tests are needed to verify
that the code sequence is safe. */
void bcm63268_r4k_wait(void)
{
#if defined(CONFIG_BCM_HOSTMIPS_PWRSAVE) || defined(CONFIG_BCM_DDR_SELF_REFRESH_PWRSAVE)
	BcmPwrMngtReduceCpuSpeed();
#endif /* CONFIG_BCM_HOSTMIPS_PWRSAVE || CONFIG_BCM_DDR_SELF_REFRESH_PWRSAVE */

	/* Always try to treat the segment below as an atomic entity and try not
	to insert code or move code around */
	/* Begin fixed safe code pattern for the particular MIPS pipleline*/
	raw_local_irq_disable();

	if (!need_resched() &&  !(read_c0_cause() & read_c0_status())) {
		/* Perform SYNC, enable interrupts, then WAIT */
		__asm__ __volatile__ (
			".set push\n"
			".set noreorder\n"
			".set noat\n"
			"sync\n"
			"mfc0	$1, $12\n"
			"ori $1, $1, 0x1f\n"
			"xori	$1, $1, 0x1e\n"
			"mtc0	$1, $12\n"
			"nop\n"  // Recommended by MIPS team
			"wait\n"
			"nop\n"  // Needed to ensure next instruction is safe
			"nop\n"  // When speed is reduced to 1/8, need one more to get DG interrupt
			"nop\n"  // Safety net...
			".set pop\n");
	}
	else {
#if defined(CONFIG_BCM_HOSTMIPS_PWRSAVE) || defined(CONFIG_BCM_DDR_SELF_REFRESH_PWRSAVE)
		BcmPwrMngtResumeFullSpeed();
#endif /* CONFIG_BCM_HOSTMIPS_PWRSAVE || CONFIG_BCM_DDR_SELF_REFRESH_PWRSAVE */
		raw_local_irq_enable();
	}
}

void bcm63268_r4k_wait_set(int enable)
{
	if(enable) {
		cpu_wait = bcm63268_r4k_wait;
		printk("wait instruction: enabled\n");
    }
	else {
		cpu_wait = NULL;
		printk("wait instruction: disabled\n");
    }
}
EXPORT_SYMBOL(bcm63268_r4k_wait_set);

int bcm63268_r4k_wait_check(void)
{
	if(cpu_wait == bcm63268_r4k_wait)
		return 1;
	else
		return 0;
}
EXPORT_SYMBOL(bcm63268_r4k_wait_check);
