/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#include <linux/init.h>
#include <linux/string.h>
#include <linux/kernel.h>

#include <asm/bootinfo.h>


#undef DEBUG

extern int _prom_argc;
extern int *_prom_argv;

/* A 32-bit PROM pass arguments and environment as 32-bit pointer.
   These macros take care of sign extension.  */
#define prom_argv(index) ((char *)(long)_prom_argv[(index)])

char * __init prom_getcmdline(void)
{
	return &(arcs_cmdline[0]);
}


void  __init prom_init_cmdline(void)
{
	char *cp;
	int actr;
	char cmdline[COMMAND_LINE_SIZE];
#ifdef DEBUG
	int index = 1;
#endif

	actr = 1; /* Always ignore argv[0] */

#ifdef DEBUG
	pr_info("PROM ARGV dump(0x%x):\n", (unsigned int)_prom_argv);
	while (prom_argv(index)) {
		pr_info("argv[%02d] => %s\n", index, prom_argv(index));
		index++;
	}
#endif
	cp = &(cmdline[0]);
	while(actr < _prom_argc) {
		strcpy(cp, prom_argv(actr));
		cp += strlen(prom_argv(actr));
		*cp++ = ' ';
		actr++;
	}
	if (cp != &(cmdline[0])) {
		strcat(cmdline, arcs_cmdline);
		strcpy(arcs_cmdline, cmdline);
	}
}


