/*
<:copyright-arcadyan:DUAL/GPL:standard
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
Unless you and Arcadyan execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Arcadyan software provided
under a license other than the GPL, without Broadcom's express prior
written consent.
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/platform_device.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include <linux/mtd/physmap.h>
#include <linux/spi/spi.h>
#include <linux/spi/flash.h>
#include <linux/gpio.h>
#include <linux/input.h>
#include <linux/proc_fs.h>
#include <asm/mipsprom.h>
#include <asm/addrspace.h>
#include <linux/if_ether.h>
#include <crypto/simple_aes.h>

#include <bcm63268_regs.h>
#include <bcm63268_dev_enet.h>
#include <bcm63268_board.h>
#include <bcm63268_led.h>
#include <bcm63268_dev_gpio_buttons_hotplug.h>
#include <bcm63268_dev_gpio_leds.h>
#include <bcm63268_dev_nand.h>

#define VR9517MAC_GPIO_BUTTON_POLL_INTERVAL	200
#define VR9517MAC_GPIO_BUTTON_DEBOUNCE_INTERVAL 10
#define VR9517MAC_GPIO_LED_BB_BLUE			1
#define VR9517MAC_GPIO_LED_POWER_BLUE		8
#define VR9517MAC_GPIO_LED_POWER_RED		9
#define VR9517MAC_GPIO_LED_POWER_GREEN		11
#define VR9517MAC_GPIO_LED_BB_RED			14
#define VR9517MAC_GPIO_LED_WIFI_RED			15
#define VR9517MAC_GPIO_LED_WIFI_GREEN		16
#define VR9517MAC_GPIO_LED_WIFI_BLUE		17
#define VR9517MAC_GPIO_BUTTON_RESTART		18
#define VR9517MAC_GPIO_LED_BB_GREEN			22
#define VR9517MAC_GPIO_BUTTON_RESET			32
#define VR9517MAC_GPIO_BUTTON_WPS			33
#define VR9517MAC_GPIO_LED_POWER_ORANGE		36
#define VR9517MAC_GPIO_LED_BB_ORANGE 		37
#define VR9517MAC_GPIO_LED_WIFI_ORANGE 		38

/*
 * VR9517MAC33-A-SA
 */
#ifdef CONFIG_BOARD_ARCADYAN_VR9517MAC33_A_SA
static void vr9517mac_special_gpio_set(unsigned gpio, int level)
{	
	switch (gpio) {
		case VR9517MAC_GPIO_LED_POWER_ORANGE:
			if (level) {
				gpio_set_value(VR9517MAC_GPIO_LED_POWER_RED, 0);
				gpio_set_value(VR9517MAC_GPIO_LED_POWER_GREEN, 1);
			}
			else {
				gpio_set_value(VR9517MAC_GPIO_LED_POWER_RED, 1);
				gpio_set_value(VR9517MAC_GPIO_LED_POWER_GREEN, 0);
			}
			break;

		case VR9517MAC_GPIO_LED_BB_ORANGE:
			if (level) {
				gpio_set_value(VR9517MAC_GPIO_LED_BB_RED, 1);
				gpio_set_value(VR9517MAC_GPIO_LED_BB_GREEN, 1);
			}
			else {
				gpio_set_value(VR9517MAC_GPIO_LED_BB_RED, 0);
				gpio_set_value(VR9517MAC_GPIO_LED_BB_GREEN, 0);
			}
			break;

		case VR9517MAC_GPIO_LED_WIFI_ORANGE:
			if (level) {
				gpio_set_value(VR9517MAC_GPIO_LED_WIFI_RED, 1);
				gpio_set_value(VR9517MAC_GPIO_LED_WIFI_GREEN, 1);
			}
			else {
				gpio_set_value(VR9517MAC_GPIO_LED_WIFI_RED, 0);
				gpio_set_value(VR9517MAC_GPIO_LED_WIFI_GREEN, 0);
			}
			break;

		default:
			pr_err("%s: unknown gpio 0x%04x\n", __FUNCTION__, gpio);
			break;
	}
}

static BOARD_ETHERNET_INFO board_vr9517mac_enet = {
	.mac_addr_count	= 7,
	.mac_addr_base = {0x00, 0xAA, 0xBB, 0xCC, 0xDD, 0x00},
	.enet_mac[0] = {
		.ucPhyType = BP_ENET_EXTERNAL_SWITCH,
		.ucPhyAddress = 0,
		.usConfigType = BP_ENET_CONFIG_MMAP,
		.sw = {
			.port_map = 0x48,
			.phy_id = {0x00, 0x00, 0x00, BP_PHY_ID_4, 0x00, 0x00, (RGMII_DIRECT | EXTSW_CONNECTED), 0x00},
			.phy_devName = { NULL, NULL, NULL, "eth4", NULL, NULL, NULL, NULL},
			.gmac_chip_id = 0x63268,
			.enable_gmac = 1,
		},
	},
	.enet_mac[1] = {
		.ucPhyType = BP_ENET_EXTERNAL_SWITCH,
		.ucPhyAddress = 0,
		.usConfigType = BP_ENET_CONFIG_MDIO,
		.sw = {
			.port_map = 0x1e,
			.phy_id = {0x00, 
						(BP_PHY_ID_1 | PHYCFG_VALID | CONNECTED_TO_EXTERN_SW), 
						(BP_PHY_ID_2 | PHYCFG_VALID | CONNECTED_TO_EXTERN_SW), 
						(BP_PHY_ID_3 | PHYCFG_VALID | CONNECTED_TO_EXTERN_SW), 
						(BP_PHY_ID_4 | PHYCFG_VALID | CONNECTED_TO_EXTERN_SW), 0x00, 0x00, 0x00},
			.phy_devName = { NULL, "eth0", "eth1", "eth2", "eth3", NULL, NULL, NULL},
		},
	},
};

static struct board_info board_vr9517mac = {
	.name				= "HomeHub5",
	.expected_cpu_id	= BCM63168_CPU_ID,
	.enet_info 			= &board_vr9517mac_enet,

	.has_xdsl		= 1,
	.has_xdsl_pwr_map	= 0,
	.has_xdsl_mode_map	= 0,
	.has_xdsl_ctrl_pin_used = 1,
	.has_xdsl_ctrl_pin_swapped = 0,
	.has_xdsl_pwr_activelow = 0,
	.has_xdsl_mode_activelow = 0,
	.has_pci		= 1,
	.has_wlan		= 1,
	.woc_subsysid	= 0x0580,
	.xdsl_mac_addr	= {0x00, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE},
	.wlan_mac_addr	= {0x00, 0xAA, 0xBB, 0xCC, 0xDD, 0xFF},

	.leds = {
		{
			.name		= "bb_red",
			.gpio		= VR9517MAC_GPIO_LED_BB_RED,
			.active_low	= 1,
		},
		{
			.name		= "bb_green",
			.gpio		= VR9517MAC_GPIO_LED_BB_GREEN,
			.active_low	= 1,
		},
		{
			.name		= "bb_blue",
			.gpio		= VR9517MAC_GPIO_LED_BB_BLUE,
			.active_low	= 1,
		},
		{
			.name		= "bb_orange",
			.gpio		= VR9517MAC_GPIO_LED_BB_ORANGE,
			.active_low	= 1,
			.gpio_value_set = (void *)vr9517mac_special_gpio_set,
		},
		{
			.name		= "power_red",
			.gpio		= VR9517MAC_GPIO_LED_POWER_RED,
			.active_low	= 0,
		},
		{
			.name		= "power_green",
			.gpio		= VR9517MAC_GPIO_LED_POWER_GREEN,
			.active_low	= 1,
		},
		{
			.name		= "power_blue",
			.gpio		= VR9517MAC_GPIO_LED_POWER_BLUE,
			.active_low	= 1,
		},
		{
			.name		= "power_orange",
			.gpio		= VR9517MAC_GPIO_LED_POWER_ORANGE,
			.active_low = 1,
			.gpio_value_set = (void *)vr9517mac_special_gpio_set,
		},
		{
			.name		= "wifi_red",
			.gpio		= VR9517MAC_GPIO_LED_WIFI_RED,
			.active_low	= 1,
		},
		{
			.name		= "wifi_green",
			.gpio		= VR9517MAC_GPIO_LED_WIFI_GREEN,
			.active_low	= 1,
		},
		{
			.name		= "wifi_blue",
			.gpio		= VR9517MAC_GPIO_LED_WIFI_BLUE,
			.active_low	= 1,
		},
		{
			.name		= "wifi_orange",
			.gpio		= VR9517MAC_GPIO_LED_WIFI_ORANGE,
			.active_low	= 1,
			.gpio_value_set = (void *)vr9517mac_special_gpio_set,
		},
		{	.name		= NULL },
		{	.name		= NULL },
		{	.name		= NULL },
		{	.name		= NULL }
	},
	.buttons = {
		{
			.desc		= "restart",
			.gpio		= VR9517MAC_GPIO_BUTTON_RESTART,
			.active_low	= 1,
			.type		= EV_KEY,
			.code		= KEY_RESTART,
			.debounce_interval = VR9517MAC_GPIO_BUTTON_DEBOUNCE_INTERVAL,
			.event_interval = 2,
		},
		{
			.desc		= "reset",
			.gpio		= VR9517MAC_GPIO_BUTTON_RESET,
			.active_low	= 0,
			.type		= EV_KEY,
			.code		= BTN_0,
			.debounce_interval = VR9517MAC_GPIO_BUTTON_DEBOUNCE_INTERVAL,
			.event_interval = 5,
		},
		{
			.desc		= "wps",
			.gpio		= VR9517MAC_GPIO_BUTTON_WPS,
			.active_low	= 1,
			.type		= EV_KEY,
			.code		= KEY_WPS_BUTTON,
			.debounce_interval = VR9517MAC_GPIO_BUTTON_DEBOUNCE_INTERVAL,
			.event_interval = 5,
		},
		{	.desc = NULL }
	},
};

struct board_info *board = &board_vr9517mac;

#ifdef CONFIG_MTD_PARTITIONS
/* 128MB flash */
static struct mtd_partition vr9517mac_nandflash_partitions[] = {
	{
		.name   = "nvram",
	},
	{
		.name   = "linux",
	},
	{
		.name   = "rootfs",
	},
	{
		.name   = "rootfs_arc",
	},
	{
		.name   = "rootfs_bcm",
	},
	{
		.name   = "rootfs_gpl",
	},
	{
		.name   = "rootfs_driver",
	},
	{
		.name   = "rootfs_www",
	},
	{
		.name   = "rootfs_bt",
	},
	{
		.name   = "pricfg",
	},
	{
		.name   = "sec_linux",
	},
	{
		.name   = "sec_rootfs",
	},
	{
		.name   = "sec_rootfs_arc",
	},
	{
		.name   = "sec_rootfs_bcm",
	},
	{
		.name   = "sec_rootfs_gpl",
	},
	{
		.name   = "sec_rootfs_driver",
	},
	{
		.name   = "sec_rootfs_www",
	},
	{
		.name   = "sec_rootfs_bt",
	},
	{
		.name   = "seccfg",
	},
	{
		.name   = "ubifs",
	},
	{
		.name   = "bootldr",
	},
	{
		.name   = "manuf",
	},
	{
		.name   = "oops",
	}
};
#endif /* CONFIG_MTD_PARTITIONS */

#ifdef CONFIG_MTD_NAND
static struct bcm63268_nand_platform_data vr9517mac_nandflash_data = {
		.width = 1,
		.hw_ecc = 1,
		.flash_bbt = 0,
#ifdef CONFIG_MTD_PARTITIONS
        .parts = vr9517mac_nandflash_partitions,
        .nr_parts = ARRAY_SIZE(vr9517mac_nandflash_partitions),
#endif /* CONFIG_MTD_PARTITIONS */
};
#endif

static int board_vr9517mac_proc_read_hw_version(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	return (sprintf(buffer, "%s\n", board_vr9517mac.hwver) + 1);
}

static int board_vr9517mac_proc_read_fw_version(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	return (sprintf(buffer, "%s", board_vr9517mac.fwver) + 1);
}

static int board_vr9517mac_proc_read_fw_date(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	return (sprintf(buffer, "%s", board_vr9517mac.fwdate) + 1);
}

static int board_vr9517mac_proc_read_bootcode_version(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	return (sprintf(buffer, "%s", board_vr9517mac.bootver) + 1);
}

static int board_vr9517mac_proc_read_bootcode_date(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	return (sprintf(buffer, "%s", board_vr9517mac.bootdate) + 1);
}

static int board_vr9517mac_proc_read_serial_num(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	return (sprintf(buffer, "%s\n", board_vr9517mac.serial_num) + 1);
}

static int board_vr9517mac_proc_read_mac_base(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	char mac_addr_str[ETH_ZLEN];
	bcm63268_ether_etoa(board_vr9517mac_enet.mac_addr_base, mac_addr_str);
	return (sprintf(buffer, "%s\n", mac_addr_str) + 1);
}

static int board_vr9517mac_proc_read_lan_mac(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	char mac_addr_str[ETH_ZLEN];
	bcm63268_ether_etoa(board_vr9517mac_enet.enet_mac[0].sw.port_mac_addr[0], mac_addr_str);
	return (sprintf(buffer, "%s\n", mac_addr_str) + 1);
}

static int board_vr9517mac_proc_read_ethwan_mac(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	char mac_addr_str[ETH_ZLEN];
	bcm63268_ether_etoa(board_vr9517mac_enet.enet_mac[0].sw.port_mac_addr[4], mac_addr_str);
	return (sprintf(buffer, "%s\n", mac_addr_str) + 1);
}

static int board_vr9517mac_proc_read_dslwan_mac(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	char mac_addr_str[ETH_ZLEN];
	bcm63268_ether_etoa(board_vr9517mac.xdsl_mac_addr, mac_addr_str);
	return (sprintf(buffer, "%s\n", mac_addr_str) + 1);
}

static int board_vr9517mac_proc_read_wlan_mac(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	char mac_addr_str[ETH_ZLEN];
	bcm63268_ether_etoa(board_vr9517mac.wlan_mac_addr, mac_addr_str);
	return (sprintf(buffer, "%s\n", mac_addr_str) + 1);
}

static int board_vr9517mac_proc_read_activeimg(
		char *buffer,
		char **start, 
		off_t off, 
		int count, 
		int *eof, 
		void *data)
{
	return (sprintf(buffer, "%s\n", board_vr9517mac.activeimg) + 1);
}

static int board_vr9517mac_add_proc_files(void)
{
	char tmp[32];
	char *cp = NULL;
	struct proc_dir_entry *board_info;

	cp = prom_getenv("hwver");
	if (cp)
		strcpy(board_vr9517mac.hwver, cp);
	
	cp = prom_getenv("fwver");
	if (cp)
		strcpy(board_vr9517mac.fwver, cp);

	cp = prom_getenv("boot_imgnum");
	if (cp)
		strcpy(board_vr9517mac.activeimg, cp);

	cp = prom_getenv("fwdate");
	if (cp)
		strcpy(board_vr9517mac.fwdate, cp);

	cp = prom_getenv("bootver");
	if (cp)
		strcpy(board_vr9517mac.bootver, cp);

	cp = prom_getenv("bootdate");
	if (cp)
		strcpy(board_vr9517mac.bootdate, cp);

	cp = prom_getenv("serial_no");
	if (cp)
		strcpy(board_vr9517mac.serial_num, cp);

	strcpy(tmp, "board_info");
	board_info = proc_mkdir (tmp, NULL);

	if (board_info == NULL)
		return -1;

	strcpy(tmp, "board_info/hw_ver");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_hw_version, NULL);

	strcpy(tmp, "board_info/active_img");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_activeimg, NULL);

	strcpy(tmp, "board_info/fw_ver");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_fw_version, NULL);

	strcpy(tmp, "board_info/fw_date");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_fw_date, NULL);

	strcpy(tmp, "board_info/bootcode_ver");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_bootcode_version, NULL);

	strcpy(tmp, "board_info/bootcode_date");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_bootcode_date, NULL);

	strcpy(tmp, "board_info/serial_num");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_serial_num, NULL);

	strcpy(tmp, "board_info/mac_base");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_mac_base, NULL);

	strcpy(tmp, "board_info/lan_mac");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_lan_mac, NULL);

	strcpy(tmp, "board_info/ethwan_mac");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_ethwan_mac, NULL);

	strcpy(tmp, "board_info/dslwan_mac");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_dslwan_mac, NULL);

	strcpy(tmp, "board_info/wlan_mac");
	create_proc_read_entry(tmp, 0, NULL, board_vr9517mac_proc_read_wlan_mac, NULL);
	
	return 0;
}

static void __init vr9517mac_enet_init(void)
{
	char *mac_base = NULL;
	char *mac_count = NULL;
	unsigned char mac_addr[ETH_ALEN];

	if ((mac_count = prom_getenv("mac_no")) != NULL) {
		board_vr9517mac_enet.mac_addr_count = (u32)simple_strtoul(mac_count, NULL, 10);
	}

	if ((mac_base = prom_getenv("mac_base")) != NULL) {
		bcm63268_ether_atoe((const char *)mac_base, board_vr9517mac_enet.mac_addr_base);
		memcpy(mac_addr, board_vr9517mac_enet.mac_addr_base, ETH_ALEN);
		memcpy(board_vr9517mac_enet.enet_mac[0].sw.port_mac_addr[0], mac_addr, ETH_ALEN);
		memcpy(board_vr9517mac_enet.enet_mac[0].sw.port_mac_addr[1], mac_addr, ETH_ALEN);
		memcpy(board_vr9517mac_enet.enet_mac[0].sw.port_mac_addr[2], mac_addr, ETH_ALEN);
		memcpy(board_vr9517mac_enet.enet_mac[0].sw.port_mac_addr[3], mac_addr, ETH_ALEN);
		bcm63268_mac_increment(mac_addr);
		memcpy(board_vr9517mac.wlan_mac_addr, mac_addr, ETH_ALEN);
		bcm63268_mac_increment(mac_addr);
		bcm63268_mac_increment(mac_addr);
		bcm63268_mac_increment(mac_addr);
		memcpy(board_vr9517mac_enet.enet_mac[0].sw.port_mac_addr[4], mac_addr, ETH_ALEN);
		bcm63268_mac_increment(mac_addr);
		memcpy(board_vr9517mac.xdsl_mac_addr, mac_addr, ETH_ALEN);
	}
}

static int __init vr9517mac_init(void)
{
#if defined(CONFIG_INPUT_GPIO_BUTTONS_HOTPLUG_V2) || defined(CONFIG_INPUT_GPIO_BUTTONS_HOTPLUG_V2_MODULE)
	int button_cnt;
#endif
#if defined(CONFIG_LEDS_GPIO) || defined(CONFIG_LEDS_GPIO_MODULE)
	int led_cnt;
#endif

	vr9517mac_enet_init();
	
#ifdef CONFIG_MTD_PARTITIONS
	vr9517mac_nandflash_partitions[0].offset = CPHYSADDR(PROJ_BOOTLDR_ADDR) + PROJ_BOOTLDR_SIZE + PROJ_MANUF_DATA_SIZE;
	vr9517mac_nandflash_partitions[0].size = PROJ_NVRAM_DATA_SIZE;

	vr9517mac_nandflash_partitions[1].offset = vr9517mac_nandflash_partitions[0].offset + PROJ_NVRAM_DATA_SIZE;
	vr9517mac_nandflash_partitions[1].size = PROJ_LINUX_SIZE;

	vr9517mac_nandflash_partitions[2].offset = vr9517mac_nandflash_partitions[1].offset + PROJ_LINUX_SIZE;
	vr9517mac_nandflash_partitions[2].size = PROJ_ROOTFS_SIZE;

	vr9517mac_nandflash_partitions[3].offset = vr9517mac_nandflash_partitions[2].offset + PROJ_ROOTFS_SIZE;
	vr9517mac_nandflash_partitions[3].size = PROJ_ROOTFS_ARC_SIZE;

	vr9517mac_nandflash_partitions[4].offset = vr9517mac_nandflash_partitions[3].offset + PROJ_ROOTFS_ARC_SIZE;
	vr9517mac_nandflash_partitions[4].size = PROJ_ROOTFS_BCM_SIZE;

	vr9517mac_nandflash_partitions[5].offset = vr9517mac_nandflash_partitions[4].offset + PROJ_ROOTFS_BCM_SIZE;
	vr9517mac_nandflash_partitions[5].size = PROJ_ROOTFS_GPL_SIZE;

	vr9517mac_nandflash_partitions[6].offset = vr9517mac_nandflash_partitions[5].offset + PROJ_ROOTFS_GPL_SIZE;
	vr9517mac_nandflash_partitions[6].size = PROJ_ROOTFS_DRIVER_SIZE;

	vr9517mac_nandflash_partitions[7].offset = vr9517mac_nandflash_partitions[6].offset + PROJ_ROOTFS_DRIVER_SIZE;
	vr9517mac_nandflash_partitions[7].size = PROJ_ROOTFS_WWW_SIZE;

	vr9517mac_nandflash_partitions[8].offset = vr9517mac_nandflash_partitions[7].offset + PROJ_ROOTFS_WWW_SIZE;
	vr9517mac_nandflash_partitions[8].size = PROJ_ROOTFS_BT_SIZE;

	vr9517mac_nandflash_partitions[9].offset = vr9517mac_nandflash_partitions[8].offset + PROJ_ROOTFS_BT_SIZE;
	vr9517mac_nandflash_partitions[9].size = PROJ_PRICFG_SIZE;

	vr9517mac_nandflash_partitions[10].offset = vr9517mac_nandflash_partitions[9].offset + PROJ_PRICFG_SIZE;
	vr9517mac_nandflash_partitions[10].size = PROJ_LINUX_SIZE;

	vr9517mac_nandflash_partitions[11].offset = vr9517mac_nandflash_partitions[10].offset + PROJ_LINUX_SIZE;
	vr9517mac_nandflash_partitions[11].size = PROJ_ROOTFS_SIZE;

	vr9517mac_nandflash_partitions[12].offset = vr9517mac_nandflash_partitions[11].offset + PROJ_ROOTFS_SIZE;
	vr9517mac_nandflash_partitions[12].size = PROJ_ROOTFS_ARC_SIZE;

	vr9517mac_nandflash_partitions[13].offset = vr9517mac_nandflash_partitions[12].offset + PROJ_ROOTFS_ARC_SIZE;
	vr9517mac_nandflash_partitions[13].size = PROJ_ROOTFS_BCM_SIZE;

	vr9517mac_nandflash_partitions[14].offset = vr9517mac_nandflash_partitions[13].offset + PROJ_ROOTFS_BCM_SIZE;
	vr9517mac_nandflash_partitions[14].size = PROJ_ROOTFS_GPL_SIZE;

	vr9517mac_nandflash_partitions[15].offset = vr9517mac_nandflash_partitions[14].offset + PROJ_ROOTFS_GPL_SIZE;
	vr9517mac_nandflash_partitions[15].size = PROJ_ROOTFS_DRIVER_SIZE;

	vr9517mac_nandflash_partitions[16].offset = vr9517mac_nandflash_partitions[15].offset + PROJ_ROOTFS_DRIVER_SIZE;
	vr9517mac_nandflash_partitions[16].size = PROJ_ROOTFS_WWW_SIZE;

	vr9517mac_nandflash_partitions[17].offset = vr9517mac_nandflash_partitions[16].offset + PROJ_ROOTFS_WWW_SIZE;
	vr9517mac_nandflash_partitions[17].size = PROJ_ROOTFS_BT_SIZE;

	vr9517mac_nandflash_partitions[18].offset = vr9517mac_nandflash_partitions[17].offset + PROJ_ROOTFS_BT_SIZE;
	vr9517mac_nandflash_partitions[18].size = PROJ_PRICFG_SIZE;

	vr9517mac_nandflash_partitions[19].offset = vr9517mac_nandflash_partitions[18].offset + PROJ_PRICFG_SIZE;
	vr9517mac_nandflash_partitions[19].size = PROJ_UBIFS_SIZE;

	vr9517mac_nandflash_partitions[20].offset = CPHYSADDR(PROJ_BOOTLDR_ADDR);
	vr9517mac_nandflash_partitions[20].size = PROJ_BOOTLDR_SIZE;

	vr9517mac_nandflash_partitions[21].offset = vr9517mac_nandflash_partitions[20].offset + PROJ_BOOTLDR_SIZE;
	vr9517mac_nandflash_partitions[21].size = PROJ_MANUF_DATA_SIZE;

	vr9517mac_nandflash_partitions[22].offset = vr9517mac_nandflash_partitions[19].offset + PROJ_UBIFS_SIZE;
	vr9517mac_nandflash_partitions[22].size = PROJ_OOPS_DATA_SIZE;
#endif /* CONFIG_MTD_PARTITIONS */

#ifdef CONFIG_MTD_NAND
	bcm63268_add_device_nand(&vr9517mac_nandflash_data, sizeof(vr9517mac_nandflash_data));
#endif

#if defined(CONFIG_INPUT_GPIO_BUTTONS_HOTPLUG_V2) || defined(CONFIG_INPUT_GPIO_BUTTONS_HOTPLUG_V2_MODULE)
	button_cnt = 0;
	while ((button_cnt < ARRAY_SIZE(board_vr9517mac.buttons)) 
		&& board_vr9517mac.buttons[button_cnt].desc) {
		button_cnt++;
	}
	
	bcm63268_add_device_gpio_buttons_hotplug(-1, VR9517MAC_GPIO_BUTTON_POLL_INTERVAL, 
						button_cnt, board_vr9517mac.buttons);
#endif /* CONFIG_INPUT_GPIO_BUTTONS */

#if defined(CONFIG_LEDS_GPIO) || defined(CONFIG_LEDS_GPIO_MODULE)
	led_cnt = 0;
	while ((led_cnt < ARRAY_SIZE(board_vr9517mac.leds)) 
		&& board_vr9517mac.leds[led_cnt].name) {
		led_cnt++;
	}

	bcm63268_add_device_gpio_leds(-1, led_cnt, board_vr9517mac.leds);
#endif /* CONFIG_LEDS_GPIO */

	/* Provide board_info, proc file system */
	board_vr9517mac_add_proc_files();

	return 0;
}

arch_initcall(vr9517mac_init);
#endif /* CONFIG_BOARD_ARCADYAN_VR9517MAC */

