/*
<:copyright-gpl 
 Copyright 2012 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/platform_device.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include <linux/mtd/physmap.h>
#include <linux/ssb/ssb.h>
#include <linux/if_ether.h>
#include <asm/addrspace.h>
#include <bcm63268_board.h>
#include <bcm63268_cpu.h>
#include <bcm63268_regs.h>
#include <bcm63268_io.h>
#include <bcm63268_dev_hsspi.h>

#define PFX	"board_bcm963268: "

extern struct board_info *board;
static char bcm63268_board_sys_type[128];

/*
 * early init callback, read nvram data from flash and checksum it
 */
void __init bcm63268_board_prom_init(void)
{
	/* NIY */
}

/*
 * second stage init callback, good time to panic if we couldn't
 * identify on which board we're running since early printk is working
 */
void __init bcm63268_board_setup(void)
{
	if (!board->name[0])
		panic("unable to detect bcm963268 board");
	printk(KERN_INFO PFX "board name: %s\n", board->name);

	/* make sure we're running on expected cpu */
	if (bcm63268_get_cpu_id() != board->expected_cpu_id)
		panic("unexpected CPU for bcm963268 board");

	snprintf(bcm63268_board_sys_type, sizeof(bcm63268_board_sys_type), "bcm63268/%s (0x%04x/0x%04X)",
		 bcm63268_board_get_name(),
		 bcm63268_get_cpu_id(), bcm63268_get_cpu_rev());
}

/*
 * return board name for /proc/cpuinfo
 */
const char *bcm63268_board_get_name(void)
{
	return board->name;
}

/*
 * return board name for /proc/cpuinfo
 */
const char *bcm63268_board_get_sys_type(void)
{
	return bcm63268_board_sys_type;
}

/*
 * return board's ethernet configurations
 */
BOARD_ETHERNET_INFO *bcm63268_board_get_enet_info(void)
{
	return board->enet_info;
}
EXPORT_SYMBOL(bcm63268_board_get_enet_info);

int bcm63268_board_get_enet_port_connected_to_ext_switch(void)
{
	int i;
	ETHERNET_SW_INFO *enet_sw = &board->enet_info->enet_mac[0].sw;

	for (i = 0; i < BP_MAX_SWITCH_PORTS; i++) {
		if ((enet_sw->port_map & (1 << i)) &&
			(enet_sw->phy_id[i] & EXTSW_CONNECTED))
			return i;
	}

	return -1;
}
EXPORT_SYMBOL(bcm63268_board_get_enet_port_connected_to_ext_switch);

/*
 * board's WLAN MAC address
 */
void bcm63268_board_get_wlan_mac(u8 *wlan_mac)
{
	if (board->has_wlan)
		memcpy(wlan_mac, board->wlan_mac_addr, ETH_ALEN);
}
EXPORT_SYMBOL(bcm63268_board_get_wlan_mac);

/*
 * board's XDSL PHY enabled
 */
int bcm63268_board_get_xdsl_phy_enabled(void)
{
	return board->has_xdsl;
}
EXPORT_SYMBOL(bcm63268_board_get_xdsl_phy_enabled);

/*
 * board's XDSL MAC address
 */
void bcm63268_board_get_xdsl_mac(u8 *xdsl_mac)
{
	if (board->has_xdsl)
		memcpy(xdsl_mac, board->xdsl_mac_addr, ETH_ALEN);
}
EXPORT_SYMBOL(bcm63268_board_get_xdsl_mac);

/*
 * board's XDSL ctrl pin mapped to GPIO
 */
int bcm63268_board_get_xdsl_pwr_map(void)
{
	return board->has_xdsl_pwr_map;
}
EXPORT_SYMBOL(bcm63268_board_get_xdsl_pwr_map);

/*
 * board's XDSL ctrl pin mapped to GPIO
 */
int bcm63268_board_get_xdsl_mode_map(void)
{
	return board->has_xdsl_mode_map;
}
EXPORT_SYMBOL(bcm63268_board_get_xdsl_mode_map);

/*
 * board's XDSL ctrl pin used
 */
int bcm63268_board_get_xdsl_ctrlpin_used(void)
{
	return board->has_xdsl_ctrl_pin_used;
}
EXPORT_SYMBOL(bcm63268_board_get_xdsl_ctrlpin_used);

/*
 * board's XDSL ctrl pin swapped
 */
int bcm63268_board_get_xdsl_ctrlpin_swapped(void)
{
	return board->has_xdsl_ctrl_pin_swapped;
}
EXPORT_SYMBOL(bcm63268_board_get_xdsl_ctrlpin_swapped);

/*
 * board's XDSL ctrl pin used
 */
int bcm63268_board_get_xdsl_ctrlpin_pwr_activelow(void)
{
	return board->has_xdsl_pwr_activelow;
}
EXPORT_SYMBOL(bcm63268_board_get_xdsl_ctrlpin_pwr_activelow);

/*
 * board's XDSL ctrl pin used
 */
int bcm63268_board_get_xdsl_ctrlpin_mode_activelow(void)
{
	return board->has_xdsl_mode_activelow;
}
EXPORT_SYMBOL(bcm63268_board_get_xdsl_ctrlpin_mode_activelow);

/*
 * board's XDSL MAC address
 */
u32 bcm63268_board_get_woc_subsysid(void)
{
	return board->woc_subsysid;
}
EXPORT_SYMBOL(bcm63268_board_get_woc_subsysid);

u32 bcm63268_board_get_regset_addr(int set)
{
	return bcm63268_regs_base[set];
}
EXPORT_SYMBOL(bcm63268_board_get_regset_addr);

