/*
<:copyright-gpl 
 Copyright 2013 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <errno.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <arpa/inet.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <linux/netfilter.h>
#include "libnetfilter_queue/libnetfilter_queue.h"
#include "nfqueue_logger.h"

int nfqueue_logger_debug = 0;

int nfqueue_logger_query_physindev(struct nfq_data *nfq_pkt, char *ifname)
{
	struct nlif_handle *nlif_h;
	int rv;

	nlif_h = nlif_open();
	if (!nlif_h)
		return -1;

	nlif_query(nlif_h);

	rv = nfq_get_physindev_name(nlif_h, nfq_pkt, ifname);
	nlif_close(nlif_h);

	return rv > 0 ? 0 : -1;
}

int nfqueue_logger_dump_payload(char *pkt)
{
	char buf[128];
	struct iphdr *iph = (struct iphdr *)pkt;
	int ip_proto = pkt[9];
	int ip_totlen;

	ip_totlen = ntohs(iph->tot_len);
	NFQUEUE_LOGGER_DEBUG("packet len %d(%x)", ip_totlen, iph->tot_len);
	inet_ntop(AF_INET, &iph->saddr, buf, sizeof(buf));
	NFQUEUE_LOGGER_DEBUG("from %s", buf);
	inet_ntop(AF_INET, &iph->daddr, buf, sizeof(buf));
	NFQUEUE_LOGGER_DEBUG("to %s", buf);

	switch (ip_proto) {
		case IPPROTO_TCP:
			{
				struct tcphdr *tcph = (struct tcphdr *)(pkt + sizeof(struct iphdr));
				NFQUEUE_LOGGER_DEBUG("TCP source %d, dest %d", tcph->source, tcph->dest);
			}
			break;

		case IPPROTO_UDP:
			{
				struct udphdr *udph = (struct udphdr *)(pkt + sizeof(struct iphdr));
				NFQUEUE_LOGGER_DEBUG("UDP source %d, dest %d", udph->source, udph->dest);
			}
			break;
	}

	return 0;
}

