/*
<:copyright-gpl 
 Copyright 2013 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#ifndef _NFQUEUE_LOGGER_H_
#define _NFQUEUE_LOGGER_H_

extern int nfqueue_logger_debug;

#define NFQUEUE_LOGGER_VERSION				"1.0"
#define NFQUEUE_LOGGER_DEBUG(fmt, args...)	if (nfqueue_logger_debug) printf("NFQUEUE-LOGGER: " fmt "\n", ##args)
#define NFQUEUE_LOGGER_LOG_SIZE_MAX			1500
#define NFQUEUE_LOGGER_LOG_FOLDER			"/var/nfqueue-logger"
#define NFQUEUE_LOGGER_LOG_FILE				"log"

enum {
	NFQUEUE_LOGGER_MODE_LOGTOFILE = 0,
	NFQUEUE_LOGGER_MODE_LOGTOUDP,
	NFQUEUE_LOGGER_MODE_HTTP_REDIRECT,

	/* please add before this line */
	NFQUEUE_LOGGER_MODE_MAX
};

typedef int (*nfqueue_logger_cb_t)(struct nfq_q_handle *qh, struct nfgenmsg *nfmsg, struct nfq_data *nfq_pkt, void *data);

typedef struct nfqueue_logger_cb_data_s {
	int nfqueue_num;
	int logger_mode;
	int interested_len;
	int verdict;
	char *data;
} nfqueue_logger_cb_data_t;

int nfqueue_logger_query_physindev(struct nfq_data *nfq_pkt, char *ifname);
int nfqueue_logger_dump_payload(char *pkt);

extern int nfqueue_logger_log_packet(struct nfq_q_handle *qh, struct nfgenmsg *nfmsg, struct nfq_data *nfq_pkt, void *data);
extern int nfqueue_logger_http_redirect(struct nfq_q_handle *qh, struct nfgenmsg *nfmsg, struct nfq_data *nfq_pkt, void *data);

#endif /* !_NFQUEUE_LOGGER_H_ */
