/*
<:copyright-gpl 
 Copyright 2013 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <errno.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <linux/netfilter.h>
#include "libnetfilter_queue/libnetfilter_queue.h"
#include "nfqueue_logger.h"

static char *reply_buf = NULL;
static int reply_sd = -1;
static unsigned short iph_id = 1234;

struct pseudo_tcphdr {
	unsigned int ip_src;
	unsigned int ip_dst;
	unsigned char zero;
	unsigned char protocol;
	unsigned short tcp_len;
};

struct tcp_option_mss {
	unsigned char kind;               /* 2 */
	unsigned char len;                /* 4 */
	unsigned short mss;
} __attribute__((packed));

static unsigned short nfqueue_logger_http_redirect_cksum(unsigned short *data, int len)
{
	unsigned short odd;
	unsigned int cksum = 0;

	cksum = 0;
	while (len > 1) {
		cksum += *data++;
		len -= 2;
	}

	if (len) {
		odd = 0;
		*((unsigned char *)&odd) = *(unsigned char *)data;
		cksum += odd;
	}

	cksum = (cksum >> 16) + (cksum & 0xffff);
	cksum = cksum + (cksum >> 16);
	
	return (unsigned short)~cksum;
}

static unsigned short nfqueue_logger_http_redirect_tcp_cksum(struct iphdr *iph, unsigned short *data, int len)
{
	unsigned short odd;
	unsigned int cksum = 0;
	struct pseudo_tcphdr pseudo_hdr;
	int pseudo_hdr_len = sizeof(struct pseudo_tcphdr);
	unsigned short *sp = (unsigned short *)&pseudo_hdr;

	pseudo_hdr.ip_dst = iph->saddr;
	pseudo_hdr.ip_src = iph->daddr,
	pseudo_hdr.zero = 0;
	pseudo_hdr.protocol = iph->protocol;
	pseudo_hdr.tcp_len = htons(len);

	cksum = 0;
	while (pseudo_hdr_len) {
		cksum += *sp++;
		pseudo_hdr_len -= 2;
	}
	while (len > 1) {
		cksum += *data++;
		len -= 2;
	}

	if (len) {
		odd = 0;
		*((unsigned char *)&odd) = *(unsigned char *)data;
		cksum += odd;
	}

	cksum = (cksum >> 16) + (cksum & 0xffff);
	cksum = cksum + (cksum >> 16);
	
	return (unsigned short)~cksum;
}

static int nfqueue_logger_http_redirect_send_response(unsigned char *pkt, char *url)
{
	struct iphdr *iph, *reply_iph;
	struct tcphdr *tcph, *reply_tcph;
	struct tcp_option_mss *tcp_mss;
	struct sockaddr_in sa;
	int reply_len;
	char *cp;

	iph = (struct iphdr *)pkt;
	tcph = (struct tcphdr *) (pkt + (iph->ihl << 2));

	reply_iph = (struct iphdr *)reply_buf;
	reply_tcph = (struct tcphdr *)(reply_buf + sizeof(struct iphdr));

	if (!tcph->syn) {
		cp = (char *)(pkt + (iph->ihl << 2) + (ntohs(tcph->doff) << 2));

		if (*cp != 'G')
			return 0;

		cp = reply_buf + sizeof(struct iphdr) + sizeof(struct tcphdr);
		reply_len = sprintf(cp, 
						"HTTP/1.1 303 See Other\n"
						"Location: %s\n"
						"Connection: close\n"
						"Content-Type: text/html\n"
						"Content-Length: %d\n\n"
						"<html>\n"
						"<head>\n"
						"<title>Redirect</title>\n"
						"</head>\n"
						"<body>\n"
						"<h1>Redirect</h1>\n"
						"<p>Redirect to <a href=\"%s\">%s</a>.</p>\n"
						"</body>\n"
						"</html>\n",
						url,
						123 + (strlen(url) * 2),
						url,
						url);
		reply_tcph->doff = htons((unsigned short)(sizeof(struct tcphdr) >> 2));
	}else {
		reply_len = 8;
		/* TCP options - MSS, NOP, NOP, SACK */
		tcp_mss = (struct tcp_option_mss *)reply_buf + sizeof(struct iphdr) + sizeof(struct tcphdr);
		tcp_mss->kind = 2;
		tcp_mss->len = 4;
		tcp_mss->mss = htons(1460);
		cp = (char *)(tcp_mss + 1);
		*cp++ = 0x01;
		*cp++ = 0x01;
		*((unsigned short *)cp) = htons(0x0402);
		reply_tcph->doff = htons((unsigned short)((sizeof(struct tcphdr) + 8) >> 2));
	}

	/* IP headers */
	/* IP version 4 */
	reply_iph->version = 4;
	/* No options, so 20 bytes. */
	reply_iph->ihl = 5;
	/* Normal precedence */
	reply_iph->tos = 0;
	reply_iph->tot_len = htons(sizeof(struct iphdr) + sizeof(struct tcphdr) + reply_len);
	reply_iph->id = htons(iph_id++);
	if (iph_id > 65000)
		iph_id = 1234;
	/* don't fragment */
	reply_iph->frag_off = 0x4000;
	reply_iph->ttl = 64;
	/* TCP */
	reply_iph->protocol = 6;
	/* set to 0 first because we calculate it by ourselves */
	reply_iph->check = 0;
	reply_iph->saddr = iph->daddr;
	reply_iph->daddr = iph->saddr;
	reply_iph->check = nfqueue_logger_http_redirect_cksum((unsigned short *)reply_buf, sizeof(struct iphdr));

	/* TCP headers */
	reply_tcph->source = tcph->dest;
	reply_tcph->dest = tcph->source;
	reply_tcph->seq = tcph->syn ? htonl(0x55555555) : tcph->ack_seq;
	reply_tcph->ack_seq = htonl(ntohl(tcph->seq) + (tcph->syn ? 1 : (ntohs(iph->tot_len) - (iph->ihl << 2) - (ntohs(tcph->doff) << 2))));
	reply_tcph->res1 = 0;
	reply_tcph->res2 = 0;
	reply_tcph->urg = 0;
	reply_tcph->ack = 1;
	reply_tcph->psh = tcph->syn ? 0 : 1;
	reply_tcph->rst = 0;
	reply_tcph->syn = tcph->syn ? 1 : 0;
	reply_tcph->fin = 0;
	reply_tcph->window = htons(16 * 1024);
	reply_tcph->check = 0;
	reply_tcph->urg_ptr = 0;
	reply_tcph->check = nfqueue_logger_http_redirect_tcp_cksum(iph, (unsigned short *)reply_tcph, sizeof(struct tcphdr) + reply_len);

	/* send to source of this packet */
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = iph->saddr;
	sa.sin_port = tcph->source;
	if(sendto(reply_sd, reply_buf, sizeof(struct iphdr) + sizeof(struct tcphdr) + reply_len, 0, (struct sockaddr *) &sa, sizeof(sa)) < 0) {
		fprintf(stderr, "%s: error in sending HTTP redirect message", __FUNCTION__);
		return 1;
	}

	return 0;
}

int nfqueue_logger_http_redirect(struct nfq_q_handle *qh, struct nfgenmsg *nfmsg, struct nfq_data *nfq_pkt, void *data)
{
	nfqueue_logger_cb_data_t *nfqueue_logger = (nfqueue_logger_cb_data_t *)data;
	int rv = 0;
	struct nfqnl_msg_packet_hdr *pktHdr;
	int id = -1, pktLen;
	unsigned char *payload;
	struct iphdr *iph;
	struct tcphdr *tcph;

	pktHdr = nfq_get_msg_packet_hdr(nfq_pkt);
	if (!pktHdr) {
		fprintf(stderr, "%s: unable to get packet header for queue %d\n", __FUNCTION__, nfqueue_logger->nfqueue_num);
		goto redirect_exit;
	}
	
	id = ntohl(pktHdr->packet_id);

	pktLen = nfq_get_payload(nfq_pkt, &payload);
	if (pktLen < 0) {
		fprintf(stderr, "%s: unable to get packet payload for queue %d\n", __FUNCTION__, nfqueue_logger->nfqueue_num);
		/* ops, we can not handle this packet, still forward it anyway */
		goto redirect_exit;
	}

	NFQUEUE_LOGGER_DEBUG("protocol = 0x%04x, hook = %u, id = %u\n", ntohs(pktHdr->hw_protocol), pktHdr->hook, id);
	if (nfqueue_logger_debug)
		nfqueue_logger_dump_payload((char *)payload);

	/* drop not correct TCP packet */
	if (pktLen < sizeof(struct iphdr)) {
		goto redirect_exit;
	}
	iph = (struct iphdr *) payload;
	if (pktLen < (iph->ihl << 2)) {
		goto redirect_exit;
	}
	tcph = (struct tcphdr *) (payload + (iph->ihl << 2));
	if (pktLen < ((iph->ihl << 2) + (ntohs(tcph->doff) << 2))) {
		goto redirect_exit;
	}
	/*
		reply TCP syn if it is a TCP syn to finish TCP handshake since we drop
		all packets to peer,
		is it possible a HTTP GET with syn??? TBD
	*/
	if (!reply_buf) {
		int one = 1;
		reply_buf = (char *)malloc(nfqueue_logger->interested_len * sizeof(char));
		reply_sd = socket(PF_INET, SOCK_RAW, IPPROTO_TCP);
		if (reply_sd < 0) {
			fprintf(stderr, "%s: error in socket()\n", __FUNCTION__);
			free(reply_buf);
			reply_buf = NULL;
			goto redirect_exit;
		}

		if(setsockopt(reply_sd, IPPROTO_IP, IP_HDRINCL, &one, sizeof(one)) < 0) {
			fprintf(stderr, "%s: error in setsockopt()\n", __FUNCTION__);
			close(reply_sd);
			reply_sd = -1;
			free(reply_buf);
			reply_buf = NULL;
			goto redirect_exit;
		}
	}

	memset(reply_buf, 0, nfqueue_logger->interested_len);

	rv = nfqueue_logger_http_redirect_send_response(payload, nfqueue_logger->data);

redirect_exit:
	if (id >= 0)
		rv = nfq_set_verdict(qh, id, nfqueue_logger->verdict, 0, NULL);

	return rv;
}
