/* Shared library add-on to iptables to add IPSEC target support. */
#include <xtables.h>
#include <linux/netfilter/x_tables.h>

/* Function which prints out usage message. */
static void IPSEC_help(void)
{
	printf("IPSEC target v%s takes no options\n", XTABLES_VERSION);
}

/* Function which parses command options; returns true if it
   ate an option */
static int
IPSEC_parse(int c, char **argv, int invert, unsigned int *flags,
              const void *entry, struct xt_entry_target **target)
{
	return 0;
}

static struct xtables_target xt_ipsec_target = {
	.family		= NFPROTO_IPV4,
	.name		= "IPSEC",
	.version	= XTABLES_VERSION,
	.size		= XT_ALIGN(0),
	.userspacesize	= XT_ALIGN(0),
	.help		= IPSEC_help,
	.parse		= IPSEC_parse,
};

void _init(void)
{
	xtables_register_target(&xt_ipsec_target);
}
