/*
 * Copyright (C) 2005 by David Seikel won_fang@yahoo.com.au
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA
 *
 */

#ifndef _INIT_D_H
#define _INIT_D_H


/*
 * init script defines
 */

#define INIT_D_COMMENT	"\n#// "
#define INIT_D_BEGIN	"\n### BEGIN INIT INFO "
#define INIT_D_PROV	"\n# Provides: "
#define INIT_D_RSTART	"\n# Required-Start: "
#define INIT_D_RSTOP	"\n# Required-Stop: "
#define INIT_D_SSTART	"\n# Should-Start: "
#define INIT_D_SSTOP	"\n# Should-Stop: "
#define INIT_D_DSTART	"\n# Default-Start: "
#define INIT_D_DSTOP	"\n# Default-Stop: "
#define INIT_D_SDESC	"\n# Short-Description: "
#define INIT_D_DESC	"\n# Description: "
#define INIT_D_CONT	"\n#\t"
#define INIT_D_CONT2	"\n#  "
#define INIT_D_END	"\n### END INIT INFO\n"
#define INIT_D_CUSTOM	"\n# X-"


/*
 * init info
 */

typedef struct init_d_info_s {
	char **provides;
	char **reqstart;
	char **reqstop;
	char **shouldstart;
	char **shouldstop;
	int *defstart;
	int *defstop;
	char *shortdesc;
	char *desc;
	char *comment;
	int sizes[11];
	char *path;
	llist_t *start;
} init_d_info_t;


/*
 * init commands
 */

typedef struct init_d_handle_s {
	int (*start) (struct init_d_handle_s *, int);
	int (*stop) (struct init_d_handle_s *, int);
	int (*restart) (struct init_d_handle_s *, int);
	int (*try_restart) (struct init_d_handle_s *, int);
	int (*reload) (struct init_d_handle_s *, int);
	int (*force_reload) (struct init_d_handle_s *, int);
	int (*status) (struct init_d_handle_s *, int);
	int (*show_info) (struct init_d_handle_s *, int);
	char *basename;
	char *pathname;
	char *args;
	char *pidfile;
	char *info;
} init_d_handle_t;


int do_init_from_main(int argc, char **argv, struct init_d_handle_s *init_d);
int do_init(struct init_d_handle_s *init_d, const char *command);

int default_start(struct init_d_handle_s *, int);
int default_stop(struct init_d_handle_s *, int);
int default_restart(struct init_d_handle_s *, int);
int default_try_restart(struct init_d_handle_s *, int);
int default_reload(struct init_d_handle_s *, int);
int default_force_reload(struct init_d_handle_s *, int);
int default_status(struct init_d_handle_s *, int);
int default_show_info(struct init_d_handle_s *, int);

int no_stop(struct init_d_handle_s *, int);
int no_reload(struct init_d_handle_s *, int);
int no_status(struct init_d_handle_s *, int);

int sighup_reload(struct init_d_handle_s *, int);
int print_status(struct init_d_handle_s *init_d, int quiet, int status);

/*
 * error codes
 */

#define INIT_D_OK			0
#define INIT_D_ERROR_GENERIC		1
#define INIT_D_ERROR_ARGS		2
#define INIT_D_ERROR_NOT_IMPLEMENTED	3
#define INIT_D_ERROR_SECURITY		4
#define INIT_D_ERROR_NOT_INSTALLED	5
#define INIT_D_ERROR_NOT_CONFIGURED	6
#define INIT_D_ERROR_NOT_RUNNING	7


/*
 * internal error codes
 *
 * Only used internally to support just_checking.
 */

#define INIT_D_ERROR_JUST_RUNNING	150
#define INIT_D_ERROR_JUST_NOT_RUNNING	151


/*
 * status codes
 */

#define INIT_D_STATUS_OK		0
#define INIT_D_STATUS_DEAD_PID		1
#define INIT_D_STATUS_DEAD_LOCK		2
#define INIT_D_STATUS_NOT_RUNNING	3
#define INIT_D_STATUS_UNKNOWN		4


/*
 * /lib/lsb/init-functions
 */
int start_daemon(int force, int nice_level, char *pidfile, char *pathname,
				 char *args);
int checkpid(char *pid);
void log_success_msg(char *message);
void log_failure_msg(char *message);
void log_warning_msg(char *message);


init_d_info_t *parse_init_info(char *info_text, char *name);
char *get_init_info(char *pathname);
llist_t *get_scripts(void);
llist_t *sort_scripts(llist_t * unsorted);


#define REDIR    1
#define QUIET    2
#define ERRONLY  4
#define FORK     8
#define NOFORK   16
#define DAEMON   32

extern struct stat path_stat;

typedef struct nodes_s {
	const char *name;
	mode_t mode;
	int major;
	int minor;
	int count;
} nodes_t;


char *argv_cat(int argc, char **argv);
char *big_chomp(char *s);
int checkpid(char *pid);
char *doit(int mode, char *command, ...);

#ifndef CONFIG_IFUPDOWN
#define RUNLEVEL_LIST		1
#endif

llist_t *llist_delete(llist_t ** unsorted, llist_t * previous,
					  llist_t * current);
void make_disk(char *token);
void make_ram_disk(int size, int number, char *place, int TMPFS);
void quick_mount(char *type, char *device, char *path, char *data, ...);
char *quick_read(char *filename);
void quick_write(const char *filename, const char *data, ...);


#endif
