/*
 *  MIB group implementation - scalarNodes.c
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>

#include "common/cmmif.h" 
#include "common/writeMethod.h"
 #ifdef ZTE_HOT_AP_SNMP_IF
#include "common/snmpProcess.h"
#endif

#include "scalarNodes.h"
#ifdef  DLINK_SNMP_APP
unsigned char *var_DLINKProductEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method);
unsigned char *var_DLINKSystemEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method);

unsigned char *var_DLINKvoipResourcesEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method);
unsigned char *var_DLINKWanTableEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method);

/*
unsigned char *var_DLINKvoipSignallingEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method);
*/    

unsigned char *var_DLINKLanTableEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method);

unsigned char *var_DLINKAnalogIfInfoEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method);

#endif

unsigned char *var_SystemNodesEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method);
unsigned char *var_IpNodesEntry(struct variable *vp,
            					                  oid     *name,
            					                  size_t  *length,
            					                  int     exact,
            					                  size_t  *var_len,
            					                  WriteMethod **write_method);
#ifdef ZTE_HOT_AP_SNMP_IF
unsigned char *var_SysInfo2NodesEntry(struct variable *vp,
            					                  oid     *name,
            					                  size_t  *length,
            					                  int     exact,
            					                  size_t  *var_len,
            					                  WriteMethod **write_method);
#endif


#ifdef  DLINK_SNMP_APP
struct variable1 DLINK_Product_variables[] = {
    {DLINK_OID_Product, ASN_INTEGER, RONLY, var_DLINKProductEntry, 1, {DLINK_OID_Product}},
};
oid DLINK_Product_variables_oid[] = {1,3,6,1,4,1,171,30,4,1};


struct variable2 DLINK_System_variables[] = {
    {DLINK_OID_sysStatusMachineType, ASN_OCTET_STR, RONLY, var_DLINKSystemEntry, 2, {1,1}},
    {DLINK_OID_sysStatusDriverVersion, ASN_OCTET_STR, RONLY, var_DLINKSystemEntry, 2, {1,2}},
    {DLINK_OID_sysStatusDspType, ASN_OCTET_STR, RONLY, var_DLINKSystemEntry, 2, {1,3}},
    {DLINK_OID_sysStatusSoftwareVersion, ASN_OCTET_STR, RONLY, var_DLINKSystemEntry, 2, {1,4}},
    
    {DLINK_OID_sysMgmtWarmStart, ASN_INTEGER, RWRITE, var_DLINKSystemEntry, 2, {2,1}},
    {DLINK_OID_sysMgmtSaveConfig, ASN_INTEGER, RWRITE, var_DLINKSystemEntry, 2, {2,2}},
    
    {DLINK_OID_devGetCommunity, ASN_OCTET_STR, RWRITE, var_DLINKSystemEntry, 2, {3,1}},
    {DLINK_OID_devSetCommunity, ASN_OCTET_STR, RWRITE, var_DLINKSystemEntry, 2, {3,2}},
    {DLINK_OID_devTrapCommunity, ASN_OCTET_STR, RWRITE, var_DLINKSystemEntry, 2, {3,3}},
    {DLINK_OID_devTrapDestination, ASN_IPADDRESS, RWRITE, var_DLINKSystemEntry, 2, {3,4}},        //ip
    
    {DLINK_OID_gwStatusDdnsResult, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,1}},
    {DLINK_OID_gwStatusProxyCaType, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,2}},
    {DLINK_OID_gwStatusProxyCaFxsResult, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,3}},
    {DLINK_OID_gwStatusProxyCaFxoResult, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,4}},
    {DLINK_OID_gwStatusSlServerResult, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,5}},
    {DLINK_OID_gwStatusStunServerResultv, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,6}},
    {DLINK_OID_gwStatusStunIp, ASN_IPADDRESS, RONLY, var_DLINKSystemEntry, 2, {4,7}},    //ip
    {DLINK_OID_gwStatusStunPort, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,8}},
    {DLINK_OID_gwStatusUpnpServerResult, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,9}},
    {DLINK_OID_gwStatusUpnpIp, ASN_IPADDRESS, RONLY, var_DLINKSystemEntry, 2, {4,10}},
    {DLINK_OID_gwStatusUpnpPort, ASN_INTEGER, RONLY, var_DLINKSystemEntry, 2, {4,11}},

};
oid DLINK_System_variables_oid[] = {1,3,6,1,4,1,171,30,4,2,1};



struct variable3 DLINK_voipResources_variables[] = {
/*    {DLINK_OID_gwStatusWanMac, ASN_OCTET_STR, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,1}},
    {DLINK_OID_gwStatusWanIp, ASN_IPADDRESS, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,2}},
    {DLINK_OID_gwStatusWanMask, ASN_IPADDRESS, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,3}},
    {DLINK_OID_gwStatusWanDefaultGateway, ASN_IPADDRESS, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,4}},
    {DLINK_OID_gwStatusWanDns1, ASN_IPADDRESS, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,5}},
    {DLINK_OID_gwStatusWanDns2, ASN_IPADDRESS, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,6}},
    {DLINK_OID_gwStatusWanLink, ASN_INTEGER, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,7}},
    */
    {DLINK_OID_gwStatusLanMac, ASN_OCTET_STR, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,11}},
    {DLINK_OID_gwStatusLanIp, ASN_IPADDRESS, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,12}},
    {DLINK_OID_gwStatusLanMask, ASN_IPADDRESS, RONLY, var_DLINKvoipResourcesEntry, 3, {1,1,13}},
		
};
oid DLINK_voipResources_variables_oid[] = {1,3,6,1,4,1,171,30,4,2,2};


/*
struct variable1 DLINK_voipSignalling_variables[] = {
    {DLINK_OID_Product, ASN_INTEGER, RONLY, var_DLINKvoipSignallingEntry, 1, {DLINK_OID_Product}},
};
oid DLINK_voipSignalling_variables_oid[] = {1,3,6,1,4,1,171,30,4,2,3};
*/
struct variable1 DLINK_WanTable_variables[] = {
    {DLINK_OID_gwStatusWanMac, ASN_OCTET_STR, RONLY, var_DLINKWanTableEntry, 1, {2}},
    {DLINK_OID_gwStatusWanIp, ASN_IPADDRESS, RONLY, var_DLINKWanTableEntry, 1, {3}},
    {DLINK_OID_gwStatusWanMask, ASN_IPADDRESS, RONLY, var_DLINKWanTableEntry, 1, {4}},
    {DLINK_OID_gwStatusWanDefaultGateway, ASN_IPADDRESS, RONLY, var_DLINKWanTableEntry, 1, {5}},
    {DLINK_OID_gwStatusWanDns1, ASN_IPADDRESS, RONLY, var_DLINKWanTableEntry, 1, {6}},
    {DLINK_OID_gwStatusWanDns2, ASN_IPADDRESS, RONLY, var_DLINKWanTableEntry, 1, {7}},
    {DLINK_OID_gwStatusWanLink, ASN_INTEGER, RONLY, var_DLINKWanTableEntry, 1, {8}},
    
};
oid DLINK_WanTable_variables_oid[] = {1,3,6,1,4,1,171,30,4,2,2,1,1,1,1};

struct variable1 DLINK_LanTable_variables[] = {
    {DLINK_OID_gwStatusLanLinkIndex, ASN_INTEGER, RONLY, var_DLINKLanTableEntry, 1, {1}},
    {DLINK_OID_gwStatusLanLinkStatus, ASN_INTEGER, RONLY, var_DLINKLanTableEntry, 1, {2}},
};
oid DLINK_LanTable_variables_oid[] = {1,3,6,1,4,1,171,30,4,2,2,1,1,14,1};

struct variable1 DLINK_AnalogIfInfo_variables[] = {
    {DLINK_OID_analogIfInfoIndex, ASN_INTEGER, RONLY, var_DLINKAnalogIfInfoEntry, 1, {1}},
    {DLINK_OID_gwStatusLineType, ASN_OCTET_STR, RONLY, var_DLINKAnalogIfInfoEntry, 1, {2}},
    {DLINK_OID_gwStatusLineExtension, ASN_OCTET_STR, RONLY, var_DLINKAnalogIfInfoEntry, 1, {3}},
    {DLINK_OID_gwStatusLineCalls, ASN_OCTET_STR, RONLY, var_DLINKAnalogIfInfoEntry, 1, {4}},
    {DLINK_OID_gwStatusLineStatusStr, ASN_OCTET_STR, RONLY, var_DLINKAnalogIfInfoEntry, 1, {5}},
    {DLINK_OID_gwStatusLineDialedNumber, ASN_OCTET_STR, RONLY, var_DLINKAnalogIfInfoEntry, 1, {6}},
    {DLINK_OID_gwStatusLineProxyCaResult, ASN_OCTET_STR, RONLY, var_DLINKAnalogIfInfoEntry, 1, {7}},
};
oid DLINK_AnalogIfInfo_variables_oid[] = {1,3,6,1,4,1,171,30,4,2,2,2,1,1,1};


#endif
/*
 * system setting
 */
struct variable1 sysinfo_variables[] = {
    {OID_sysVersion, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_sysVersion}},
    {OID_sysMacAddr, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_sysMacAddr}},
    {OID_sysAPName, ASN_OCTET_STR, RWRITE, var_SystemNodesEntry, 1, {OID_sysAPName}},
    {OID_sysSpanningTreeEnable, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_sysSpanningTreeEnable}},
    {OID_sysCountryRegion, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_sysCountryRegion}},
    {OID_wams, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_wams}},
    {OID_watchdog, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_watchdog}},
    {OID_vlanEnable, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_vlanEnable}},
    {OID_managementVlanID, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_managementVlanID}},
    {OID_ethernetDataRate, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_ethernetDataRate}},
    {OID_sysRedBootVersion, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_sysRedBootVersion}},
    {OID_ntpdEnable, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_ntpdEnable}},
    {OID_softwareVendor, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_softwareVendor}},
    {OID_softwareName, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_softwareName}},
    {OID_apBssidNum, ASN_INTEGER, RONLY, var_SystemNodesEntry, 1, {OID_apBssidNum}},
    {OID_essidBssidNum, ASN_INTEGER, RONLY, var_SystemNodesEntry, 1, {OID_essidBssidNum}},
    {OID_apSysNEId, ASN_OCTET_STR, RWRITE, var_SystemNodesEntry, 1, {OID_apSysNEId}},
    {OID_syslogEnabled, ASN_INTEGER, RWRITE, var_SystemNodesEntry, 1, {OID_syslogEnabled}},
    {OID_syslogServerIP, ASN_IPADDRESS, RWRITE, var_SystemNodesEntry, 1, {OID_syslogServerIP}},
    {OID_syslogServerPort, ASN_OCTET_STR, RWRITE, var_SystemNodesEntry, 1, {OID_syslogServerPort}},
    {OID_userName, ASN_OCTET_STR, RWRITE, var_SystemNodesEntry, 1, {OID_userName}},
    {OID_mibVersion, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_mibVersion}},
    {OID_cpuUsage, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_cpuUsage}},
    {OID_memoryUsage, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_memoryUsage}},
    {OID_memoryCapaciry, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_memoryCapaciry}},
    {OID_cpuClockSpeed, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_cpuClockSpeed}},
    {OID_apManufacturer, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_apManufacturer}},
    {OID_cpuTemperature, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_cpuTemperature}},
    {OID_flashUsableCapacity, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_flashUsableCapacity}},
    {OID_apSerial, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_apSerial}},
    {OID_nodeCreateTime, ASN_OCTET_STR, RWRITE, var_SystemNodesEntry, 1, {OID_nodeCreateTime}},
    {OID_nodeTimestamp, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_nodeTimestamp}},
    {OID_password, ASN_OCTET_STR, RWRITE, var_SystemNodesEntry, 1, {OID_password}},
    {OID_flashCapacity, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_flashCapacity}},
    {OID_hardwareversion, ASN_OCTET_STR, RONLY, var_SystemNodesEntry, 1, {OID_hardwareversion}}
};
oid sysinfo_variables_oid[] = {IGD_OID_PREFIX, 1};

/*
 * ip setting
 */
struct variable3 ipsetting_variables[] = { 
    {OID_ethernetIPType, ASN_INTEGER, RWRITE, var_IpNodesEntry, 1, {5, 1}},
    {OID_ethernetIPAddress, ASN_IPADDRESS, RWRITE, var_IpNodesEntry, 2, {5, 2}},
    {OID_ethernetNetmask, ASN_IPADDRESS, RWRITE, var_IpNodesEntry, 2, {5, 3}},
    {OID_ethernetGateway, ASN_IPADDRESS, RWRITE, var_IpNodesEntry, 2, {5, 4}},
    {OID_ethernetDNSPrimary, ASN_IPADDRESS, RWRITE, var_IpNodesEntry, 2, {5, 5}},
    {OID_ethernetDNSSecondary, ASN_IPADDRESS, RWRITE, var_IpNodesEntry, 2, {5, 6}},
    {OID_ethernetDhcpsIPStart, ASN_IPADDRESS, RWRITE, var_IpNodesEntry, 3, {5, 7, 1}},
    {OID_ethernetDhcpsIPEnd, ASN_IPADDRESS, RWRITE, var_IpNodesEntry, 3, {5, 7, 2}},
    {OID_ethernetDhcpsNetmask, ASN_IPADDRESS, RWRITE, var_IpNodesEntry, 3, {5, 7, 3}},
    {OID_pppoeConnStatus, ASN_OCTET_STR, RONLY, var_IpNodesEntry, 2, {7, 1}},
    {OID_pppoeLocalIP, ASN_IPADDRESS, RONLY, var_IpNodesEntry, 2, {7, 2}},
    {OID_pppoeUserName, ASN_OCTET_STR, RWRITE, var_IpNodesEntry, 2, {7, 3}},
    {OID_pppoePassword, ASN_OCTET_STR, RWRITE, var_IpNodesEntry, 2, {7, 4}},
    {OID_pppoeTimeOut, ASN_INTEGER, RWRITE, var_IpNodesEntry, 2, {7, 5}},
    {OID_pppoeRetryTimes, ASN_INTEGER, RWRITE, var_IpNodesEntry, 2, {7, 6}},
    {OID_pppoeAuthenticationType, ASN_INTEGER, RWRITE, var_IpNodesEntry, 2, {7, 7}},
    {OID_pppoeMTU, ASN_INTEGER, RWRITE, var_IpNodesEntry, 2, {7, 8}}
};
oid ipsetting_variables_oid[] = {IGD_OID_PREFIX, 2};
#ifdef ZTE_HOT_AP_SNMP_IF
struct variable4 sysinfo2_variables[] = {
    {OID_w640aNodeID, ASN_OCTET_STR, RONLY, var_SysInfo2NodesEntry, 3, {8, 1, 1}},
    {OID_w640aHostName, ASN_OCTET_STR, RONLY, var_SysInfo2NodesEntry, 3, {8, 1, 2}},
    {OID_w640aVersion, ASN_OCTET_STR, RONLY, var_SysInfo2NodesEntry, 3, {8, 1, 3}},
    {OID_w640aCreateDate, ASN_OCTET_STR, RONLY, var_SysInfo2NodesEntry, 3, {8, 1, 4}},
    {OID_sysfileLoadFlag, ASN_INTEGER, RWRITE, var_SysInfo2NodesEntry, 4, {8, 9, 2, 1}},
    {OID_sysfileType, ASN_INTEGER, RWRITE, var_SysInfo2NodesEntry, 4, {8, 9, 2, 2}},
    {OID_sysfileSize, ASN_OCTET_STR, RWRITE, var_SysInfo2NodesEntry, 4, {8, 9, 2, 3}},
    {OID_sysfileURL, ASN_OCTET_STR, RWRITE, var_SysInfo2NodesEntry, 4, {8, 9, 2, 4}},
    {OID_cmdKey, ASN_OCTET_STR, RWRITE, var_SysInfo2NodesEntry, 4, {8, 9 ,2, 5}}
};
oid sysinfo2_variables_oid[] = {IGD_OID_PREFIX, 8, 1};
#endif

static unsigned long p_ulScalarValue = 0;
static char p_szScalarValue[256] = {0};
static char p_szScalarPath[256] = {0};

#ifdef  DLINK_SNMP_APP
static WanBasicSettingTable_data stWanBasicTbl;
static WanBasicSettingTable_data *pstWanBasicTbl = &stWanBasicTbl; 
static lstList_t stWanBasicList;


static LanBasicSettingTable_data stLanBasicTbl;
static LanBasicSettingTable_data *pstLanBasicTbl = &stLanBasicTbl; 
static lstList_t stLanBasicList;


static AnalogIfInfoTable_data stAnalogIfInfoTbl;
static AnalogIfInfoTable_data *pstAnalogIfInfoTbl = &stAnalogIfInfoTbl; 
static lstList_t stAnalogIfInfoList;
#endif

void init_scalarNodes(void)
{
#ifdef  DLINK_SNMP_APP
    REGISTER_MIB("DLINKProductNodes",  DLINK_Product_variables, variable1, DLINK_Product_variables_oid);
    REGISTER_MIB("DLINKsystemNodes",  DLINK_System_variables, variable2, DLINK_System_variables_oid);
    REGISTER_MIB("DLINKvoipResourcesNodes",  DLINK_voipResources_variables, variable3, DLINK_voipResources_variables_oid);
  //  REGISTER_MIB("DLINKvoipSignallingNodes",  DLINK_voipSignalling_variables, variable1, DLINK_voipSignalling_variables_oid);
    REGISTER_MIB("DLINKvoipLanTableNodes",  DLINK_LanTable_variables, variable1, DLINK_LanTable_variables_oid);
    REGISTER_MIB("DLINKvoipwanTableNodes",  DLINK_WanTable_variables, variable1, DLINK_WanTable_variables_oid);
    REGISTER_MIB("DLINKvoipAnalogIfInfoNodes",  DLINK_AnalogIfInfo_variables, variable1, DLINK_AnalogIfInfo_variables_oid);

#endif
    REGISTER_MIB("sysinfoNodes",  sysinfo_variables, variable1, sysinfo_variables_oid);
#ifdef ZTE_HOT_AP_SNMP_IF    
    REGISTER_MIB("sysinfo2Nodes",  sysinfo2_variables, variable4, sysinfo2_variables_oid);
#endif
    REGISTER_MIB("ipsettingNodes",  ipsetting_variables, variable3, ipsetting_variables_oid);
    SNMPA_TRACE("Init scalar nodes ...\n")
    Init_WriteMethodStruct();
}

void shutdown_scalarNodes(void)
{
    Free_WriteMethodStruct();
}

/*
 * retrieve the ap mac. 
 * first, get wan interface name
 * second, execute ifconfig <wanif> to parse mac address
 * szAPMac <->output the mac of ap interface
 */
static int SCA_getApMac(char *szAPMac)
{
    int i = 0;
    char **ppLanIfList = NULL;
    char *pszLanIfNodePrefix = NULL;

    //IS_CACH_TIMEOUT(stEthLanIfTbl.cachTime);

    ppLanIfList = CMM_GetInstanceList(TR069_ROOT_LanDevice);
    if(!ppLanIfList) return -1;

    for(; ppLanIfList[i]; i++)
    {
        pszLanIfNodePrefix = ppLanIfList[i];
        if(CMM_GetStrColumn(pszLanIfNodePrefix, "X_TWSZ-COM_DeviceName", szAPMac, sizeof(szAPMac), NULL,
                                            NULL, 0) != CMM_SUCCESS)
        {
            break; 
        }

        if(strlen(szAPMac) > 0) /*device interface length must be more than 0, we can promise ok*/
        {
            char szTmp[32] = {0};
            if(IfConfigRead(szAPMac, NULL, "HWaddr", " ", szTmp, sizeof(szTmp)) == 0)
            {
                strcpy(szAPMac, szTmp);
                break; /*We just get the first one, and skip the left*/
            }
        }
    }
    CMM_FreeInstanceList(ppLanIfList);

    return strlen(szAPMac);
}



static unsigned long SCA_getManagementVlanID(unsigned long *ulVlanID)
{
    int i = 0;
    char **ppVlanList = NULL;
    char *pszVlanNodePrefix = NULL;
    char szServiceType[8] = {0};

    //IS_CACH_TIMEOUT(stValTbl.cachTime);
    
    ppVlanList = CMM_GetInstanceList(TR069_ROOT_VlanTable);
    if(!ppVlanList) return -1;

    *ulVlanID = 0; //init to 0 to return
    for(; ppVlanList[i]; i++)
    {
        pszVlanNodePrefix = ppVlanList[i];
        if(CMM_GetStrColumn(pszVlanNodePrefix, "ServiceType", szServiceType, sizeof(szServiceType), NULL,
                                            NULL, 0) == CMM_SUCCESS)
        {
             if(!strcasecmp(szServiceType, "tr069"))
             {
                CMM_GetIntColumn(pszVlanNodePrefix, "VLANIDMark", ulVlanID, NULL, 0);
                break;  /* force to exit loop */
             }
        }
    }
    CMM_FreeInstanceList(ppVlanList);

    return *ulVlanID;
}

static int SCA_getRedBootVersion(char *szSysVer)
{
    int cnt = 0;
    FILE* fp = NULL;
    char cmd[32];
    char buff[32];

    strcpy(cmd, "uname -r");
    fp = popen(cmd, "r");
    if (!fp)
    {
    	CMMIF_TRACE("err: open pipe of '%s' for read failed - %s!\n", cmd, strerror(errno));
    	return -1;
    }

    while (!feof(fp)) 
    {
    	if (!fgets(buff, sizeof(buff), fp))  /* ꣬ȻرļִепܷSIG_PIPE쳣 */
       {
    	    break;
    	}

       if(cnt ++ == 0) //we just return the first line
       {
            strncpy(szSysVer, buff, strlen(buff)-1); //-1 means the last char is LR
       }
    }
    pclose(fp);

    return strlen(szSysVer);
}
#ifdef  DLINK_SNMP_APP
unsigned char *var_DLINKProductEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method)
{
    if(header_generic(vp, name, length, exact, var_len, write_method) ==  MATCH_FAILED)
        return NULL;

    switch(vp->magic)
    {
        case DLINK_OID_Product:

                    p_ulScalarValue = 1;
                    return (unsigned char*)&p_ulScalarValue;

	    break;
        default:
            break;
    }
	return NULL;
}

unsigned char *var_DLINKSystemEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method)
{
    if(header_generic(vp, name, length, exact, var_len, write_method) ==  MATCH_FAILED)
        return NULL;

    switch(vp->magic)
    {
        case DLINK_OID_sysStatusMachineType:
            return NULL;
        case DLINK_OID_sysStatusDriverVersion:
            return NULL;
        case DLINK_OID_sysStatusDspType:
            return NULL;
        case DLINK_OID_sysStatusSoftwareVersion:
		//	InternetGatewayDevice.DeviceInfo.ModemFirmwareVersion
	    if(CMM_GetStr("InternetGatewayDevice.DeviceInfo.ModemFirmwareVersion", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) == CMM_SUCCESS)
	    {
                *var_len = strlen(p_szScalarValue);
                return (unsigned char*)p_szScalarValue;
	    }

		return NULL;

	 case DLINK_OID_sysMgmtWarmStart:
		return NULL;
	 case DLINK_OID_sysMgmtSaveConfig:
		return NULL;

	 case DLINK_OID_devGetCommunity:
	    *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 32, 0, NULL, TR069_ROOT_SNMP "ROCommunity", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_SNMP "ROCommunity", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) == CMM_SUCCESS)
	    {
                *var_len = strlen(p_szScalarValue);
                return (unsigned char*)p_szScalarValue;
	    }
           return NULL;
	 case DLINK_OID_devSetCommunity:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 32, 0, NULL, TR069_ROOT_SNMP "RWCommunity", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_SNMP "RWCommunity", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) == CMM_SUCCESS)
	    {
                *var_len = strlen(p_szScalarValue);
                return (unsigned char*)p_szScalarValue;
	    }
           return NULL;
	 case DLINK_OID_devTrapCommunity:
	    *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 32, 0, NULL, TR069_ROOT_SNMP "TrapCommunity", NULL, 0);
	   if(CMM_GetStr(TR069_ROOT_SNMP "TrapCommunity", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) == CMM_SUCCESS)
	    {
                *var_len = strlen(p_szScalarValue);
                return (unsigned char*)p_szScalarValue;
	    }

	    else return NULL;

	 case DLINK_OID_devTrapDestination:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 32, 0, NULL, TR069_ROOT_SNMP "TrapHost", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_SNMP "TrapHost", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) == CMM_SUCCESS)
	    {
               //return CHARS_TO_intIPADDR(p_szScalarValue);
               p_ulScalarValue = inet_addr(p_szScalarValue);
		 return (unsigned char*)&p_ulScalarValue;

	    }
           return NULL;

	 case DLINK_OID_gwStatusDdnsResult:
	    if(CMM_GetUlong(TR069_ROOT_DDNS "Enable", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
                return (unsigned char*)&p_ulScalarValue;
	    }
	    else return NULL;
	 case DLINK_OID_gwStatusProxyCaType:

		return NULL;
	 case DLINK_OID_gwStatusProxyCaFxsResult:
	 		 	//VoiceService.{i}.VoiceProfile.{i}.Line.{i}.Status
	    if(CMM_GetUlong("InternetGatewayDevice.Services.VoiceService.1.VoiceProfile.1.Line.1.Status", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
                return (unsigned char*)&p_ulScalarValue;
	    }
	    else return NULL;

	 case DLINK_OID_gwStatusProxyCaFxoResult:
		return NULL;
	 case DLINK_OID_gwStatusSlServerResult:
		return NULL;
	 case DLINK_OID_gwStatusStunServerResultv:
	    if(CMM_GetUlong("InternetGatewayDevice.Services.VoiceService.1.VoiceProfile.1.X_TWSZ-COM_StunStatus", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
                return (unsigned char*)&p_ulScalarValue;
	    }
	    else return NULL;
		return NULL;
	 case DLINK_OID_gwStatusStunIp:
		return NULL;
	 case DLINK_OID_gwStatusStunPort:
		return NULL;
	 case DLINK_OID_gwStatusUpnpServerResult:
	    if(CMM_GetUlong("InternetGatewayDevice.X_TWSZ-COM_UPNP.Enable", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
                return (unsigned char*)&p_ulScalarValue;
	    }
	    else return NULL;	
		return NULL;
	 case DLINK_OID_gwStatusUpnpIp:
		return NULL;
	 case DLINK_OID_gwStatusUpnpPort:
		return NULL;
        default:
            return NULL;
    }
	return NULL;
}

static char p_szScalarMacValue[30] = {0};
static int StrtoMac(char *src, char *mac)
{
    int i,j;
     j = 0;
    for(i =0; src[i] != 0;i++)
    {
     	  if(i%3 == 2) continue;       //ȥmacе:
          mac[j] = src[i];
	    j++;
	  
    }
    mac[j]  = 0;
}



unsigned char *var_DLINKvoipResourcesEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method)
{
    if(header_generic(vp, name, length, exact, var_len, write_method) ==  MATCH_FAILED)
        return NULL;

    switch(vp->magic)
    {
   
/*	 case DLINK_OID_gwStatusWanMac:
		return NULL;
	 case DLINK_OID_gwStatusWanIp:
		return NULL;
	 case DLINK_OID_gwStatusWanMask:
		return NULL;
	 case DLINK_OID_gwStatusWanDefaultGateway:
		return NULL;
	 case DLINK_OID_gwStatusWanDns1:
		return NULL;
	 case DLINK_OID_gwStatusWanDns2:
		return NULL;
	 case DLINK_OID_gwStatusWanLink:
		return NULL;
		*/
	 case DLINK_OID_gwStatusLanMac:
	     if(!SCA_getApMac(p_szScalarMacValue))
           {
                return NULL;
	    }
	     StrtoMac(p_szScalarMacValue,p_szScalarValue);
	    break;
	 case DLINK_OID_gwStatusLanIp:
	 	//TR069_ROOT_LanHostMgmt"IPInterface.1.IPInterfaceIPAddress"
	    if(CMM_GetStr(TR069_ROOT_LanHostMgmt"IPInterface.1.IPInterfaceIPAddress", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) == CMM_SUCCESS)
	    {
              // return CHARS_TO_intIPADDR(p_szScalarValue);
              p_ulScalarValue = inet_addr(p_szScalarValue);
		 return (unsigned char*)&p_ulScalarValue;
              
	    }
           return NULL;
	 case DLINK_OID_gwStatusLanMask:
	 	//TR069_ROOT_LanHostMgmt"IPInterface.1.IPInterfaceSubnetMask"
	    if(CMM_GetStr(TR069_ROOT_LanHostMgmt"IPInterface.1.IPInterfaceSubnetMask", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) == CMM_SUCCESS)
	    {
              // return CHARS_TO_intIPADDR(p_szScalarValue);
               p_ulScalarValue = inet_addr(p_szScalarValue);
		 return (unsigned char*)&p_ulScalarValue;

	    }

		return NULL;

        default:
            return NULL;
    }
    *var_len = strlen(p_szScalarValue);
    return (unsigned char*)p_szScalarValue;
}

#define TR069_ROOT_WanConfiguration "InternetGatewayDevice.WANDevice.1.WANConnectionDevice."

static int loadWan_BasicTable(void)
{
    int i = 0;
    int ret = SNMP_ERR_NOERROR;
    char **ppWanBasicList = NULL;
    char *pszWanBasicNodePrefix = NULL;

    char *pszLineNodePrefix = NULL;
    char cLineObjName[192] = {0};
    char **ppLineList = NULL;
	

    IS_CACH_TIMEOUT(stWanBasicTbl.cachTime);

    ppWanBasicList = CMM_GetInstanceList(TR069_ROOT_WanConfiguration);
    if(!ppWanBasicList) return -1;

    for(; ppWanBasicList[i]; i++)
    {
        pszWanBasicNodePrefix = ppWanBasicList[i];
        stWanBasicTbl.WanInstanceID  = atoi(pszWanBasicNodePrefix+sizeof(TR069_ROOT_WanConfiguration) - 1); //Get the instance NO.
        stWanBasicTbl.gwStatusWanLinkIndex = i;
        /*Get values for all leaf ndoes under <pszWlanBasicNodePrefix> patrial path*/
        if(CMM_GetStrColumn(pszWanBasicNodePrefix, "X_TWSZ-COM_MACAddress", stWanBasicTbl.gwStatusWanMac, sizeof(stWanBasicTbl.gwStatusWanMac), NULL,
                                            NULL, 0) != CMM_SUCCESS)
    	{
             ret = SNMP_ERR_GENERR;
            goto PExit;

    	}

// pppoe
        if(CMM_GetIntColumn(pszWanBasicNodePrefix, "WANPPPConnectionNumberOfEntries", &(stWanBasicTbl.WANPPPConnectionNumberOfEntries),
                                            NULL, 0) != CMM_SUCCESS)
        {
             ret = SNMP_ERR_GENERR;
            goto PExit;
        }

// ip
        if(CMM_GetIntColumn(pszWanBasicNodePrefix, "WANIPConnectionNumberOfEntries", &(stWanBasicTbl.WANIPConnectionNumberOfEntries),
                                            NULL, 0) != CMM_SUCCESS)
        {
             ret = SNMP_ERR_GENERR;
            goto PExit;
        }
		//printf("snmp-------------------------test pppp '%d'   test ip   %d!\n",
		//	stWanBasicTbl.WANPPPConnectionNumberOfEntries, stWanBasicTbl.WANIPConnectionNumberOfEntries);

       if(stWanBasicTbl.WANPPPConnectionNumberOfEntries > 0)
       {
	        sprintf(cLineObjName,"%s%s.",pszWanBasicNodePrefix,"WANPPPConnection");
       }
	 else if (stWanBasicTbl.WANIPConnectionNumberOfEntries > 0)
	 {
		sprintf(cLineObjName,"%s%s.",pszWanBasicNodePrefix,"WANIPConnection");
	 
	 }

	if((stWanBasicTbl.WANPPPConnectionNumberOfEntries > 0)||(stWanBasicTbl.WANIPConnectionNumberOfEntries > 0))
	{
		 if (!(ppLineList = CMM_GetInstanceList(cLineObjName)))
		 {
			ret = SNMP_ERR_GENERR;
			break;
		 }

			pszLineNodePrefix = ppLineList[0];
		//printf("snmp-------------------------%s!\n",pszLineNodePrefix);

		        /*Get values for all leaf ndoes under <pszWlanBasicNodePrefix> patrial path*/
		        if(CMM_GetStrColumn(pszLineNodePrefix, "ExternalIPAddress", stWanBasicTbl.gwStatusWanIp, sizeof(stWanBasicTbl.gwStatusWanIp), NULL,
		                                            NULL, 0) != CMM_SUCCESS)
		    	{
		             ret = SNMP_ERR_GENERR;
		            goto PExit;
			}
				
		       if(stWanBasicTbl.WANPPPConnectionNumberOfEntries > 0)
		       {
				strcpy(stWanBasicTbl.gwStatusWanMask,"255.255.255.255");
			}
			 else
		 	{
				if(CMM_GetStrColumn(pszLineNodePrefix, "SubnetMask", stWanBasicTbl.gwStatusWanMask, sizeof(stWanBasicTbl.gwStatusWanMask), NULL,
			                                            NULL, 0) != CMM_SUCCESS)
			    	{
			             ret = SNMP_ERR_GENERR;
			            goto PExit;
				}

			
		 	}

		       if(stWanBasicTbl.WANPPPConnectionNumberOfEntries > 0)
		       {
			       if(CMM_GetStrColumn(pszLineNodePrefix, "RemoteIPAddress", stWanBasicTbl.gwStatusWanDefaultGateway, sizeof(stWanBasicTbl.gwStatusWanDefaultGateway), NULL,
			                                            NULL, 0) != CMM_SUCCESS)
			    	{
			             ret = SNMP_ERR_GENERR;
			            goto PExit;
				}

			}
			 else
		 	{
			       if(CMM_GetStrColumn(pszLineNodePrefix, "DefaultGateway", stWanBasicTbl.gwStatusWanDefaultGateway, sizeof(stWanBasicTbl.gwStatusWanDefaultGateway), NULL,
			                                            NULL, 0) != CMM_SUCCESS)
			    	{
			             ret = SNMP_ERR_GENERR;
			            goto PExit;
				}
		 	}

		        if(CMM_GetStrColumn(pszLineNodePrefix, "DNSServers", stWanBasicTbl.gwStatusWanDns1, sizeof(stWanBasicTbl.gwStatusWanDns1), NULL,
		                                            NULL, 0) != CMM_SUCCESS)
		    	{
		             ret = SNMP_ERR_GENERR;
		            goto PExit;
			}
		        if(CMM_GetStrColumn(pszLineNodePrefix, "DNSServers", stWanBasicTbl.gwStatusWanDns2, sizeof(stWanBasicTbl.gwStatusWanDns2), NULL,
		                                            NULL, 0) != CMM_SUCCESS)
		    	{
		             ret = SNMP_ERR_GENERR;
		            goto PExit;
			}

	}
	else
	{
		strcpy(stWanBasicTbl.gwStatusWanIp,"0.0.0.0");
		strcpy(stWanBasicTbl.gwStatusWanMask,"0.0.0.0");
		strcpy(stWanBasicTbl.gwStatusWanDefaultGateway,"0.0.0.0");
		strcpy(stWanBasicTbl.gwStatusWanDns1,"0.0.0.0");
		strcpy(stWanBasicTbl.gwStatusWanDns2,"0.0.0.0");
	
	}


        TW_addList((char *)&stWanBasicList, (char *)&stWanBasicTbl, sizeof(stWanBasicTbl), sizeof(long));
    }
PExit:    
    CMM_FreeInstanceList(ppWanBasicList);

    return ret;
}


unsigned char *var_DLINKWanTableEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method)
{
    oid rName [ MAX_OID_LEN ] = {0};     // OID to be returned

    if(loadWan_BasicTable() != SNMP_ERR_NOERROR) 
    {
        SNMPA_TRACE("Failed to exec loadWan_BasicTable, it return error!\n");
        return NULL;
    }

    memcpy((char *)rName, (char *)vp->name, (int)vp->namelen * sizeof (oid));
    for(hdlNode=LIST_FIRST(&stWanBasicList); hdlNode!=NULL; hdlNode=LIST_NEXT(hdlNode, nodes)) 
    {
        pstWanBasicTbl = (LanBasicSettingTable_data*) hdlNode->data;
        rName[vp->namelen] = pstWanBasicTbl->WanInstanceID; /*we are sure instance id is always with index <vp->namelen>*/

        if((exact && (snmp_oid_compare(rName, vp->namelen+1, name, *length) == 0)) || //request
            (!exact && (snmp_oid_compare(rName, vp->namelen+1, name, *length) >  0)))  //exact == 0 means request next
        {
	     memcpy((char *)name, (char *)rName, (vp->namelen + 1) * sizeof(oid));
	     *length = vp->namelen + 1;
	     *var_len = sizeof (long);  

		    switch(vp->magic)
		    {
			 case DLINK_OID_gwStatusWanMac:
			 	StrtoMac(pstWanBasicTbl->gwStatusWanMac,p_szScalarValue);
			 	*var_len = safe_strlen(p_szScalarValue);
				return (unsigned char*)p_szScalarValue;
			 case DLINK_OID_gwStatusWanIp:
			 	//*var_len = safe_strlen(pstWanBasicTbl->gwStatusWanIp);
				//return (unsigned char*)pstWanBasicTbl->gwStatusWanIp;
				if (0 == strlen(pstWanBasicTbl->gwStatusWanIp))
					p_ulScalarValue = 0;
				else
				 	p_ulScalarValue = inet_addr(pstWanBasicTbl->gwStatusWanIp);
		 		return (unsigned char*)&p_ulScalarValue;
			 case DLINK_OID_gwStatusWanMask:
			 	if (0 == strlen(pstWanBasicTbl->gwStatusWanMask))
					p_ulScalarValue = 0;
				else
				      p_ulScalarValue = inet_addr(pstWanBasicTbl->gwStatusWanMask);
		 		return (unsigned char*)&p_ulScalarValue;
			 case DLINK_OID_gwStatusWanDefaultGateway:
			 	if (0 == strlen(pstWanBasicTbl->gwStatusWanDefaultGateway))
					p_ulScalarValue = 0;
				else
					 p_ulScalarValue = inet_addr(pstWanBasicTbl->gwStatusWanDefaultGateway);
		 		return (unsigned char*)&p_ulScalarValue;
			 case DLINK_OID_gwStatusWanDns1:
			 	//printf("snmp-----gwStatusWanDns1--------------------%s!\n",pstWanBasicTbl->gwStatusWanDns1);
			 	sscanf(pstWanBasicTbl->gwStatusWanDns1,"%[^,],%s",pstWanBasicTbl->gwStatusWanDns1,p_szScalarValue);
				//printf("snmp-----gwStatusWanDns1--------------------%s!\n",pstWanBasicTbl->gwStatusWanDns1);
			 	if (0 == strlen(pstWanBasicTbl->gwStatusWanDns1))
					p_ulScalarValue = 0;
				else
				 	p_ulScalarValue = inet_addr(pstWanBasicTbl->gwStatusWanDns1);
		 		return (unsigned char*)&p_ulScalarValue;
			 case DLINK_OID_gwStatusWanDns2:
			 	strcpy(p_szScalarValue,"0.0.0.0"); 
			 	sscanf(pstWanBasicTbl->gwStatusWanDns2,"%[^,],%s",pstWanBasicTbl->gwStatusWanDns2,p_szScalarValue);
			 	if (0 == strlen(p_szScalarValue))
					p_ulScalarValue = 0;
				else
				 	p_ulScalarValue = inet_addr(p_szScalarValue);
		 		return (unsigned char*)&p_ulScalarValue;

		        default:
		            break;
		    }
        	}

        }
	return NULL;
}

/*
unsigned char *var_DLINKvoipSignallingEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method)
{
    if(header_generic(vp, name, length, exact, var_len, write_method) ==  MATCH_FAILED)
        return NULL;

    switch(vp->magic)
    {
   
	 case DLINK_OID_gwStatusUpnpServerResult:
		return NULL;
	 case DLINK_OID_gwStatusUpnpIp:
		return NULL;
	 case DLINK_OID_gwStatusUpnpPort:
		return NULL;
        default:
            break;
    }
	return NULL;
}

*/
#define TR069_ROOT_LanConfiguration "InternetGatewayDevice.LANDevice.1.LANEthernetInterfaceConfig."

static int loadLan_BasicTable(void)
{
    int i = 0;
    int ret = SNMP_ERR_NOERROR;
    char **ppLanBasicList = NULL;
    char *pszLanBasicNodePrefix = NULL;

    IS_CACH_TIMEOUT(stLanBasicTbl.cachTime);

    ppLanBasicList = CMM_GetInstanceList(TR069_ROOT_LanConfiguration);
    if(!ppLanBasicList) return -1;

    for(; ppLanBasicList[i]; i++)
    {
        pszLanBasicNodePrefix = ppLanBasicList[i];
        stLanBasicTbl.LanInstanceID  = atoi(pszLanBasicNodePrefix+sizeof(TR069_ROOT_LanConfiguration) - 1); //Get the instance NO.
        stLanBasicTbl.gwStatusLanLinkIndex = i;
        /*Get values for all leaf ndoes under <pszWlanBasicNodePrefix> patrial path*/
        if(CMM_GetIntColumn(pszLanBasicNodePrefix, "Enable", &(stLanBasicTbl.gwStatusLanLinkStatus),
                                            NULL, 0) != CMM_SUCCESS)
        {
             ret = SNMP_ERR_GENERR;
            goto PExit;
        }
     

        TW_addList((char *)&stLanBasicList, (char *)&stLanBasicTbl, sizeof(stLanBasicTbl), sizeof(long));
    }
PExit:    
    CMM_FreeInstanceList(ppLanBasicList);

    return ret;
}


unsigned char *var_DLINKLanTableEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method)
{
    oid rName [ MAX_OID_LEN ] = {0};     // OID to be returned

    if(loadLan_BasicTable() != SNMP_ERR_NOERROR) 
    {
        SNMPA_TRACE("Failed to exec loadWlan_BasicTable, it return error!\n");
        return NULL;
    }

    memcpy((char *)rName, (char *)vp->name, (int)vp->namelen * sizeof (oid));
    for(hdlNode=LIST_FIRST(&stLanBasicList); hdlNode!=NULL; hdlNode=LIST_NEXT(hdlNode, nodes)) 
    {
        pstLanBasicTbl = (LanBasicSettingTable_data*) hdlNode->data;
        rName[vp->namelen] = pstLanBasicTbl->LanInstanceID; /*we are sure instance id is always with index <vp->namelen>*/

        if((exact && (snmp_oid_compare(rName, vp->namelen+1, name, *length) == 0)) || //request
            (!exact && (snmp_oid_compare(rName, vp->namelen+1, name, *length) >  0)))  //exact == 0 means request next
        {
	     memcpy((char *)name, (char *)rName, (vp->namelen + 1) * sizeof(oid));
	     *length = vp->namelen + 1;
	     *var_len = sizeof (long);  

		    switch(vp->magic)
		    {
		   
			 case DLINK_OID_gwStatusLanLinkIndex:
				return (unsigned char*)&(pstLanBasicTbl->gwStatusLanLinkIndex);
			 case DLINK_OID_gwStatusLanLinkStatus:
				return (unsigned char*)&(pstLanBasicTbl->gwStatusLanLinkStatus);
		        default:
		            break;
		    }
        	}

        }
	return NULL;
}

#define TR069_ROOT_AnalogIfInfo "InternetGatewayDevice.Services.VoiceService.1.VoiceProfile."
static int loadAnalogIfInfoTable(void)
{
    int i = 0;
    int ret = SNMP_ERR_NOERROR;
    char **ppAnalogIfInfoList = NULL;
    char *pszAnalogIfInfoNodePrefix = NULL;

    char *pszLineNodePrefix = NULL;
    char cLineObjName[192] = {0};
    char **ppLineList = NULL;

    IS_CACH_TIMEOUT(stAnalogIfInfoTbl.cachTime);

    ppAnalogIfInfoList = CMM_GetInstanceList(TR069_ROOT_AnalogIfInfo);
    if(!ppAnalogIfInfoList) return -1;

    for(; ppAnalogIfInfoList[i]; i++)
    {
        pszAnalogIfInfoNodePrefix = ppAnalogIfInfoList[i];
        stAnalogIfInfoTbl.AnalogIfInstanceID  = atoi(pszAnalogIfInfoNodePrefix+sizeof(TR069_ROOT_AnalogIfInfo) - 1); //Get the instance NO.
        stAnalogIfInfoTbl.analogIfInfoIndex = i;
       sprintf(cLineObjName,"%s%s.",pszAnalogIfInfoNodePrefix,"Line");
	 if (!(ppLineList = CMM_GetInstanceList(cLineObjName)))
	 {
		ret = SNMP_ERR_GENERR;
		break;
	 }
	pszLineNodePrefix = ppLineList[0];

        /*Get values for all leaf ndoes under <pszWlanBasicNodePrefix> patrial path*/
        if(CMM_GetStrColumn(pszLineNodePrefix, "X_TWSZ-COM_Type", stAnalogIfInfoTbl.gwStatusLineType, sizeof(stAnalogIfInfoTbl.gwStatusLineType), NULL,
                                            NULL, 0) != CMM_SUCCESS)
    	{
             ret = SNMP_ERR_GENERR;
            goto PExit;

    	}
    
        if(CMM_GetStrColumn(pszLineNodePrefix, "DirectoryNumber", stAnalogIfInfoTbl.gwStatusLineExtension, sizeof(stAnalogIfInfoTbl.gwStatusLineExtension), NULL,
                                            NULL, 0) != CMM_SUCCESS)
    	{
             ret = SNMP_ERR_GENERR;
            goto PExit;

    	}

        if(CMM_GetStrColumn(pszLineNodePrefix, "Stats.X_TWSZ-COM_CallsConnected", stAnalogIfInfoTbl.gwStatusLineCalls, sizeof(stAnalogIfInfoTbl.gwStatusLineCalls), NULL,
                                            NULL, 0) != CMM_SUCCESS)
    	{
             ret = SNMP_ERR_GENERR;
            goto PExit;

    	}
        if(CMM_GetStrColumn(pszLineNodePrefix, "CallState", stAnalogIfInfoTbl.gwStatusLineStatusStr, sizeof(stAnalogIfInfoTbl.gwStatusLineStatusStr), NULL,
                                            NULL, 0) != CMM_SUCCESS)
    	{
             ret = SNMP_ERR_GENERR;
            goto PExit;

    	}

/*        if(CMM_GetIntColumn(pszLineNodePrefix, "Stats.OutgoingCallsAttempted", 
                                            &stAnalogIfInfoTbl.gwStatusLineDialedNumber, NULL, 0) != CMM_SUCCESS)

    	{
             ret = SNMP_ERR_GENERR;
            goto PExit;

    	}
    	*/
    	 if(CMM_GetStrColumn(pszLineNodePrefix, "Stats.OutgoingCallsAttempted", stAnalogIfInfoTbl.gwStatusLineDialedNumber, sizeof(stAnalogIfInfoTbl.gwStatusLineDialedNumber), NULL,
                                            NULL, 0) != CMM_SUCCESS)
    	{
             ret = SNMP_ERR_GENERR;
            goto PExit;

    	}

        if(CMM_GetStrColumn(pszLineNodePrefix, "Status", stAnalogIfInfoTbl.gwStatusLineProxyCaResult, sizeof(stAnalogIfInfoTbl.gwStatusLineProxyCaResult), NULL,
                                            NULL, 0) != CMM_SUCCESS)
    	{
             ret = SNMP_ERR_GENERR;
            goto PExit;

    	}
	
        TW_addList((char *)&stAnalogIfInfoList, (char *)&stAnalogIfInfoTbl, sizeof(stAnalogIfInfoTbl), sizeof(long));
    }
PExit:    
    CMM_FreeInstanceList(ppAnalogIfInfoList);

    return ret;
}



unsigned char *var_DLINKAnalogIfInfoEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method)
{
    oid rName [ MAX_OID_LEN ] = {0};     // OID to be returned

    if(loadAnalogIfInfoTable() != SNMP_ERR_NOERROR) 
    {
        SNMPA_TRACE("Failed to exec loadWlan_BasicTable, it return error!\n");
        return NULL;
    }

    memcpy((char *)rName, (char *)vp->name, (int)vp->namelen * sizeof (oid));
    for(hdlNode=LIST_FIRST(&stAnalogIfInfoList); hdlNode!=NULL; hdlNode=LIST_NEXT(hdlNode, nodes)) 
    {
        pstAnalogIfInfoTbl = (LanBasicSettingTable_data*) hdlNode->data;
        rName[vp->namelen] = pstAnalogIfInfoTbl->AnalogIfInstanceID; /*we are sure instance id is always with index <vp->namelen>*/

        if((exact && (snmp_oid_compare(rName, vp->namelen+1, name, *length) == 0)) || //request
            (!exact && (snmp_oid_compare(rName, vp->namelen+1, name, *length) >  0)))  //exact == 0 means request next
        {
	     memcpy((char *)name, (char *)rName, (vp->namelen + 1) * sizeof(oid));
	     *length = vp->namelen + 1;
	     *var_len = sizeof (long);  
    switch(vp->magic)
    {
  
	 case DLINK_OID_analogIfInfoIndex:
		return (unsigned char*)&(pstAnalogIfInfoTbl->analogIfInfoIndex);
	 case DLINK_OID_gwStatusLineType:
	 	*var_len = safe_strlen(pstAnalogIfInfoTbl->gwStatusLineType);
		return (unsigned char*)pstAnalogIfInfoTbl->gwStatusLineType;
	 case DLINK_OID_gwStatusLineExtension:
	 	  *var_len = safe_strlen(pstAnalogIfInfoTbl->gwStatusLineExtension);
		return (unsigned char*)pstAnalogIfInfoTbl->gwStatusLineExtension;

	 case DLINK_OID_gwStatusLineCalls:
	 	*var_len = safe_strlen(pstAnalogIfInfoTbl->gwStatusLineCalls);
		return (unsigned char*)pstAnalogIfInfoTbl->gwStatusLineCalls;

	 case DLINK_OID_gwStatusLineStatusStr:
	 	  *var_len = safe_strlen(pstAnalogIfInfoTbl->gwStatusLineStatusStr);	
		return (unsigned char*)pstAnalogIfInfoTbl->gwStatusLineStatusStr;
	 case DLINK_OID_gwStatusLineDialedNumber:
		//return (unsigned char*)&(pstAnalogIfInfoTbl->gwStatusLineDialedNumber);
    	 	  *var_len = safe_strlen(pstAnalogIfInfoTbl->gwStatusLineDialedNumber);	
		return (unsigned char*)pstAnalogIfInfoTbl->gwStatusLineDialedNumber;

	 case DLINK_OID_gwStatusLineProxyCaResult:
	 	*var_len = safe_strlen(pstAnalogIfInfoTbl->gwStatusLineProxyCaResult);	
		return (unsigned char*)pstAnalogIfInfoTbl->gwStatusLineProxyCaResult;
        default:
            break;
    }
	
   }
}
	return NULL;
}


#endif    //DLINK_SNMP_APP
unsigned char *var_SystemNodesEntry(struct variable *vp,
                					                  oid     *name,
                					                  size_t  *length,
                					                  int     exact,
                					                  size_t  *var_len,
                					                  WriteMethod **write_method)
{
    if(header_generic(vp, name, length, exact, var_len, write_method) ==  MATCH_FAILED)
        return NULL;

    switch(vp->magic)
    {
        case OID_sysVersion:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo"SoftwareVersion", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
	    break;
        case OID_sysMacAddr:
           if(!SCA_getApMac(p_szScalarValue))
           {
                return NULL;
	    }
	    break;
        case OID_sysAPName:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 256, 0, NULL, TR069_ROOT_DeviceInfo"Description", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo"Description", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
	    break;
        case OID_sysSpanningTreeEnable:
            return NULL;
        case OID_sysCountryRegion:
            return NULL;
        case OID_wams:
            return NULL;
        case OID_watchdog:
            return NULL;
        case OID_vlanEnable:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 1, 0, 1, NULL, TR069_ROOT_Vlan "Enable", NULL, 0);
	    if(CMM_GetUlong(TR069_ROOT_Vlan "Enable", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
                return (unsigned char*)&p_ulScalarValue;
	    }
	    else return NULL;
        case OID_managementVlanID:
            SCA_getManagementVlanID(&p_ulScalarValue);
            return (unsigned char*)&p_ulScalarValue;
        case OID_ethernetDataRate:
            {
                static char *szMatch[] = {"Auto", "0", "10", "10", "100", "100"};
                *write_method = WriteMethod_Comm;
                Active_WriteMethod(vp->type, vp->acl, 1, 0, 100, NULL, 
                                                  TR069_ROOT_WanEthIfConf "MaxBitRate", szMatch, GET_ARRAY_BOUNADRY(szMatch));
                if(CMM_GetStr(TR069_ROOT_WanEthIfConf "MaxBitRate", p_szScalarValue, sizeof(p_szScalarValue),
                                         szMatch, GET_ARRAY_BOUNADRY(szMatch)) == CMM_SUCCESS)
                {
                    p_ulScalarValue = atoi(p_szScalarValue);
                    return (unsigned char*)&p_ulScalarValue;
                }
                return NULL;
            }
        case OID_sysRedBootVersion:
            if(!SCA_getRedBootVersion(p_szScalarValue))
            {
                return NULL;
            }
            break;
        case OID_ntpdEnable:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 1, 0, 1, NULL, TR069_ROOT_Ntp "X_TWSZ-COM_SNTPEnabled", NULL, 0);
	    if(CMM_GetUlong(TR069_ROOT_Ntp "X_TWSZ-COM_SNTPEnabled", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
                return (unsigned char*)&p_ulScalarValue;
	    }
	    else return NULL;
        case OID_softwareVendor:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "APVendor", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
	    break;
        case OID_softwareName:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "ModelName", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
	    break;
        case OID_apBssidNum:
            return NULL;
        case OID_essidBssidNum:
            return NULL;            
        case OID_apSysNEId:
            return NULL;
        case OID_syslogEnabled:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 1, 0, 1, NULL, TR069_ROOT_Logger "LoggerEnabled", NULL, 0);
	    if(CMM_GetUlong(TR069_ROOT_Logger "LoggerEnabled", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
	        return (unsigned char*)&p_ulScalarValue;
	    }
           else return NULL;
        case OID_syslogServerIP:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 32, 0, NULL, TR069_ROOT_Logger "LogTFTPServer", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_Logger "LogTFTPServer", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) == CMM_SUCCESS)
	    {
               return CHARS_TO_intIPADDR(p_szScalarValue);
	    }
           return NULL;
        case OID_syslogServerPort:
            return NULL;
        case OID_userName:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 256, 0, NULL, TR069_ROOT_Auth "X_TWSZ-COM_UserName", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_Auth "X_TWSZ-COM_UserName", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
	        return NULL;
	    }
           break;
        case OID_mibVersion:
            sprintf(p_szScalarValue, "%lu.0", (unsigned long)IGDMIB_OID);
            break;
        case OID_cpuUsage:
	    {
		  int ret = 0;
                float fResult = 0.00;
		  if ((ret = mib_get_cpu_occup(&fResult)) == SNMP_ERR_NOERROR)
		  {
                    memset(p_szScalarValue, 0, sizeof(p_szScalarValue));
                    sprintf(p_szScalarValue, "%f", fResult);
                    strcat(p_szScalarValue, "%");
		  }
                else SNMPA_TRACE("mib_get_cpu_occup failed. ret: %08x\n", ret);
	         break;
	    }
        case OID_memoryUsage:
           {
                unsigned long ulFree = 0;
                unsigned long ulTotal = 0;
                if ( GetFeatureInt(PROC_MEMINFO, MEMTOTAL, &ulTotal, 10)==0 &&
                      GetFeatureInt(PROC_MEMINFO, MEMFREE, &ulFree, 10)==0) 
                {
                    float fResult = 0.00;
                    fResult = ((ulTotal - ulFree) * 100.00)/ulTotal;
                    memset(p_szScalarValue, 0, sizeof(p_szScalarValue));
                    sprintf(p_szScalarValue, "%f", fResult);
                    strcat(p_szScalarValue, "%");
                }
                else SNMPA_TRACE("GetFeatureInt failed!\n");
                break;
           }
        case OID_memoryCapaciry:
	    if (GetFeatureInt(PROC_MEMINFO, MEMTOTAL, &p_ulScalarValue, 10) == 0)
	    {
                sprintf(p_szScalarValue, "%lu", p_ulScalarValue);
           }
           else SNMPA_TRACE("GetFeatureInt failed!\n");
	    break;
        case OID_cpuClockSpeed:
	    if (GetFeature(PROC_CPUINFO, CPUFRQ, p_szScalarValue, sizeof(p_szScalarValue)) != 0)
	    {
               SNMPA_TRACE("GetFeature failed!\n");
               return NULL;
	    }
           break;
        case OID_apManufacturer:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "Manufacturer", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
	    break;
        case OID_cpuTemperature:
            return NULL;
        case OID_flashUsableCapacity:
           {
                unsigned long ulFree = 0;
                p_ulScalarValue = FlashTotal();
                p_ulScalarValue >>= 10;	/* unit is Kb */
                
                if (GetProcInt(PROC_FLASHFREE, &ulFree, 16) == 0)
                {
                    ulFree >>= 10;	/* unit is KB */
                    p_ulScalarValue -= ulFree;
                    sprintf(p_szScalarValue, "%lu", p_ulScalarValue);
                }
                else SNMPA_TRACE("GetFeatureInt failed!\n");
                break;
           }
        case OID_apSerial:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "SerialNumber", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
                return NULL;
	    }
	    break;
        case OID_nodeCreateTime:
            return NULL;
        case OID_nodeTimestamp:
            return NULL;
        case OID_password:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 256, 0, NULL, TR069_ROOT_Auth "X_TWSZ-COM_Password", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_Auth "X_TWSZ-COM_Password", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
	        return NULL;
	    }
           break;
        case OID_flashCapacity:
	    p_ulScalarValue = FlashTotal();
           sprintf(p_szScalarValue, "%lu", p_ulScalarValue>>10);
           break;
        case OID_hardwareversion:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "HardwareVersion", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
                return NULL;
	    }
	    break;
        default:
            break;
    }

    *var_len = strlen(p_szScalarValue);
    return (unsigned char*)p_szScalarValue;
}

unsigned char *var_IpNodesEntry(struct variable *vp,
            					                  oid     *name,
            					                  size_t  *length,
            					                  int     exact,
            					                  size_t  *var_len,
            					                  WriteMethod **write_method)
{
    if(header_generic(vp, name, length, exact, var_len, write_method) ==  MATCH_FAILED)
        return NULL;

    switch(vp->magic)
    {
        case OID_ethernetIPType:
        case OID_ethernetIPAddress:
        case OID_ethernetNetmask:
        case OID_ethernetGateway:
        case OID_ethernetDNSPrimary:
        case OID_ethernetDNSSecondary:
        case OID_ethernetDhcpsIPStart:
        case OID_ethernetDhcpsIPEnd:
        case OID_ethernetDhcpsNetmask:
        case OID_pppoeConnStatus:
        case OID_pppoeLocalIP:
        case OID_pppoeUserName:
        case OID_pppoePassword:
        case OID_pppoeTimeOut:
        case OID_pppoeRetryTimes:
        case OID_pppoeAuthenticationType:
        case OID_pppoeMTU:
        default:
            break;
    }
    
    return NULL;
}

#ifdef ZTE_HOT_AP_SNMP_IF
/*
 * launch the action of upload or download
 */
static int SCA_writeMethod_DoTransfer(int action, 
                                                                unsigned char *var_val, 
                                                                unsigned char var_val_type, 
                                                                size_t var_val_len, 
                                                                unsigned char *statP, 
                                                                oid *name, 
                                                                size_t length)
{
    unsigned long ulNewVal = *((unsigned long *) var_val);
    static unsigned long ulFileType = ZERO;
    switch(action)
    {
        case RESERVE1:
              if(var_val_len > sizeof(unsigned long)) return SNMP_ERR_WRONGLENGTH;
	       if(ulNewVal != DOWNLOAD && ulNewVal != UPLOAD) return SNMP_ERR_WRONGVALUE;

              if(CMM_GetUlong(TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileType", &ulFileType, NULL, 0) != CMM_SUCCESS)
              {
                  return SNMP_ERR_GENERR;
              }
SNMPA_TRACE("ulFileType:%lu\n", ulFileType); //wei              
              if(ulNewVal == UPLOAD)
              {
                if(ulFileType == IMG_FILE) 
                {/*When upload, firemare type can't be supported*/
                    SNMPA_TRACE("Bad command: can't upload firmeware IMAGE file to server!!!\n");
                    return SNMP_ERR_WRONGVALUE;
                }
              }
              else 
              {
                 if(ulFileType == LOG_FILE) /*don't support logger file*/
                 {
                    SNMPA_TRACE("Bad command: can't download log file to CPE!!!\n");
                    return SNMP_ERR_WRONGVALUE;
                 }
              }
		break;
        case RESERVE2:
		break;
	 case ACTION:
              if(CMM_SetUlong(TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileLoadFlag", ulNewVal, NULL, 0) != CMM_SUCCESS)
              {
                  return SNMP_ERR_GENERR;
              }              
              break;
	 case UNDO:
		break;
        case COMMIT:
              {
                  int isFail = 0;
                  char szFileSize[64] = {0};
                  char szFileUrl[256] = {0};
                  const char *FAIL_TRAP_INFO[] = 
                  {
                    "Failed to read upload/download parameters.",
                    "Failed to read current mem size.",
                    "File size is too big, no enough room for download.",
                    "Internal error"
                  };

                  if(CMM_GetStr(TR069_ROOT_FILETRANS "X_TWSZ-COM_cmdKey", szFileSize, sizeof(szFileSize), NULL, 0) != CMM_SUCCESS ||
                      CMM_GetStr(TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileURL", szFileUrl, sizeof(szFileUrl), NULL, 0) != CMM_SUCCESS)
                  {
                      isFail = 1; /*reading relative references for upload/download has been wrong*/
                      goto fail_trap;
                  }

                  if(ulNewVal == DOWNLOAD)
                  {
                       /*make sure that free falsh on ap is more than <filesize>*/
                      unsigned long ulFree = 0;
                       if (GetProcInt(PROC_FLASHFREE, &ulFree, 16) != 0) /*unit is byte*/
                      {
                          isFail = 2; /*Fail to get flash free size*/
                          SNMPA_TRACE("GetFeatureInt failed!\n");
                          goto fail_trap;
                      }

                      if(ulFree < atoi(szFileSize))
                      {
                          isFail = 3; /*no enough room for download*/
                          goto fail_trap;
                      }
                    SNMPA_TRACE("ulNewVal:%lu, ulFileType:%lu\n", ulNewVal, ulFileType); //wei
                      if(SNMPA_StartComline(ulNewVal, ulFileType, szFileUrl) == TBS_SUCCESS)
                          goto succ_exit;
                      
                      isFail = 4;
                      goto fail_trap;
                  }
                  else /*Upload*/
                  {
                      if(ulFileType == LOG_FILE)
                      {
                          if(SNMPA_StartComline(ulNewVal, ulFileType, szFileUrl) == TBS_SUCCESS)
                              goto succ_exit;

                          isFail = 4;
                          goto fail_trap;
                      }
                      else /*THis must be Config file now*/
                      if(SNMPA_CreateCfgFile(szFileUrl) == TBS_SUCCESS)
                          goto succ_exit;
                  }

                  succ_exit:
                      SNMPA_TRACE("Good, everything is perfect.......\n"); //wei
                      goto exit_all;
                  fail_trap:
                     SNMPA_TRACE("My God, Something is wrong.......\n"); //wei
                     SNMPA_CustomizedTrap_AsFail(NULL, FAIL_TRAP_INFO[isFail-1]);
              }
	 	break;
	 case FREE:
		break;
    }
exit_all:
    return SNMP_ERR_NOERROR;
}

unsigned char *var_SysInfo2NodesEntry(struct variable *vp,
            					                  oid     *name,
            					                  size_t  *length,
            					                  int     exact,
            					                  size_t  *var_len,
            					                  WriteMethod **write_method)
{
    if(header_generic(vp, name, length, exact, var_len, write_method) ==  MATCH_FAILED)
        return NULL;

    switch(vp->magic)
    {
        case OID_w640aNodeID:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "SerialNumber", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
        case OID_w640aHostName:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "ModelName", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
        case OID_w640aVersion:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "SoftwareVersion", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
        case OID_w640aCreateDate:
	    if(CMM_GetStr(TR069_ROOT_DeviceInfo "X_TWSZ-COM_w640aCreateDate", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
        case OID_sysfileLoadFlag:
            *write_method = SCA_writeMethod_DoTransfer;
	    if(CMM_GetUlong(TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileLoadFlag", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
	        return (unsigned char*)&p_ulScalarValue;
	    }
	    else return NULL;
        case OID_sysfileType:
            *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 1, IMG_FILE, LOG_FILE, NULL, TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileType", NULL, 0);
	    if(CMM_GetUlong(TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileType", &p_ulScalarValue, NULL, 0) == CMM_SUCCESS)
	    {
	        return (unsigned char*)&p_ulScalarValue;
	    }
	    else return NULL;
        case OID_sysfileSize:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 64, 0, NULL, TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileSize", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileSize", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
           break;
        case OID_sysfileURL:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 256, 0, NULL, TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileURL", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_FILETRANS "X_TWSZ-COM_sysfileURL", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
           break;
        case OID_cmdKey:
           *write_method = WriteMethod_Comm;
           Active_WriteMethod(vp->type, vp->acl, 0, 256, 0, NULL, TR069_ROOT_FILETRANS "X_TWSZ-COM_cmdKey", NULL, 0);
	    if(CMM_GetStr(TR069_ROOT_FILETRANS "X_TWSZ-COM_cmdKey", p_szScalarValue, sizeof(p_szScalarValue), NULL, 0) != CMM_SUCCESS)
	    {
               return NULL;
	    }
           break;
        default:
            break;
    }
    
    *var_len = strlen(p_szScalarValue);
    return (unsigned char*)p_szScalarValue;
}
#endif
