#include "tbsmsg.h"
#include "tbstype.h"
#include "tbsutil.h"
#include "tbserror.h"
#include "warnlog.h"
#include "common.h"
#include "tbsflash.h"

#include "cmmif.h"
#include "snmpProcess.h"


#define SNMPA_GET_UCHAR(p, value) \
    value = *( (unsigned char *)p ); \
    p += sizeof(unsigned char);

#define SNMPA_GET_ULONG(p, value) \
    value = *( (unsigned long *)p ); \
    p += sizeof(unsigned long);

static char gszUploadDestPath[64];

/*Variables for upload and download*/
#define _FIRMWARE_FILE   "/var/image.img"
#define _CONFIG_FILE     "/var/config.xml"
#define _LOG_FILE "/var/log/sysevent.txt"
enum 
{
    NONE,
    IMG_WRITE,
    CONFIG_READ,
    CONFIG_WRITE
};

#define MSG_SNMPA_STATE_DOWNLOAD 0x8989 /*msg id for download when executing comline*/
#define MSG_SNMPA_STATE_UPLOAD 0x9898 /*msg id for upload when executing comline*/
enum EN_SNMPA_ComlineState {clDown, clUp, clWait};
typedef struct tag_ST_SNMPA_Private
{
	enum EN_SNMPA_ComlineState enComlineState;
        unsigned long ulComlinePID;
}ST_SNMPA_Private;
/*marks the status of executing comline*/
ST_SNMPA_Private g_stSNMPAPrivate = {clDown, 0x0};

#define SNMPA_RECEIVE_TIME_OUT 5


static int isFirmwareFile = ZERO;  /*FILE_TYPE*/
static int gisDownload = EMPTY;  /*ACTION_TYPE*/
static oid download_upload_oid[] = {1, 3, 6, 1, 4, 1, 3902, 1, 8, 1, 8, 10, 0, 9};

static traps_info traps_message[] = {
{"ColdStart", 21005, {1, 3, 6, 1, 6, 3, 1, 1, 5, 1}, 10}, 
};

/* ִcomlineƥϢб */
/*process output 
 *(ƥ"Done!"һоͱʾɹ)0-ͳɹ
 *(ƥ"Fatal Error"һоͿ֪ʧܵԭ)2ʧ trap
 */
char *apcRegExpress[] = {
"(unspecified)", 
"(Sorry)",
"Fatal Error:(.*)\r\n",
"(Done!)"                  /*޸indexDOWNLOAD_DONE_INDEXҲ*/
};
#define DOWNLOAD_DONE_INDEX 3 /*in apcRegExpress array, (Done!) 's index*/
ST_ProcOutMatchInfo  g_astSNMPMatchInfoList[ ] = {
    {NULL, SNMPA_SendDl_UlFailTrap_paraEmpty},
    {NULL,  SNMPA_SendDl_UlFailTrap_paraEmpty},
    {NULL, SNMPA_SendDl_UlFailTrap},
    {NULL, SNMPA_SendDl_UlSuccTrap}
};
static int gisDownloadSuccessful = 0; /*mark if the download action is successful*/
#define TRAP_START "onetrapwhenstart"


//////////////////////START HERE--------------------------------------------------------------------
/* Щ"APܽӿڹ淶V1.0"б仯ע޸............
sysUpTime  	.1.3.6.1.2.1.1.3	TimeTicks	ϵʱ,Э涨ʵֵ
snmpTrapOID	.1.3.6.1.6.3.1.1.4.1滻ʵʵĸ澯OID	SnmpOid	TrapOidд澯Ϣ
nodeId 	.1.3.6.1.4.1.3902.1.8.1.8.1.1	DisplayString	豸ʶȫбΨһMacַҲڿͨʱ趨
alarmCause	.1.3.6.1.4.1.3902.1.8.1.8.10.5	Integer	澯
alarmLevel	.1.3.6.1.4.1.3902.1.8.1.8.10.3	Integer	澯1-أ2-Ҫ3-һ㣻4-΢
alarmEventTime	.1.3.6.1.4.1.3902.1.8.1.8.10.6	TimeTicks	澯ʱ
alarmTitle      	.1.3.6.1.4.1.3902.1.8.1.8.10.8	DisplayString	澯,澯Ӧѡ
alarmAdditionalInfo     	.1.3.6.1.4.1.3902.1.8.1.8.10.9	DisplayString	澯Ϣ˵
*/
#ifndef IGD_ENTERPRISE_OID
#define IGD_ENTERPRISE_OID		3902
#endif
#ifndef IGDMIB_OID
#define IGDMIB_OID				1
#endif
#ifndef IGD_OID_PREFIX
#define IGD_OID_PREFIX			1,3,6,1,4,1,IGD_ENTERPRISE_OID,IGDMIB_OID
#endif

/*
 * before sending trap, this method must be invoked regard as ZTE protocol
 * return 0 - successful, non-zero - fail
 * NOTE - when alarmCode is 0 1 2, alarmLevel, alarmEventTime and alarmTitle don't be supported
 */
void ZTE_AddTrapPremsg(netsnmp_variable_list **vars, 
                                                 oid *trapoid, unsigned long ulTrapOidLen,
                                                 unsigned long ulAlarmCode, 
                                                 unsigned long ulAlarmLevel, char *pszAlarmTitle, char *pszAlarmInfo)
{
    int idx = 0;
    char szNodeId[64] = {0}; 
    unsigned long ulEventTime = time(NULL);
    oid zte_snmptrap_oid[] = {1, 3, 6, 1, 6, 3, 1, 1, 4, 1, 0};
    oid zte_snmptrap_preoid[][13] = {
        {IGD_OID_PREFIX, 8, 1, 8, 1, 1},
        {IGD_OID_PREFIX, 8, 1, 8, 10, 5},
        {IGD_OID_PREFIX, 8, 1, 8, 10, 3},
        {IGD_OID_PREFIX, 8, 1, 8, 10, 6},
        {IGD_OID_PREFIX, 8, 1, 8, 10, 8},
        {IGD_OID_PREFIX, 8, 1, 8, 10, 9}};
SNMPA_TRACE("Start...\n"); //wei

    //strlenĲNULLʱᵼ¶δҪԲж
    if ((pszAlarmTitle == NULL) || (pszAlarmInfo == NULL))
    {
        SNMPA_TRACE("Error in-parameter!Some parameter can not be NULL\n"); 
        return ;
    }
    
    /*
   * add in the trap definition object
   */
    snmp_varlist_add_variable(vars,
    	zte_snmptrap_oid, OID_LENGTH(zte_snmptrap_oid), /* the snmpTrapOID.0 variable */
    	ASN_OBJECT_ID, (u_char *) trapoid, ulTrapOidLen);

    /*"InternetGatewayDevice.DeviceInfo."ļscalarNodes.cжTR069_ROOT_DeviceInfo*/
    if(CMM_GetStr("InternetGatewayDevice.DeviceInfo.SerialNumber", szNodeId, sizeof(szNodeId), NULL, 0) != CMM_SUCCESS)
    {
        SNMPA_TRACE("Failed to read SerialNumber!\n");
        return;
    }

    snmp_varlist_add_variable(vars, zte_snmptrap_preoid[idx], OID_LENGTH(zte_snmptrap_preoid[idx++]),
    	                                           ASN_OCTET_STR, (u_char *)szNodeId, strlen(szNodeId));

    snmp_varlist_add_variable(vars, zte_snmptrap_preoid[idx], OID_LENGTH(zte_snmptrap_preoid[idx++]),
    	                                           ASN_INTEGER, (u_char *)&ulAlarmCode, sizeof(ulAlarmCode));

    /*"APܽӿڹ淶V1.0"е"2.	ͽ֪ͨ涨alarmCode<3ʱĿ澯ǲҪ"*/
    if(ulAlarmCode > 3)
    {
        snmp_varlist_add_variable(vars, zte_snmptrap_preoid[idx], OID_LENGTH(zte_snmptrap_preoid[idx++]),
        	                                           ASN_INTEGER, (u_char *)&ulAlarmLevel, sizeof(ulAlarmLevel));

        snmp_varlist_add_variable(vars, zte_snmptrap_preoid[idx], OID_LENGTH(zte_snmptrap_preoid[idx++]),
        	                                           ASN_TIMETICKS, (u_char *)&ulEventTime, sizeof(ulEventTime));

        snmp_varlist_add_variable(vars, zte_snmptrap_preoid[idx], OID_LENGTH(zte_snmptrap_preoid[idx++]),
        	                                           ASN_OCTET_STR, (u_char *)pszAlarmTitle, strlen(pszAlarmTitle));
    }
SNMPA_TRACE("Exit...\n"); //wei
    snmp_varlist_add_variable(vars, zte_snmptrap_preoid[idx], OID_LENGTH(zte_snmptrap_preoid[idx++]),
    	                                           ASN_OCTET_STR, (u_char *)pszAlarmInfo, strlen(pszAlarmInfo));
}
//////////////////////END HERE--------------------------------------------------------------------


/*loop to receive message from pc and execute them*/
void snmpa_handleMessage()
{
    ST_MSG *pstMsg = NULL;
    if (MSG_OK == MSG_ReceiveMessage(&pstMsg, SNMPA_RECEIVE_TIME_OUT))
    {
        /* յϢԷֵ */
        snmpa_MsgProcess(pstMsg);
        safe_free_msg(pstMsg);
    }
}

int snmpa_MsgProcess(void *pstMsg_void)
{
    int nRet = TBS_SUCCESS;
    ST_MSG *pstMsg = (ST_MSG*)pstMsg_void;
    if (NULL == pstMsg)
    {
        SNMPA_TRACE("NULL pointer encounterd.\n");
        return TBS_FAILED;
    }

    SNMPA_TRACE("Received Msg From(%#x) (len = %lu type = %u)\n",
        pstMsg->stMsgHead.usSrcMID, pstMsg->stMsgHead.ulBodyLength, pstMsg->stMsgHead.usMsgType);

    switch (pstMsg->stMsgHead.usMsgType)
    {
        case MSG_PC_START_PROC_ACK: /*succeed in processing comline: 1 trap*/
            SNMPA_HandleProcStart(pstMsg);
            break;
        case MSG_PC_PROC_OUTPUT: 
            SNMPA_MsgProcOutputHandler(pstMsg);
            break;
        case MSG_PC_PROC_STATE: /*process exit*/
            SNMPA_HandleProcState(pstMsg);
            break;
        case MSG_CMM_BACKUP_ACK:
            SNMPA_StartComline(UPLOAD, CONFIG_FILE, gszUploadDestPath);
            break;
        default:
            nRet = TBS_FAILED;
            SNMPA_TRACE("Recieved INGNORED message, Its id is %d.\n", pstMsg->stMsgHead.usMsgType);
            break;
    }

    return nRet;
}

/* ڴƥϢPCģ鷢͹ƥϢӦƥ䴦 */
void SNMPA_MsgProcOutputHandler(ST_MSG *pstMsg)
{
    char *pcPos = NULL;
    unsigned long ulProcId = 0;
    unsigned char ucCount = 0;
    unsigned char ucMatchNo = 0;
    unsigned char i = 0;
SNMPA_TRACE("Has come into ...\n"); //wei
    if ( NULL == pstMsg )
    {
        SNMPA_TRACE("TBS_NULL_PTR");
        return;
    }

    pcPos = pstMsg->szMsgBody;
    /* ID */
    SNMPA_GET_ULONG(pcPos, ulProcId);
    /* ƥ*/
    SNMPA_GET_UCHAR(pcPos, ucCount);
SNMPA_TRACE("ucCount: %d\n", ucCount); //wei
    for (i=0; i<ucCount; i++)
    {
        /* ƥ*/
        SNMPA_GET_UCHAR(pcPos, ucMatchNo);
        SNMPA_TRACE("ucMatchNo = %u, Output = %s\n", ucMatchNo, pcPos);
        if (ucMatchNo>0 && ucMatchNo<=sizeof(g_astSNMPMatchInfoList) / sizeof(ST_ProcOutMatchInfo))
        {
            if(ucMatchNo-1 == DOWNLOAD_DONE_INDEX) gisDownloadSuccessful = 1; /*download the needed file, flag it*/
            g_astSNMPMatchInfoList[ucMatchNo - 1].pMatchFunc(NULL, pcPos);
            break; /*wei add this for breaking loop, least work to resolve this problem...*/
            /*ģǵƥ䣬жƥ䣬ȡһˣ
            Ϊжƥ䣬϶ǳˣ涨ƥ˳
            ܱ֤ʱ͵ǳtrap*/
        }
        pcPos += safe_strlen(pcPos) + 1;
    }

    return;
}

/*download or upload failure trap*/
int  SNMPA_SendDl_UlFailTrap_paraEmpty(void *pInstance, const char *pszOutInfo)
{
    netsnmp_variable_list *vars = NULL;
    char szWarnMessage[256] = {0};

    snprintf(szWarnMessage, sizeof(szWarnMessage), "Bad command syntax:parameter(s) needed!\n");
    if(pszOutInfo)
        strcat(szWarnMessage, pszOutInfo);

    /*澯:0-ͳɹ1У2ʧ*/
    ZTE_AddTrapPremsg(&vars, download_upload_oid, sizeof(download_upload_oid), 2, 0, NULL, szWarnMessage); 
    send_v2trap(vars);
    snmp_free_varbind(vars);
}

/*download or upload failure trap*/
int  SNMPA_SendDl_UlFailTrap(void *pInstance, const char *pszOutInfo)
{
    netsnmp_variable_list *vars = NULL;
    char szWarnMessage[256] = {0};

    if(gisDownload == DOWNLOAD) snprintf(szWarnMessage, sizeof(szWarnMessage)-sizeof("Download - "), "Download - %s", pszOutInfo);
    else if(gisDownload == UPLOAD) snprintf(szWarnMessage, sizeof(szWarnMessage)-sizeof("Upload - "), "Upload - %s", pszOutInfo);
    else return TBS_FAILED;

    /*澯:0-ͳɹ1У2ʧ*/
    ZTE_AddTrapPremsg(&vars, download_upload_oid, sizeof(download_upload_oid), 2, 0, NULL, szWarnMessage); 
    send_v2trap(vars);
    snmp_free_varbind(vars);
}

/*download or upload success trap*/
int  SNMPA_SendDl_UlSuccTrap(void *pInstance, const char *pszOutInfo)
{
    netsnmp_variable_list *vars = NULL;
    char szWarnMessage[48] = {0};

    if(gisDownload == DOWNLOAD) strcpy(szWarnMessage, "Download successful! ");
    else if(gisDownload == UPLOAD) strcpy(szWarnMessage, "Upload successful! ");
    else if(safe_strcmp(pszOutInfo, "1") == 0) strcpy(szWarnMessage, "Upgrade successful! "); /*һسɹtrap*/
    else return TBS_FAILED;

    /*澯:0-ͳɹ1У2ʧ*/
    ZTE_AddTrapPremsg(&vars, download_upload_oid, sizeof(download_upload_oid), 0, 0, NULL, szWarnMessage); 
    send_v2trap(vars);
    snmp_free_varbind(vars);
}

/*downloading or uploading trap*/
int SNMPA_HandleProcStart (ST_MSG* pstMsg)
{
    netsnmp_variable_list *vars = NULL;
    char szWarnMessage[32] = {0};
    unsigned long ulMsgId = 0;

    if(gisDownload == DOWNLOAD)
    {
        ulMsgId = MSG_SNMPA_STATE_DOWNLOAD;
        strcpy(szWarnMessage, "Downloading...");
    }
    else if(gisDownload == UPLOAD)
    {
        ulMsgId = MSG_SNMPA_STATE_UPLOAD;
        strcpy(szWarnMessage, "Uploading...");
    }
    else return TBS_FAILED;

    if(ulMsgId == pstMsg->stMsgHead.ulMsgID)
    {
        if( 0x0 != * (unsigned long *) pstMsg->szMsgBody)
        {
            g_stSNMPAPrivate.enComlineState = clDown;
            SNMPA_TRACE("Start Process comline error !\n");
        }
        else /*succeed in launching comline, then send "ing" trap*/
        {
            SNMPA_TRACE("Start PID = %lu\n", *(unsigned long*)(pstMsg->szMsgBody+ sizeof(unsigned long)));
            g_stSNMPAPrivate.enComlineState = clUp;
            g_stSNMPAPrivate.ulComlinePID = *(unsigned long*)(pstMsg->szMsgBody+ sizeof(unsigned long));

            /*澯:0-ͳɹ1У2ʧ*/
            ZTE_AddTrapPremsg(&vars, download_upload_oid, sizeof(download_upload_oid), 1, 0, NULL, szWarnMessage); 
            send_v2trap(vars);
            snmp_free_varbind(vars);
            
            SNMPA_TRACE("Start Process comline success!\n");
        }    
    }
    else SNMPA_TRACE("Received a start message unexpected!\n");

    return TBS_SUCCESS;
}


/**********************************************************************
  snmpaִд˳
  ˵:˳
  : 
                          pstMsg յ˳Ϣ

  : 
    ֵ: TBS_SUCCESSʾɹ
  ޶¼:
           1.: weichongx
             : 2008-11-14
             : 
**********************************************************************/
int SNMPA_HandleProcState (ST_MSG* pstMsg)
{
    /*жǷΪSNMPAPID*/
    SNMPA_TRACE(" ProcID %lu quit!\n",  * (unsigned long *)pstMsg->szMsgBody);

    if(g_stSNMPAPrivate.ulComlinePID == *(unsigned long*)pstMsg->szMsgBody)
    {
        g_stSNMPAPrivate.enComlineState = clDown;
        g_stSNMPAPrivate.ulComlinePID = 0;

        SNMPA_TRACE("SNMPA: comline finished!\n"); 
        if(gisDownload==DOWNLOAD || gisDownloadSuccessful==1) /*ҪʧܵupdateҲĿ겻⣬Ȼ*/
        {
            gisDownloadSuccessful = 0; /*reset it*/
            SNMPA_SaveEventsToFlash(TRAP_START); /*save flag to flash when upgrader is done, we need send trap*/
            
            SNMPA_TRACE("SNMPA: comline finished! launch the upgrader now...\n");
            SNMPA_do_upgrade(isFirmwareFile);
        }
    }
    else
    {
    SNMPA_TRACE("unknown ProcID %lu quit!\n",  * (unsigned long *)pstMsg->szMsgBody);
    }

    return TBS_SUCCESS;
}

/*
/sbin/comline -o /var/image.img -get http://192.168.1.100/test/fuck.img - for DOWNLOAD
/sbin/comline -put /var/tmp/tr069up -dest http://192.168.1.100/test/tr069 - for UPLOAD
whichFile - two types file, 1 config file; 2 firemware image file
*/
int SNMPA_StartComline(int action, int whichFile, char *szRemoteURL)
{
    /*PCģ鷢һϢcomline*/
    int itmp = 0;
    unsigned long ulMsgId = 0;
    ST_PC_PROC_START pProcStart;
    char *args[] = {"/sbin/comline", 0, 0, 0, 0};

    if(g_stSNMPAPrivate.enComlineState == clDown)
    {
        gisDownload = action;
        if(gisDownload == DOWNLOAD) /*Download*/
        {
            args[1] = "-o";
            args[3] = "-get";
            ulMsgId = MSG_SNMPA_STATE_DOWNLOAD;
        }
        else if(gisDownload == UPLOAD) /*Upload*/
        {
            args[1] = "-put";
            args[3] = "-dest";
            ulMsgId = MSG_SNMPA_STATE_UPLOAD;
        }
        else return TBS_FAILED;

        /*local file*/
        isFirmwareFile = whichFile; /*record file type*/
        if(whichFile == IMG_FILE) args[2] = _FIRMWARE_FILE;
        else if(whichFile == CONFIG_FILE) args[2] = _CONFIG_FILE;
        else args[2] = _LOG_FILE;
        args[4] = szRemoteURL; /*remote url*/
        
        SNMPA_TRACE("%s %s %s %s %s\n", args[0], args[1], args[2], args[3], args[4]);
        
        memset(&pProcStart, 0, sizeof(pProcStart));
        pProcStart.usMID = MID_SNMPA;
        pProcStart.ulMsgID = ulMsgId;
        pProcStart.ucNeedSteady = 0;
        pProcStart.ucExecCount = 0x05;
        pProcStart.ppcExecInfo = args;
        pProcStart.ucMonCount = sizeof(apcRegExpress)/sizeof(apcRegExpress[0]);;
        pProcStart.ppcMonVals = apcRegExpress;
        itmp = PC_StartProcess(&pProcStart);
        if(itmp)
        {
            SNMPA_TRACE("Start comline error %d. \n", itmp);
            return TBS_OUT_OF_SRC;
        }
        
        g_stSNMPAPrivate.enComlineState = clWait;
    }
    else
    {
       SNMPA_TRACE("Attempt to start comline while it is running...\n");
    }
    return TBS_SUCCESS;
}

/*After done downloading, do upgrade*/
/*
  ssap/upg/upg_frw.c has been modified, in main() method:
  if(!strcmp(cuser, "SNMPA"))
  {
       sMID = MID_SNMPA;
  }
  has been added for recognizing SNMPA. then upg module can send response to me...
 */
int SNMPA_do_upgrade(int mode)
{
    char szCmd[SYS_CMD_LEN] = {0};
    ST_MSG *pstMsg;
    int iRet = 0;
    unsigned long ulResult;
    
    switch(mode)
    {
        case 1:
            sprintf(szCmd, "upgrader -c %d -p " _FIRMWARE_FILE " -u SNMPA", IMG_WRITE);
            tbsSystem(szCmd, 1);  
            break;            
        case 2:
            sprintf(szCmd, "upgrader -c %d -p " _CONFIG_FILE " -u SNMPA", CONFIG_WRITE);
            tbsSystem(szCmd, 1);            
            break;
        default:
            syslog(LOG_ERR, "snmpa: error upgrade mode: %lu\n", mode);
            break;
    }

    sleep(2);
    iRet = MSG_ReceiveMessage(&pstMsg, 5); /*scan the message for this module, check the status*/
    switch (iRet)
    {
        case MSG_OK:
            syslog(LOG_NOTICE, "Receive msg success.");
            break;
        case MSG_TIMEOUT:
            syslog(LOG_ERR, "Receive msg failed.");
            return TBS_FAILED;
        default:
            syslog(LOG_ERR, "Receive msg failed.");
            return TBS_FAILED;
    }
    
    /* յӦϢ */
    if (pstMsg->stMsgHead.usSrcMID != MID_UPG)
    {
        syslog(LOG_ERR, "message id error");
        return TBS_FAILED;
    }

    ulResult = *(unsigned long *)pstMsg->szMsgBody;
    if (ulResult != 0)
    {
        syslog(LOG_ERR, "upgrade failed");
        safe_free_msg(pstMsg);
        return TBS_FAILED;
    }

    syslog(LOG_NOTICE, "upgrade success");
    safe_free_msg(pstMsg);
    return TBS_SUCCESS;
}

/*Because config.xml must be created when upload it*/
int SNMPA_CreateCfgFile(char *szRemoteURL)
{
    int nRet = TBS_SUCCESS;
    ST_MSG *pstGetAddressMsg = NULL;
    SNMPA_TRACE("Start....\n");

    /*Save this feature value, when the following message acked, we use them for upload*/
    strcpy(gszUploadDestPath, szRemoteURL);
    
    pstGetAddressMsg = (ST_MSG*)MSG_CreateMessage(256);
    if (!pstGetAddressMsg)
     return TBS_FAILED;

    pstGetAddressMsg->stMsgHead.usMsgType = MSG_CMM_BACKUP;
    pstGetAddressMsg->stMsgHead.ulMsgID = 1002; /*random value*/
    pstGetAddressMsg->stMsgHead.usDstMID = MID_CMM;
    pstGetAddressMsg->stMsgHead.usSrcMID = MID_SNMPA;

    safe_strncpy(pstGetAddressMsg->szMsgBody, _CONFIG_FILE, safe_strlen(_CONFIG_FILE)+1);
    pstGetAddressMsg->stMsgHead.ulBodyLength = safe_strlen(_CONFIG_FILE);

    /* Sending  message*/
    nRet = MSG_SendMessage(pstGetAddressMsg);
    safe_free_msg(pstGetAddressMsg);

    if(TBS_SUCCESS != nRet)
    {
        SNMPA_TRACE(" send message error!\n");
    }
    
    return nRet;
}

/*----------------------------------------------------------
 *Read traps data from flash methods
 -----------------------------------------------------------*/
 /*
  read value from buf by a specified name, value is formated as name\tvalue\n
*/
#define EVENT_PRE "TRAP"               /*flashTRAPʶƵǰ׺Event_1ʼ*/
int SNMPA_ReadEventsFromFlash(char *buf, char *name)
{
       char *ptr = NULL;
	char *pos, *pos1;
	
	ptr = buf;
	while((pos = strchr(ptr, '\n')))
	{
		*pos = 0;
		pos++;
		pos1 = strchr(ptr, '\t');
		if(pos1)
		{
			*pos1 = 0;
			pos1++;
			if(!safe_strcmp(ptr, name)) /*Got it*/
			{
                            SNMPA_TRACE("Read event of %s from flash.\n", pos1); 
                            return TBS_SUCCESS; /*GOT ONE, only one for snmpa*/
		       }
		}
		ptr = pos;
	}
    
       return TBS_FAILED;
}

/*
 return: the event number represents how much event saved in flash has added to event list
 ݵĻtbs_success
*/
int SNMPA_GetTrapEventSavedInFlash(void)
{
    int nRet = TBS_FAILED;
    const int SNMPA_FLASH_SIZE = 256; /*maybe my memory in flash section is less than 256*/
    char *buf = malloc(SNMPA_FLASH_SIZE); 

    if(buf)
    {
	    int res = ReadOrigiData(OBJ_SNMPA, buf, SNMPA_FLASH_SIZE);
	    if(res > 4) /* event name length must be more than 4 */
	    {
	        buf[res] = 0;
	        nRet = SNMPA_ReadEventsFromFlash(buf, EVENT_PRE);
	        WriteOrigiData(OBJ_SNMPA, "", 1, FLAG_TRUNC); //clear all data after deal
	    }
	    
	    free(buf);
    }
    return nRet;
}

/* write an event to flash for next inform after reboot 
 */
int SNMPA_SaveEventsToFlash(char *szEventValue)
{
    char buf[40] = {0};  /*Eventname length + eventvalue length*/

    if(szEventValue)
    {
        int ret = 0;
        snprintf(buf, sizeof(buf), "%s\t%s\n", EVENT_PRE, szEventValue);
        ret = WriteOrigiData(OBJ_SNMPA, buf, safe_strlen(buf), FLAG_TRUNC);
        SNMPA_TRACE("Saved event of %s to flash, return: %d\n", buf, ret);
    }

    return TBS_SUCCESS;
}
void SNMPA_Send_Comm_Trap(traps_info *pstTraps)
{
    netsnmp_variable_list *vars = NULL;
    
    SNMPA_TRACE("Come in SNMPA_Send_Comm_Trap.........%s\n", pstTraps->trap_msg);
    
    ZTE_AddTrapPremsg(&vars, pstTraps->trap_oid, pstTraps->trap_oid_len*sizeof(oid), pstTraps->trap_code, 2, "", pstTraps->trap_msg); 
    send_v2trap(vars);
    snmp_free_varbind(vars);
}

/*
*ʵ:/etc/init.c/private.rcÿοжִֻһΣԣprivate.rc
*дļ/var/snmp/snmp_coldStart_tagsnmpdжsnmp_coldStart_tagļΪ1
*ϢsnmpdڷϢ󣬰snmp_coldStart_tagΪ0
*ͳɹ
*/
#define COLDSTAR 2
#define WARM_START 1
#define COLD_START_TAG_FILE_PATH "/var/snmp"
#define COLD_START_TAG_FILE_PATHNAME "/var/snmp/snmp_coldStart_tag"
#define INDEX_ColdStart 0
void SNMPA_Send_ColdStart_Trap()
{
#if 0
    if(g_isColdStartTrapSent < 2||g_isWarmStartTrapSent<2)
    {
       /*
     /var/run/bootmode Ϊ1
     /var/run/bootmode Ϊ2
     ļ/var/run/bootmode ڣ
    */
        int Which_Trap = 0;
        FILE *bootfp = fopen("/var/run/bootmode", "r");
        if(!bootfp) Which_Trap = COLDSTAR;
        else 
        {
            char szLine[8] = {0};
            if(fgets(szLine, sizeof(szLine), bootfp))
            {
                Which_Trap = safe_atoi(szLine);
                printf("Which_Trap = %d \n",Which_Trap);
            }
        }

        if(Which_Trap == COLDSTAR)
        {
            g_isColdStartTrapSent ++;
            g_isWarmStartTrapSent ++;
            SNMPA_Send_Comm_Trap(&traps_message[INDEX_ColdStart]);
        }
        else  if(Which_Trap == WARM_START)
        {
            g_isWarmStartTrapSent ++;
            g_isColdStartTrapSent ++;
            SNMPA_Send_Comm_Trap(&traps_message[INDEX_WARMStart]);
        }
    }
#else

    //Ϊصٿ
    //ļڣΪ,Ϊ1Ϣ
    //Ż:´ʽÿζҪļж
    //ļĴǷϢȽϺá
    //˵ķ֪᲻øļ
    //ֻ
    char cmd[128] = {0};
    int iColdStartTag = 0;
    FILE *fTagFile = fopen(COLD_START_TAG_FILE_PATHNAME, "r");
    if (!fTagFile)
    {        
        //Ϣ
        SNMPA_Send_Comm_Trap(&traps_message[INDEX_ColdStart]);

        sprintf(cmd, "mkdir -p %s",  COLD_START_TAG_FILE_PATH);
        system(cmd);

        sprintf(cmd, "echo 0 > %s", COLD_START_TAG_FILE_PATHNAME);
        system(cmd);
    }
    else
    {
        char szLine[8] = {0};
        fgets(szLine, sizeof(szLine), fTagFile);
        fclose(fTagFile);

        iColdStartTag = safe_atoi(szLine);
        if ( 1 == iColdStartTag )
        {
            //Ϣ
            SNMPA_Send_Comm_Trap(&traps_message[INDEX_ColdStart]);

            //޸coldStart tag
            char cmd[128] = {0};
            sprintf(cmd, "echo 0 > %s", COLD_START_TAG_FILE_PATHNAME);
            system(cmd);
        }
    }
    
#endif
    return;
}
