#!/bin/bash

UBOOT_BASE_VERSION=1.1.6
UBOOT_MAJOR_VERSION=0.04
UBOOT_MINOR_VERSION=0

CONFIGS='tsavo530 tsavo515 tsavo515_nor megamombasa515 ipots48-800 malindi'
#CONFIGS='supermombasa910 matisse'

DIFF_FILES_DIRS='Makefile drivers net board/mindspeed cpu/arm920t include/configs include/asm-arm/arch-comcerto'
#DIFF_FILES_DIRS='Makefile drivers net board/mindspeed cpu/arm1136 include/configs include/asm-arm/arch-comcerto'

CVS_USER=rui.sousa

UBOOT_CVS_TAG=u-boot_`echo ${UBOOT_MAJOR_VERSION} | sed s/\\\./_/g -`_${UBOOT_MINOR_VERSION}
UBOOT_BASE_CVS_TAG=u-boot_`echo ${UBOOT_BASE_VERSION} | sed s/\\\./_/g -`
UBOOT_VERSION=${UBOOT_BASE_VERSION}-${UBOOT_MAJOR_VERSION}.${UBOOT_MINOR_VERSION}
UBOOT_PACKAGE=u-boot-${UBOOT_VERSION}

UBOOT_CVS_DIR=u-boot-${UBOOT_CVS_TAG}-cvs
CVS_ROOT=/prj/msacvs/enterprise
CVS_REPOSITORY=u-boot
CVS_SERVER=cvshost.nb-engr.mindspeed.com
KERNEL_FTP_DIR=platform_group/enterprise/u-boot/releases/${UBOOT_MAJOR_VERSION}

FTP_SERVER=ftp://sophial1.nice.mindspeed.com
FTP_USER=user
FTP_PASSWD='123456'

TOOLCHAIN_PATH=/usr/local/gcc-3.4.5-glibc-2.3.6/arm-softfloat-linux-gnu/bin

set -e

TOP_DIR=`pwd`

export PATH=$PATH:$TOOLCHAIN_PATH

echo "Retrieving u-boot ${UBOOT_VERSION} from CVS (tag ${UBOOT_CVS_TAG})"

rm -fr $UBOOT_CVS_DIR
cvs -z6 -d:pserver:${CVS_USER}@${CVS_SERVER}:${CVS_ROOT} co -d ${UBOOT_CVS_DIR} -r ${UBOOT_CVS_TAG} ${CVS_REPOSITORY} > make_release.log 2>&1

rm -f ${UBOOT_PACKAGE}.md5sum

for config in $CONFIGS; do

	cd ${TOP_DIR}/${UBOOT_CVS_DIR}
	echo "Cleaning u-boot source"
	make distclean >> ${TOP_DIR}/make_release.log 2>&1

	echo "Configuring for ${config}"
	make ${config}_config >> ${TOP_DIR}/make_release.log 2>&1

	echo "Building binary"
	make >> ${TOP_DIR}/make_release.log 2>&1

	cd ${TOP_DIR}

	extra=`echo ${config}`

	package=${UBOOT_PACKAGE}${extra}.bin
	echo "Preparing ${package}"
	rm -f ${package}
	cp ${UBOOT_CVS_DIR}/u-boot.bin ${package}
	md5sum ${package} >> ${UBOOT_PACKAGE}.md5sum 

	package=${UBOOT_PACKAGE}${extra}.elf
	echo "Preparing ${package}"
	rm -f ${package}
	cp ${UBOOT_CVS_DIR}/u-boot ${package}
	md5sum ${package} >> ${UBOOT_PACKAGE}.md5sum 

done

cd ${TOP_DIR}
package=${UBOOT_PACKAGE}.patch.bz2
echo "Preparing ${package}"
rm -fr ${package} 
cd ${TOP_DIR}/${UBOOT_CVS_DIR}
set +e
cvs -z6 diff -uN -r ${UBOOT_BASE_CVS_TAG} ${DIFF_FILES_DIRS} > ${TOP_DIR}/${UBOOT_PACKAGE}.patch 2>> ${TOP_DIR}/make_release.log
set -e
cd ${TOP_DIR} 
bzip2 -9 ${UBOOT_PACKAGE}.patch
md5sum ${package} >> ${UBOOT_PACKAGE}.md5sum

echo "Preparing ${UBOOT_PACKAGE}.tar.bz2"
rm -fr $UBOOT_PACKAGE
cp -a $UBOOT_CVS_DIR $UBOOT_PACKAGE
cd $UBOOT_PACKAGE
rm -fr `find ./ -name CVS`
make distclean >> ${TOP_DIR}/make_release.log 2>&1

cd ${TOP_DIR}
rm -f ${UBOOT_PACKAGE}.tar.bz2
tar -vcjf ${UBOOT_PACKAGE}.tar.bz2 $UBOOT_PACKAGE >> ${TOP_DIR}/make_release.log 2>&1
md5sum ${UBOOT_PACKAGE}.tar.bz2 >> ${UBOOT_PACKAGE}.md5sum
