/*
 * (C) Copyright 2006
 * Mindspeed Technologies, Inc. <www.mindspeed.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * High Level Configuration Options
 */
#define CONFIG_COMCERTO
#define CONFIG_COMCERTO_800			/* It's a SoC */
#define CONFIG_SUPERMOMBASA			/* on a Supermombasa Board */
#undef CONFIG_USE_IRQ				/* we don't need IRQ/FIQ stuff */

#include <asm/hardware.h>

/* Mindspeed version */
#define CONFIG_IDENT_STRING		" Mindspeed 0.05.0cvs"

/*
 * Linux boot configuration
 */
#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs */
#define CONFIG_SETUP_MEMORY_TAGS	1
//#define CONFIG_INITRD_TAG		1

#define LINUX_BOOTPARAM_ADDR		0x01000100

/*
 * Initial stack configuration
 */
#define CFG_INIT_RAM_ADDR		IRAM_BASEADDR
#define CFG_INIT_SP_OFFSET		0x1000


/*
 * Malloc/stack configuration
 */
#define CFG_MALLOC_LEN			(CFG_ENV_SIZE + 128 * 1024)
#define CFG_GBL_DATA_SIZE		128	/* size in bytes reserved for initial data */

#define CONFIG_STACKSIZE		(32 * 1024)	/* regular stack */


/*
 * SDRAM configuration
 */
#define CONFIG_NR_DRAM_BANKS		1
#define PHYS_SDRAM			0x00000000
#define PHYS_SDRAM_SIZE			0x08000000	/* 128 MiB */


/*
 * Hardware drivers
 */

/*
 * UART configuration
 */
/* define one of these to choose the UART0 or UART1 as console */
#define CONFIG_UART0
#undef CONFIG_UART1

#define CONFIG_BAUDRATE		115200
#define CFG_BAUDRATE_TABLE	{115200, 19200, 38400, 57600, 9600}


/*
 * EMAC driver
 */
#define CONFIG_COMCERTO_EMAC
#define CONFIG_EMAC0
#define CONFIG_EMAC0_MII_MODE		EMAC_RMII_SMII_MODE
#define CONFIG_EMAC0_PHYCTRLDIS		1

#undef CONFIG_EMAC1
#define CONFIG_EMAC1_MII_MODE		EMAC_RMII_SMII_MODE
#define CONFIG_EMAC1_PHYCTRLDIS		1

/*
 * MDIO driver
 */
#define CONFIG_MII
#define CFG_FAULT_ECHO_LINK_DOWN
#define CONFIG_EMAC0_MDCLOCK		2500000
#define CONFIG_EMAC0_PHY_ADDR		0x0

#define CONFIG_EMAC1_MDCLOCK		2500000
#define CONFIG_EMAC1_PHY_ADDR		0x0

/*
 * SPI driver
 */
#define CONFIG_SPI				/* define to enable SPI using */

#define CFG_SPI_CLOCK_POLARITY		1		/* Inactive state of serial clock is high */
#define CFG_SPI_CLOCK_PHASE		1		/* Serial Clock toggles at the start of the first data bit */
#define CFG_SPI_FRAMESIZE 		8		/* define the SPI frame size in bits. 8-bit supported only */

#define CFG_SPI_CLOCK_SPEED		4000000		/* the SPI speed in Hz */


/*
 * Shell configuration
 */
#include <cmd_confdefs.h>

#define CONFIG_COMMANDS			(CONFIG_CMD_DFL | CFG_CMD_MII |CFG_CMD_JFFS2 |CFG_CMD_PING)

#define	CFG_LONGHELP					/* undef to save memory		*/
#define CFG_PROMPT		"Comcerto-800 > "	/* Monitor Command Prompt */
#define CFG_CBSIZE		256			/* Console I/O Buffer Size */
#define CFG_MAXARGS		16			/* max number of command args */
#define CFG_PBSIZE		(CFG_CBSIZE + sizeof(CFG_PROMPT) + 16)	/* Print Buffer Size */

#define CONFIG_ETHADDR		00:aa:bb:cc:dd:ee
#define CONFIG_ETH1ADDR         00:aa:bb:cc:dd:ff
#define CONFIG_IPADDR		192.168.0.2
#define CONFIG_SERVERIP		192.168.0.3
#define CONFIG_GATEWAYIP	192.168.0.1
#define CONFIG_NETMASK		255.255.255.0
#define CONFIG_BOOTDELAY		3

#define CFG_LOAD_ADDR			0x1000000	/* default load address */


#define CFG_MEMTEST_START	CFG_LOAD_ADDR		/* memtest works on */
#define CFG_MEMTEST_END		(CFG_MEMTEST_START + 0x800000)

#define BOARD_LATE_INIT
#define MSP_BOTTOM_MEMORY_RESERVED_SIZE	0x1000000	/* 16 MiB reserved for MSP */

/*
 * Network Configuration
 */
#define CONFIG_NET_RETRY_COUNT		5

/*
 * Flash Configuration
 */
#define CFG_FLASH_AM040_DRIVER				/* enable AM040 flash driver */
//#undef CFG_FLASH_AM040_DRIVER				/* disable AM040 flash driver */

//#define CFG_FLASH_AMLV640U_DRIVER			/* enable AMLV640U flash driver */
#undef CFG_FLASH_AMLV640U_DRIVER			/* disable AMLV640U flash driver */
#define CFG_FLASH_AMLV640U_SIZE		0x400000	/* (Acessible) Size of the AMLV640U flash device */

#define CFG_FLASH_CFI_DRIVER			/* enable CFI driver */
//#undef CFG_FLASH_CFI_DRIVER			/* disable CFI driver */

#define CFG_MAX_FLASH_SECT		128	/* max # of sectors on one chip */
//#define CFG_FLASH_PROTECTION

#define PHYS_FLASH2			0x80000000	/* Flash Bank #2 */

#define PHYS_FLASH1			EXP_CSBOOT_BASEADDR	/* Flash Bank #1 */
#define PHYS_FLASH1_SECT_SIZE		0x00010000	/* 64 KiB sectors */

#define CFG_MAX_FLASH_BANKS		2	/* max num of flash banks */
#define CFG_FLASH_BANKS_LIST		{PHYS_FLASH1, PHYS_FLASH2}

#define CFG_FLASH_ERASE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Write */

/*
 * CFI driver 
 */
#if defined(CFG_FLASH_CFI_DRIVER)
#define CFG_FLASH_CFI				/* flash is CFI conformant      */
#define CFG_FLASH_USE_BUFFER_WRITE		/* use buffered writes (20x faster) */
#define CFG_FLASH_QUIET_TEST

/*
 * Monitor configuration
 */
#define CFG_MONITOR_BASE        	PHYS_FLASH1
#define CFG_MONITOR_LEN         	(3 * PHYS_FLASH1_SECT_SIZE)	/* Reserve 64 KiB for Monitor */

#endif


/*
 * Enviroment in flash
 */
#define CFG_ENV_IS_IN_FLASH

#if defined(CFG_ENV_IS_IN_FLASH)
#define CFG_ENV_ADDR			(PHYS_FLASH1 + 3 * PHYS_FLASH1_SECT_SIZE)	/* Keep 3 sectors for U-boot image */
#define CFG_ENV_SECT_SIZE		PHYS_FLASH1_SECT_SIZE
//#define CFG_ENV_ADDR_REDUND		(CFG_ENV_ADDR + CFG_ENV_SECT_SIZE)
#endif

#define CFG_ENV_SIZE			0x4000	/* Total Size of Environment 16KiB */

#define CONFIG_ENV_OVERWRITE

/*
 * NAND Configuration
 */
#if (CONFIG_COMMANDS & CFG_CMD_NAND)
#define CFG_NAND_BASE			EXP_CSP0_BASEADDR
#define CFG_MAX_NAND_DEVICE		1
#define NAND_MAX_CHIPS			1
#define CONFIG_JFFS2_NAND

#endif

/* NAND GPIOs config */
#define CFG_NAND_BR_GPIO	1
#define CFG_NAND_CE_GPIO	3
#define CFG_NAND_CLE_GPIO	4
#define CFG_NAND_ALE_GPIO	5


/*
 * JFFS2 Configuration
 */
/* mtdparts command line support */
#define CONFIG_JFFS2_CMDLINE
#define MTDIDS_DEFAULT		"nor0=Amd-eeprom,nor1=Spansion-flash"
#define MTDPARTS_DEFAULT	"mtdparts=Spansion-flash:512k(u-boot),512k(env),7m(fs)"

#define CFG_REFCLKFREQ		12000000	/* 12 MHz */

#define CFG_HZ			1000
#define CFG_HZ_CLOCK		132000000	/* 132 MHz */


#ifdef CONFIG_USE_IRQ
#error CONFIG_USE_IRQ not supported
#endif

#endif /* __CONFIG_H */
