/*
 * Copyright (C) 2006 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * High Level Configuration Options
 */
#define CONFIG_COMCERTO		1
#define CONFIG_ARM1136 		1	/* This is an arm1136j-s CPU core */
#define CONFIG_COMCERTO_1000	1	/* It's an  SoC */
#define CONFIG_BOARD_C1KASIC	1
#undef  CONFIG_USE_IRQ		/* we don't need IRQ/FIQ stuff  */

#include <asm/hardware.h>

/* Mindspeed version */
#define CONFIG_IDENT_STRING	" Mindspeed $Name: u-boot_3_00_4 $"

/*
 * Linux boot configuration
 */

#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs      */
#define CONFIG_SETUP_MEMORY_TAGS	1
//#define CONFIG_INITRD_TAG		1

#define LINUX_BOOTPARAM_ADDR		(PHYS_SDRAM + MSP_BOTTOM_MEMORY_RESERVED_SIZE + 0x100)

/*
 *	Relocation options
 */
//#define CONFIG_SKIP_RELOCATE_UBOOT
//#define CONFIG_SKIP_LOWLEVEL_INIT

/*
 * RAM configuration
 */

/*
 * Memory Mapping
 */

#define CONFIG_NR_DRAM_BANKS	1
#define PHYS_SDRAM		DDR_BASEADDR
#define PHYS_SDRAM_SIZE		(512 * 1024 * 1024)

/*
 * Hardware drivers
 */

/*
 * UART configuration
 */  
/* define one of these to choose the UART0 or UART1 as console */
#define CONFIG_UART0		1
#define CONFIG_BAUDRATE		115200
#define CFG_BAUDRATE_TABLE	{115200, 19200, 38400, 57600, 9600}

/*
 * Emac Settings
 */
#define CONFIG_COMCERTO_GEMAC	1

// GEMAC mode configured by bootstrap pins or SW
//#undef CONFIG_COMCERTO_MII_CFG_BOOTSTRAP
#define CONFIG_COMCERTO_MII_CFG_BOOTSTRAP

#define GEMAC0_PHY_ADDR		0
#define GEMAC0_CONFIG		CONFIG_COMCERTO_USE_RGMII
#define GEMAC0_MODE		(GEMAC_SW_CONF | GEMAC_SW_FULL_DUPLEX | GEMAC_SW_SPEED_1G)
#define GEMAC0_PHY_FLAGS	GEMAC_PHY_AUTONEG
#define GEMAC0_PHYIDX		0

#define GEMAC1_PHY_ADDR		8
#define GEMAC1_CONFIG		CONFIG_COMCERTO_USE_RGMII
#define GEMAC1_MODE		(GEMAC_SW_CONF | GEMAC_SW_FULL_DUPLEX | GEMAC_SW_SPEED_1G)
#define GEMAC1_PHY_FLAGS	GEMAC_PHY_AUTONEG
#define GEMAC1_PHYIDX		0

#define CONFIG_NET_MULTI	1

/*
 * Shell configuration
 */
#define CONFIG_COMMANDS		(CFG_CMD_FLASH | CFG_CMD_ENV | CFG_CMD_MEMORY | CFG_CMD_MEMTEST | CFG_CMD_MII | CFG_CMD_RUN | CFG_CMD_NET | /*CFG_CMD_NAND |*/ CFG_CMD_JFFS2 |  CFG_CMD_PING | CFG_CMD_NFS | CFG_CMD_I2C | CFG_CMD_EEPROM | CFG_CMD_ELF/*| CFG_CMD_SPI*/)

#define	CFG_LONGHELP					/* undef to save memory		*/
#define CFG_PROMPT		"Comcerto-1000 > "	/* Monitor Command Prompt */
#define CFG_CBSIZE		256			/* Console I/O Buffer Size */
#define CFG_MAXARGS		16			/* max number of command args */
#define CFG_PBSIZE		(CFG_CBSIZE + sizeof(CFG_PROMPT) + 16)	/* Print Buffer Size */

/*
 * User Interface
 */
#define	CONFIG_EXTRA_ENV_SETTINGS				\
	"hostname=comcerto1000\0"						\
	"netdev=eth0\0"									\
	"nfsargs=setenv bootargs init=${init_process} root=/dev/nfs rw "		\
		"nfsroot=${serverip}:${rootpath}\0"				\
	"flashargs=setenv bootargs init=${init_process} root=/dev/mtdblock2 rootfstype=${rootfstype} rw\0"	\
	"rootfstype=jffs2\0" \
	"init_process=/etc/preinit\0" \
	"addip=setenv bootargs ${bootargs} "				\
		"ip=${ipaddr}:${serverip}:${gatewayip}:${netmask}"	\
		":${hostname}:${netdev}:off\0" \
	"addeth=setenv bootargs ${bootargs} " \
	"hwaddress=${netdev},${ethaddr}\0" \
	"addtty=setenv bootargs ${bootargs} console=ttyS0,${baudrate}\0" \
	"addmtd=setenv bootargs ${bootargs} ${mtdparts}\0" \
	"flash_self=run flashargs addip addtty;"		\
		"bootm ${kernel_addr}\0"				\
	"boot_nfs=nfs 80600000 ${rootpath}/boot/${kernelfile};run nfsargs addeth addip addtty;"     \
	        "bootm 80600000\0"						\
	"boot_flash=run flashargs addeth addtty addmtd; fsload /boot/uImage; bootm\0" \
	"rootpath=/devel/fs-c1kasic\0" \
	"kernelfile=uImage\0" \
	"mtdids=" MTDIDS_DEFAULT "\0" \
	"mtdparts=" MTDPARTS_DEFAULT "\0" \
	"partition=" MTDPARTITION_DEFAULT "\0" \
	"mtddevnum=2\0" \
	"mtddevname=fs\0" \
	"fsfile=root.jffs2-128k\0" \
	"updatenandfs=tftp 81000000 ${fsfile};nand erase 60000 880000;nand write 81000000 60000 880000\0" \
 	"updatefs=tftp 81000000 ${fsfile};protect off 1:3-127\;erase 1:3-127;cp.b 81000000 20060000 ${filesize}\0" \
	"updateboot=tftp 81000000 u-boot.bin;protect off 1:0-1\;erase 1:0-1;cp.b 81000000 20000000 ${filesize}\0" \
	""

#define CONFIG_ETHADDR		00:aa:bb:cc:dd:ee
#define CONFIG_IPADDR		192.168.0.2
#define CONFIG_SERVERIP		192.168.0.1
#define CONFIG_BOOTDELAY	3

#include <cmd_confdefs.h>

#define CFG_LOAD_ADDR		(PHYS_SDRAM + 0x01000000)	/* default load address */

#define CFG_MEMTEST_START	CFG_LOAD_ADDR	/* memtest works on */
#define CFG_MEMTEST_END		(CFG_MEMTEST_START + 0x800000)

#define BOARD_LATE_INIT
#define MSP_BOTTOM_MEMORY_RESERVED_SIZE	0x800000	/* 8 MiB reserved for MSP */
#define MSP_TOP_MEMORY_RESERVED_SIZE	0x0		/* 0 MiB reserved for MSP */


/*
 * Network Configuration
 */
#define CONFIG_NET_RETRY_COUNT		5

/*
 * Flash Configuration - Using CFI driver 
 */
#define CFG_FLASH_AM040_DRIVER	1		/* enable AM040 flash driver */
//#undef CFG_FLASH_AM040_DRIVER				/* disable AM040 flash driver */

//#define CFG_FLASH_AMLV640U_DRIVER	1		/* enable AMLV640U flash driver */
#undef CFG_FLASH_AMLV640U_DRIVER			/* disable AMLV640U flash driver */
//#define CFG_FLASH_AMLV640U_SIZE	0x400000	/* (Acessible) Size of the AMLV640U flash device */

#define CFG_FLASH_CFI_DRIVER		1	/* enable CFI driver */
//#undef CFG_FLASH_CFI_DRIVER			/* disable CFI driver */

#define CFG_MAX_FLASH_SECT		256	/* max # of sectors on one chip */
#undef CFG_FLASH_PROTECTION

#define PHYS_FLASH1			EXP_CS0_BASEADDR	/* Flash Bank #1 */
#define PHYS_FLASH1_SECT_SIZE		0x00020000	/* 128 KiB sectors */

#define CFG_MAX_FLASH_BANKS		1       /* max num of flash banks */
#define CFG_FLASH_BANKS_LIST		{ PHYS_FLASH1 }

#define CFG_FLASH_ERASE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Write */

/*
 * CFI driver 
 */
#if defined(CFG_FLASH_CFI_DRIVER)
#define CFG_FLASH_CFI			1	/* flash is CFI conformant      */
#define CFG_FLASH_USE_BUFFER_WRITE	1	/* use buffered writes (20x faster) */
#define CFG_FLASH_QUIET_TEST
#undef CFG_FLASH_COMPLEX_MAPPINGS
// #define CFG_FLASH_COMPLEX_MAPPINGS

/*
 * Monitor configuration
 */
#define CFG_MONITOR_BASE        PHYS_FLASH1
#define CFG_MONITOR_LEN         (1 * PHYS_FLASH1_SECT_SIZE)	/* Reserve 128 KiB for Monitor */

/*
 * Enviroment in flash
 */
#define CFG_ENV_IS_IN_FLASH	1
#define CFG_ENV_SIZE          0x4000  /* Total Size of Environment 16KiB */
#endif

/*
 * I2C support
 */
#if defined(CFG_CMD_I2C)
#define CONFIG_HARD_I2C
#define CFG_TCLK                       CFG_HZ_CLOCK
#define CFG_I2C_SPEED                  40000
#define CFG_I2C_SLAVE                  0
#if defined(CFG_CMD_EEPROM)
#define CFG_I2C_EEPROM_ADDR            0x50
#define CFG_I2C_EEPROM_ADDR_LEN        2 /* Bytes of address */
#define CFG_EEPROM_PAGE_WRITE_BITS     6 /* max 64 byte */
#define CFG_EEPROM_PAGE_WRITE_DELAY_MS 10
#define CFG_EEPROM_PAGE_WRITE_ENABLE
#endif
#endif

#if defined(CFG_ENV_IS_IN_FLASH)
#define CFG_ENV_ADDR		(PHYS_FLASH1 + 2 * PHYS_FLASH1_SECT_SIZE)	/* Keep 2 sectors for U-boot image */
#define CFG_ENV_SECT_SIZE	PHYS_FLASH1_SECT_SIZE
//#define CFG_ENV_ADDR_REDUND	(CFG_ENV_ADDR + CFG_ENV_SECT_SIZE)
#endif

#define CONFIG_ENV_OVERWRITE	1



/*
 * NAND Configuration
 */
#if (CONFIG_COMMANDS & CFG_CMD_NAND)

#define CFG_NAND_BASE			EXP_CS4_BASEADDR
#define CFG_MAX_NAND_DEVICE		1
#define NAND_MAX_CHIPS			1
#define CONFIG_JFFS2_NAND		1

#if (CONFIG_COMMANDS & CFG_CMD_FLASH)
//TODO
#else
/*
 *EEPORM boot loader does the relocate and lowlevel init work
 */
#define CONFIG_SKIP_RELOCATE_UBOOT
#define CONFIG_SKIP_LOWLEVEL_INIT
/* Environment is in NAND */
#define CFG_ENV_IS_IN_NAND	1
#define CFG_ENV_OFFSET		0x00040000	/* Offset of Environment Sector */
#define NAND_MAX_CHIPS          1
#define CFG_ENV_SIZE		0x20000	/* Total Size of Environment 128KiB */
#endif

#endif

/* NAND GPIOs config */
#define CFG_NAND_BR_GPIO	6
#define CFG_NAND_CE_GPIO	29
#define CFG_NAND_CLE_GPIO	31
#define CFG_NAND_ALE_GPIO	30

/*
 * JFFS2 Configuration
 */
/* mtdparts command line support */
#define CONFIG_JFFS2_CMDLINE
#if (CONFIG_COMMANDS & CFG_CMD_JFFS2)
//#define CFG_JFFS2_SORT_FRAGMENTS
#endif /* CFG_CMD_JFFS2 */

#if (CONFIG_COMMANDS & CFG_CMD_NAND)
#define MTDIDS_DEFAULT		"nand0=comcertonand"
#define MTDPARTS_DEFAULT	"mtdparts=comcertonand:256k(u-boot),128k(env),16000k(fs)"
#define MTDPARTITION_DEFAULT	"nand0,2"
#define ROOT_MTDBLOCK		"/dev/mtdblock3"
#else
#define MTDIDS_DEFAULT		"nor0=comcertoflash.0"
#define MTDPARTS_DEFAULT	"mtdparts=comcertoflash.0:256k(u-boot),128k(env),16000k(fs)"
#define MTDPARTITION_DEFAULT	"nor0,2"
#define ROOT_MTDBLOCK		"/dev/mtdblock2"
#endif

#define CFG_REFCLKFREQ		24000000	/* 24 MHz */

#define CFG_HZ			1000
#define CFG_HZ_CLOCK		200000000	/* 200 MHz*/
#define CFG_ARM_CLOCK		650000000	/* 650 MHz*/
#define CFG_DDR_CLOCK		400000000	/* 400 MHz*/
#define CFG_PHY_CLOCK		125000000	/* 125 MHz*/
#define CFG_GEM0_CLOCK		 25000000	/*  25 MHz*/
#define CFG_GEM1_CLOCK		 25000000	/*  25 MHz*/

/*
 * Initial stack configuration
 */
#define CFG_INIT_RAM_ADDR	0x0A000000 /* ARAM_BASEADDR Base address */
#define CFG_INIT_RAM_END	0x00020000 /* 128K */
#define CFG_ARAM_CODE_SIZE	0x00010000 /* 64K */

#define CFG_INIT_SP_OFFSET	CFG_GBL_DATA_OFFSET - CFG_ARAM_CODE_SIZE



/*
 * Malloc/stack configuration
 */
#define CFG_MALLOC_LEN		(CFG_ENV_SIZE + 128 * 1024)
#define CFG_GBL_DATA_SIZE	128	/* size in bytes reserved for initial data */
#define CFG_GBL_DATA_OFFSET	(CFG_INIT_RAM_END - CFG_GBL_DATA_SIZE)

#define CONFIG_STACKSIZE	(32 * 1024)	/* regular stack */

#ifdef CONFIG_USE_IRQ
#error CONFIG_USE_IRQ not supported
#endif

/*
* DDR Training algorithm
*/
#define DDR_TRAINING
//#undef DDR_TRAINING

// DDR Configs

//DENALI CONFIGRATION FOR BOARD CONFIG #1
#define DENALI_CTL_00_VAL_CFG1	0x0100000101010101LL //0x0100000101010101LL
#define DENALI_CTL_01_VAL_CFG1	0x0100010001000000LL //0x0100010001000000LL
#define DENALI_CTL_02_VAL_CFG1	0x0200000000010100LL //0x0200000000010100LL
#define DENALI_CTL_03_VAL_CFG1	0x0202020202020202LL //0x0202020202020202LL
// #define DENALI_CTL_04_VAL_CFG1	0x0000010100000001LL
// Original Value
// #define DENALI_CTL_05_VAL_CFG1	0x0003010500010001LL
// Dror's modification  rtt_0=1 
#define DENALI_CTL_05_VAL_CFG1	0x0003010500010001LL
#define DENALI_CTL_06_VAL_CFG1	0x0a0a040300030300LL
#define DENALI_CTL_07_VAL_CFG1	0x000000050000020aLL
#define DENALI_CTL_08_VAL_CFG1	0x6400003f3f16020eLL
#define DENALI_CTL_09_VAL_CFG1	0x0000640064006400LL
// #define DENALI_CTL_10_VAL_CFG1	0x0120202020191a18LL
#define DENALI_CTL_11_VAL_CFG1	0x0000003300000000LL
#define DENALI_CTL_12_VAL_CFG1	0x0000000000001000LL
#define DENALI_CTL_13_VAL_CFG1	0x0010001000100010LL	
#define DENALI_CTL_14_VAL_CFG1	0x0010001000100010LL
#define DENALI_CTL_15_VAL_CFG1	0x0c2d000000000000LL
#define DENALI_CTL_16_VAL_CFG1	0x000000006d560000LL
#define DENALI_CTL_17_VAL_CFG1	0x0000010000000000LL
#define DENALI_CTL_18_VAL_CFG1	0x0600010000000000LL
#define DENALI_CTL_19_VAL_CFG1	0x00003700c8050b00LL
#define DENALI_CTL_20_VAL_CFG1	0x00000101388000c8LL
#define DENALI_CTL_21_VAL_CFG1	0x0202020100000101LL
#define DENALI_CTL_22_VAL_CFG1	0x0000020007000002LL
// #define DENALI_CTL_23_VAL_CFG1
#define DENALI_CTL_24_VAL_CFG1	0x0000000200a00000LL
#define DENALI_CTL_25_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_26_VAL_CFG1	0x9440492794404927LL
#define DENALI_CTL_27_VAL_CFG1	0x9440492794404927LL
#define DENALI_CTL_28_VAL_CFG1	0x07c0040107c00401LL
#define DENALI_CTL_29_VAL_CFG1	0x07c0040107c00401LL
#define DENALI_CTL_30_VAL_CFG1	0x0000000000000005LL
#define DENALI_CTL_31_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_32_VAL_CFG1	0x0c02000000000000LL
#define DENALI_CTL_33_VAL_CFG1	0x0000000000000004LL
#define DENALI_CTL_34_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_35_VAL_CFG1	0x0034343434050000LL
#define DENALI_CTL_36_VAL_CFG1	0x0000000000000004LL
// original settings
// #define DENALI_CTL_37_VAL_CFG1	0x0a52000000040000LL
// Dror's settings rtt=11 bit[1]=1
#define DENALI_CTL_37_VAL_CFG1	0x0a52000000440200LL
#define DENALI_CTL_38_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_39_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_40_VAL_CFG1	0x00000000000000c8LL
// #define DENALI_CTL_41_VAL_CFG1	0x00cc005000cc0050LL
#define DENALI_CTL_41_VAL_CFG1	0x0017005000170050LL
#define DENALI_CTL_42_VAL_CFG1	DENALI_CTL_41_VAL_CFG1
#define DENALI_CTL_43_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_44_VAL_CFG1	DENALI_CTL_43_VAL_CFG1
#define DENALI_CTL_45_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_46_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_47_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_48_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_49_VAL_CFG1	0x0000000000000050LL
#define DENALI_CTL_50_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_51_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_52_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_53_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_54_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_55_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_56_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_57_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_58_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_59_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_60_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_61_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_62_VAL_CFG1	0x0000000000000000LL
// #define DENALI_CTL_63_VAL_CFG1	0x0000000000000000LL
// #define DENALI_CTL_64_VAL_CFG1	0x0000000000000000LL
// #define DENALI_CTL_65_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_66_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_67_VAL_CFG1	0x0000000000000000LL
#define DENALI_CTL_68_VAL_CFG1	0x000000000a000000LL
#define DENALI_CTL_69_VAL_CFG1	0x00000003e8050000LL

//DENALI CONFIGRATION FOR BOARD CONFIG #2
#define DENALI_CTL_00_VAL_CFG2	0x0100000101010101LL
#define DENALI_CTL_01_VAL_CFG2	0x0100010001000000LL
#define DENALI_CTL_02_VAL_CFG2	0x0200000000010100LL
#define DENALI_CTL_03_VAL_CFG2	0x0202020202020202LL
// #define DENALI_CTL_04_VAL_CFG2	0x0000010100000001LL
// original settings
// #define DENALI_CTL_05_VAL_CFG2	0x0003010500010001LL
// Dror's settings rtt_0=1
#define DENALI_CTL_05_VAL_CFG2	0x0003010300010001LL
// original settings
// #define DENALI_CTL_06_VAL_CFG2	0x0a0a040300030300LL
// Dror's settings
#define DENALI_CTL_06_VAL_CFG2	0x060a020200020200LL
// original settings
// #define DENALI_CTL_07_VAL_CFG2	0x000000050000020aLL
// Dror's settings
#define DENALI_CTL_07_VAL_CFG2	0x0000000300000205LL
// original settings
// #define DENALI_CTL_08_VAL_CFG2	0x6400003f3f16020eLL
// Dror's settings
#define DENALI_CTL_08_VAL_CFG2	0x6400003f3f0b0207LL
#define DENALI_CTL_09_VAL_CFG2	0x0000640064006400LL
// #define DENALI_CTL_10_VAL_CFG2	0x0120202020191a18LL
// original settings
// #define DENALI_CTL_11_VAL_CFG2	0x0000003300000000LL
// Dror's settings
#define DENALI_CTL_11_VAL_CFG2	0x0000001a00000000LL
// original settings
// #define DENALI_CTL_12_VAL_CFG2	0x0000000000001000LL
// Dror's settings
#define DENALI_CTL_12_VAL_CFG2	0x0000000000000800LL
#define DENALI_CTL_13_VAL_CFG2	0x0010001000100010LL	
#define DENALI_CTL_14_VAL_CFG2	0x0010001000100010LL
// original settings
// #define DENALI_CTL_15_VAL_CFG2	0x0c2d000000000000LL
// Dror's settings
#define DENALI_CTL_15_VAL_CFG2	0x0612000000000000LL
// original settings
// #define DENALI_CTL_16_VAL_CFG2	0x000000006d560000LL
// Dror's settings
#define DENALI_CTL_16_VAL_CFG2	0x0000000036a60000LL
#define DENALI_CTL_17_VAL_CFG2	0x0000010000000000LL
// original settings
// #define DENALI_CTL_18_VAL_CFG2	0x0600010000000000LL
// Dror's settings
#define DENALI_CTL_18_VAL_CFG2	0x0300010000000000LL
// original settings
// #define DENALI_CTL_19_VAL_CFG2	0x00003700c8050b00LL
// Dror's settings
#define DENALI_CTL_19_VAL_CFG2	0x00001c00c8030600LL
// original settings
// #define DENALI_CTL_20_VAL_CFG2	0x00000101388000c8LL
// Dror's settings
#define DENALI_CTL_20_VAL_CFG2	0x000001009c4000c8LL
/* Original settings, AHB/DDR synchronous */
#define DENALI_CTL_21_VAL_CFG2	0x0303030100000101LL
#define DENALI_CTL_22_VAL_CFG2	0x0000020006000003LL
/* AHB/DDR asynchronous */
//#define DENALI_CTL_21_VAL_CFG2	0x0000000100000101LL
//#define DENALI_CTL_22_VAL_CFG2	0x0000020006000000LL
// #define DENALI_CTL_23_VAL_CFG2
// original settings
// #define DENALI_CTL_24_VAL_CFG2	0x0000000200a00000LL
// Dror's settings
#define DENALI_CTL_24_VAL_CFG2	0x0000000200500000LL
#define DENALI_CTL_25_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_26_VAL_CFG2	0x9340492793404927LL
#define DENALI_CTL_27_VAL_CFG2	0x9340492793404927LL
#define DENALI_CTL_28_VAL_CFG2	0x07c0040107c00401LL
#define DENALI_CTL_29_VAL_CFG2	0x07c0040107c00401LL
#define DENALI_CTL_30_VAL_CFG2	0x0000000000000004LL
#define DENALI_CTL_31_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_32_VAL_CFG2	0x0c02000000000000LL
#define DENALI_CTL_33_VAL_CFG2	0x0000000000000004LL
#define DENALI_CTL_34_VAL_CFG2	0x0000000000000000LL
// original settings
// #define DENALI_CTL_35_VAL_CFG2	0x0034343434050000LL
// Dror's settings
#define DENALI_CTL_35_VAL_CFG2	0x0074747474030000LL
#define DENALI_CTL_36_VAL_CFG2	0x0000000000000004LL
// original settings
// #define DENALI_CTL_37_VAL_CFG2	0x0a52000000040000LL
// Dror's settings rtt=11 bit[1]=1
#define DENALI_CTL_37_VAL_CFG2	0x0432000000040200LL
#define DENALI_CTL_38_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_39_VAL_CFG2	0x0000000000000000LL
// original settings
// #define DENALI_CTL_40_VAL_CFG2	0x00000000000000c8LL
// Dror's settings
#define DENALI_CTL_40_VAL_CFG2	0x0000000000000064LL
// #define DENALI_CTL_41_VAL_CFG2	0x00cc005000cc0050LL
// original settings
// #define DENALI_CTL_41_VAL_CFG2	0x0017005000170050LL
// Dror's settings adj1 = 0x28 
#define DENALI_CTL_41_VAL_CFG2	0x0028009000280090LL
#define DENALI_CTL_42_VAL_CFG2	DENALI_CTL_41_VAL_CFG2
#define DENALI_CTL_43_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_44_VAL_CFG2	DENALI_CTL_43_VAL_CFG2
#define DENALI_CTL_45_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_46_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_47_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_48_VAL_CFG2	0x0000000000000000LL
// original settings
// #define DENALI_CTL_49_VAL_CFG2	0x0000000000000050LL
// Dror's settings
#define DENALI_CTL_49_VAL_CFG2	0x0000000000000028LL
#define DENALI_CTL_50_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_51_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_52_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_53_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_54_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_55_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_56_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_57_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_58_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_59_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_60_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_61_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_62_VAL_CFG2	0x0000000000000000LL
// #define DENALI_CTL_63_VAL_CFG2	0x0000000000000000LL
// #define DENALI_CTL_64_VAL_CFG2	0x0000000000000000LL
// #define DENALI_CTL_65_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_66_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_67_VAL_CFG2	0x0000000000000000LL
#define DENALI_CTL_68_VAL_CFG2	0x000000000a000000LL
#define DENALI_CTL_69_VAL_CFG2	0x00000003e8050000LL

//DENALI CONFIGRATION FOR BOARD CONFIG #3
#define DENALI_CTL_00_VAL_CFG3	0x0100000101010101LL
#define DENALI_CTL_01_VAL_CFG3	0x0100010001000000LL
#define DENALI_CTL_02_VAL_CFG3	0x0200000000010100LL
#define DENALI_CTL_03_VAL_CFG3	0x0202020202020202LL
// #define DENALI_CTL_04_VAL_CFG3	0x0000010100000001LL
#define DENALI_CTL_05_VAL_CFG3	0x0003010500010001LL
#define DENALI_CTL_06_VAL_CFG3	0x0a0a040300030300LL
#define DENALI_CTL_07_VAL_CFG3	0x000000050000020aLL
#define DENALI_CTL_08_VAL_CFG3	0x6400003f3f15020eLL
#define DENALI_CTL_09_VAL_CFG3	0x0000640064006400LL
// #define DENALI_CTL_10_VAL_CFG3	0x0120202020191a18LL
#define DENALI_CTL_11_VAL_CFG3	0x0000003000000000LL
#define DENALI_CTL_12_VAL_CFG3	0x0000000000000f00LL
#define DENALI_CTL_13_VAL_CFG3	0x0010001000100010LL	
#define DENALI_CTL_14_VAL_CFG3	0x0010001000100010LL
#define DENALI_CTL_15_VAL_CFG3	0x0b50000000000000LL
#define DENALI_CTL_16_VAL_CFG3	0x00000000659d0000LL
#define DENALI_CTL_17_VAL_CFG3	0x0000010000000000LL
#define DENALI_CTL_18_VAL_CFG3	0x0600010000000000LL
#define DENALI_CTL_19_VAL_CFG3	0x00003400c8050b00LL
#define DENALI_CTL_20_VAL_CFG3	0x00000101226e00c8LL
/* Original settings, AHB/DDR synchronous */
#define DENALI_CTL_21_VAL_CFG3	0x0202020100000101LL
#define DENALI_CTL_22_VAL_CFG3	0x0000020007000002LL
/* AHB/DDR asynchronous */
//#define DENALI_CTL_21_VAL_CFG3	0x0000000100000101LL
//#define DENALI_CTL_22_VAL_CFG3	0x0000020007000000LL
// #define DENALI_CTL_23_VAL_CFG3
#define DENALI_CTL_24_VAL_CFG3	0x0000000200950000LL
#define DENALI_CTL_25_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_26_VAL_CFG3	0x9440492794404927LL
#define DENALI_CTL_27_VAL_CFG3	0x9440492794404927LL
#define DENALI_CTL_28_VAL_CFG3	0x07c0040107c00401LL
#define DENALI_CTL_29_VAL_CFG3	0x07c0040107c00401LL
#define DENALI_CTL_30_VAL_CFG3	0x0000000000000005LL
#define DENALI_CTL_31_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_32_VAL_CFG3	0x0c02000000000000LL
#define DENALI_CTL_33_VAL_CFG3	0x0000000000000004LL
#define DENALI_CTL_34_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_35_VAL_CFG3	0x0034343434050000LL
#define DENALI_CTL_36_VAL_CFG3	0x0000000000000004LL
#define DENALI_CTL_37_VAL_CFG3	0x0a52000000040200LL
#define DENALI_CTL_38_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_39_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_40_VAL_CFG3	0x00000000000000baLL
// #define DENALI_CTL_41_VAL_CFG3	0x00cc005000cc0050LL
#define DENALI_CTL_41_VAL_CFG3	0x00cc005000cc0050LL
#define DENALI_CTL_42_VAL_CFG3	DENALI_CTL_41_VAL_CFG3
#define DENALI_CTL_43_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_44_VAL_CFG3	DENALI_CTL_43_VAL_CFG3
#define DENALI_CTL_45_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_46_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_47_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_48_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_49_VAL_CFG3	0x000000000000004bLL
#define DENALI_CTL_50_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_51_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_52_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_53_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_54_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_55_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_56_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_57_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_58_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_59_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_60_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_61_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_62_VAL_CFG3	0x0000000000000000LL
// #define DENALI_CTL_63_VAL_CFG3	0x0000000000000000LL
// #define DENALI_CTL_64_VAL_CFG3	0x0000000000000000LL
// #define DENALI_CTL_65_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_66_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_67_VAL_CFG3	0x0000000000000000LL
#define DENALI_CTL_68_VAL_CFG3	0x000000000a000000LL
#define DENALI_CTL_69_VAL_CFG3	0x00000003e8050000LL

//DENALI CONFIGRATION FOR BOARD CONFIG #4
#define DENALI_CTL_00_VAL_CFG4	0x0100000101010101LL
#define DENALI_CTL_01_VAL_CFG4	0x0100010001000000LL
#define DENALI_CTL_02_VAL_CFG4	0x0200000000010100LL
#define DENALI_CTL_03_VAL_CFG4	0x0202020202020202LL
// #define DENALI_CTL_04_VAL_CFG4	0x0000010100000001LL
#define DENALI_CTL_05_VAL_CFG4	0x0003010500010001LL
#define DENALI_CTL_06_VAL_CFG4	0x0a0a040300030300LL
#define DENALI_CTL_07_VAL_CFG4	0x000000050000020aLL
#define DENALI_CTL_08_VAL_CFG4	0x6400003f3f12020cLL
#define DENALI_CTL_09_VAL_CFG4	0x0000640064006400LL
// #define DENALI_CTL_10_VAL_CFG4	0x0120202020191a18LL
#define DENALI_CTL_11_VAL_CFG4	0x0000002a00000000LL
#define DENALI_CTL_12_VAL_CFG4	0x0000000000001000LL
#define DENALI_CTL_13_VAL_CFG4	0x0010001000100010LL	
#define DENALI_CTL_14_VAL_CFG4	0x0010001000100010LL
#define DENALI_CTL_15_VAL_CFG4	0x09e0000000000000LL
#define DENALI_CTL_16_VAL_CFG4	0x0000000058be0000LL
#define DENALI_CTL_17_VAL_CFG4	0x0000010000000000LL
#define DENALI_CTL_18_VAL_CFG4	0x0500010000000000LL
#define DENALI_CTL_19_VAL_CFG4	0x00002d00c8050a00LL
#define DENALI_CTL_20_VAL_CFG4	0x00000100fda000c8LL
/* Original settings, pseudo synchronous */
//#define DENALI_CTL_21_VAL_CFG4	0x0202020100000101LL
//#define DENALI_CTL_22_VAL_CFG4	0x0000020007000002LL
/* AHB/DDR asynchronous */
#define DENALI_CTL_21_VAL_CFG4	0x0000000100000101LL
#define DENALI_CTL_22_VAL_CFG4	0x0000020007000000LL
// #define DENALI_CTL_23_VAL_CFG4
#define DENALI_CTL_24_VAL_CFG4	0x0000000200820000LL
#define DENALI_CTL_25_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_26_VAL_CFG4	0x9440492794404927LL
#define DENALI_CTL_27_VAL_CFG4	0x9440492794404927LL
#define DENALI_CTL_28_VAL_CFG4	0x07c0040107c00401LL
#define DENALI_CTL_29_VAL_CFG4	0x07c0040107c00401LL
#define DENALI_CTL_30_VAL_CFG4	0x0000000000000005LL
#define DENALI_CTL_31_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_32_VAL_CFG4	0x0c02000000000000LL
#define DENALI_CTL_33_VAL_CFG4	0x0000000000000004LL
#define DENALI_CTL_34_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_35_VAL_CFG4	0x004b4b4b4b050000LL
#define DENALI_CTL_36_VAL_CFG4	0x0000000000000004LL
#define DENALI_CTL_37_VAL_CFG4	0x0852000000040200LL
#define DENALI_CTL_38_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_39_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_40_VAL_CFG4	0x00000000000000a3LL
// #define DENALI_CTL_41_VAL_CFG4	0x00cc005000cc0050LL
#define DENALI_CTL_41_VAL_CFG4	0x0016005a0016005aLL
#define DENALI_CTL_42_VAL_CFG4	DENALI_CTL_41_VAL_CFG4
#define DENALI_CTL_43_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_44_VAL_CFG4	DENALI_CTL_43_VAL_CFG4
#define DENALI_CTL_45_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_46_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_47_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_48_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_49_VAL_CFG4	0x0000000000000041LL
#define DENALI_CTL_50_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_51_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_52_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_53_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_54_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_55_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_56_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_57_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_58_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_59_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_60_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_61_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_62_VAL_CFG4	0x0000000000000000LL
// #define DENALI_CTL_63_VAL_CFG4	0x0000000000000000LL
// #define DENALI_CTL_64_VAL_CFG4	0x0000000000000000LL
// #define DENALI_CTL_65_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_66_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_67_VAL_CFG4	0x0000000000000000LL
#define DENALI_CTL_68_VAL_CFG4	0x000000000a000000LL
#define DENALI_CTL_69_VAL_CFG4	0x00000003e8050000LL

#endif /* __CONFIG_H */
