/*
 * Copyright (C) 2006 Mindspeed Technologies Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <common.h>
#include <config.h>
#include <asm/mach-types.h>
#include <asm/arch/bsp.h>
DECLARE_GLOBAL_DATA_PTR;

#ifdef CFG_FLASH_COMPLEX_MAPPINGS
void board_map(flash_info_t *info, unsigned long addr)
{
	if ((addr >= (PHYS_FLASH1 + 0x800000)) && (addr < (PHYS_FLASH1 + 0x1000000))) {
		SoC_gpio_set_0(SoC_gpio_mask(5));
	} else {
		SoC_gpio_set_1(SoC_gpio_mask(5));
	}
}
#endif

#if (CONFIG_COMMANDS & CFG_CMD_NAND)
static void nand_hw_init(void)
{
	/* set GPIO5 as output */
	SoC_gpio_cfg(29, GPIO_TYPE_OUTPUT);
	SoC_gpio_cfg(30, GPIO_TYPE_OUTPUT);
	SoC_gpio_cfg(31, GPIO_TYPE_OUTPUT);

}
#endif

u32 get_ddr_size(void)
{
	return PHYS_SDRAM_SIZE;
}

static void nor_hw_init(void)
{
	/* set GPIO5 as output */
	SoC_gpio_cfg(5, GPIO_TYPE_OUTPUT);

	/* Select upper 8MiB of flash device */
	SoC_gpio_set_1(SoC_gpio_mask(5));

#ifdef CFG_FLASH_COMPLEX_MAPPINGS
	*(volatile u32 *)EX_CS0_SEG_REG = 0x7FF;
#else
	*(volatile u32 *)EX_CS0_SEG_REG = 0x3FF;
#endif
}

void bsp_init(void)
{
	SoC_Check_Device();
	SoC_APB_setup();
	SoC_AHB_setup();
	SoC_ARAM_setup();

	SoC_PLL_init();

	icache_enable();
#if defined(CONFIG_COMCERTO_50)  
	SoC_mem_init(10); /* For C50 Router */
#else 
	SoC_mem_init(5);  /* for C100 Router */
#endif
//	SoC_nand_init();
}

int board_init(void)
{
	nor_hw_init();
#if (CONFIG_COMMANDS & CFG_CMD_NAND)
       nand_hw_init();
#endif

	/* arch number of Mindspeed Comcerto */
	gd->bd->bi_arch_number = MACH_TYPE_M825XX;

	/* adress of boot parameters */
	gd->bd->bi_boot_params = LINUX_BOOTPARAM_ADDR;
#if (CONFIG_COMMANDS & CFG_CMD_I2C)
	/* enable I2C interface */
	while (1)
	{
	   u32 temp;
   	   temp = *(volatile u32 *)GPIO_IOCTRL_REG | GPIO_IOCTRL_I2C; 		// enable I2C bus
   	   *(volatile u32 *)GPIO_LOCK_REG = 0x55555555; 			// remove lock
   	   *(volatile u32 *)GPIO_IOCTRL_REG = temp;				// write to ctrl reg
   	   if (*(volatile u32 *)GPIO_IOCTRL_REG == temp)
		   break;
	}
#endif



	return 0;
}

int dram_init(void)
{
	gd->bd->bi_dram[0].start = PHYS_SDRAM;
	gd->bd->bi_dram[0].size = get_ddr_size();

	return 0;
}

int misc_init_r(void)
{
	return 0;
}

#ifdef BOARD_LATE_INIT
int board_late_init(void)
{
#ifdef DDR_TRAINING_DBG
	u8 wr_dqs = 0; 
	u8 dqs_out = 0;
	u8 dqs_delay0 = 0;
	u8 dqs_delay1 = 0;
	u8 dqs_delay2 = 0;
	u8 dqs_delay3 = 0;
#endif

	printf("Reserve MSP memory\n");
	gd->bd->bi_dram[0].start += MSP_BOTTOM_MEMORY_RESERVED_SIZE;
	gd->bd->bi_dram[0].size -= MSP_BOTTOM_MEMORY_RESERVED_SIZE + MSP_TOP_MEMORY_RESERVED_SIZE;

#ifdef DDR_TRAINING_DBG
	wr_dqs = DENALI_WR_DQS; 
	dqs_out = DENALI_DQS_OUT;
	dqs_delay0 = DENALI_DQS_DELAY0;
	dqs_delay1 = DENALI_DQS_DELAY1;
	dqs_delay2 = DENALI_DQS_DELAY2;
	dqs_delay3 = DENALI_DQS_DELAY3;
	printf("DDR Training : ");
	printf("wr_dqs 0x%x dqs_out 0x%x delay0 0x%x delay1 0x%x delay2 0x%x delay3 0x%x\n", wr_dqs,dqs_out,dqs_delay0,dqs_delay1,dqs_delay2,dqs_delay3);
#endif
	return 0;
}

#endif
