/*
 * (C) Copyright 2006
 * Mindspeed Technologies, Inc. <www.mindspeed.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <config.h>
#include <common.h>

#if (CONFIG_COMMANDS & CFG_CMD_NAND)

#include <nand.h>
#include <asm/hardware.h>
#include <asm/arch/bsp.h>

/* 
 *	hardware specific access to control-lines
*/
void comcerto_nand_hwcontrol(struct mtd_info *mtd, int cmd)
{
	switch (cmd) {
	case NAND_CTL_SETCLE:
		SoC_gpio_set_1(SoC_gpio_mask(CFG_NAND_CLE_GPIO));
		break;

	case NAND_CTL_CLRCLE:
		SoC_gpio_set_0(SoC_gpio_mask(CFG_NAND_CLE_GPIO));
		break;

	case NAND_CTL_SETALE:
		SoC_gpio_set_1(SoC_gpio_mask(CFG_NAND_ALE_GPIO));
		break;

	case NAND_CTL_CLRALE:
		SoC_gpio_set_0(SoC_gpio_mask(CFG_NAND_ALE_GPIO));
		break;

	case NAND_CTL_SETNCE:
		SoC_gpio_set_0(SoC_gpio_mask(CFG_NAND_CE_GPIO));
		break;

	case NAND_CTL_CLRNCE:
		SoC_gpio_set_1(SoC_gpio_mask(CFG_NAND_CE_GPIO));
		break;
	}
}

int comcerto_nand_ready(struct mtd_info *mtd)
{
	return SoC_gpio_read(SoC_gpio_mask(CFG_NAND_BR_GPIO)) ? 1 : 0;
}

void board_nand_init(struct nand_chip *nand)
{
	printf("board_nand_init nand->IO_ADDR_R =%x\n", nand->IO_ADDR_R);

	nand->options = 0;
	nand->eccmode = NAND_ECC_SOFT;
	nand->hwcontrol = comcerto_nand_hwcontrol;
	nand->dev_ready = comcerto_nand_ready;
	nand->chip_delay = 20;
}
#endif
