/*
 * (C) Copyright 2006
 * Mindspeed Technologies, Inc. <www.mindspeed.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * High Level Configuration Options
 */
#define CONFIG_COMCERTO
#define CONFIG_COMCERTO_530			/* It's a SoC */
#define CONFIG_TSAVO530				/* on a Tsavo-530 Board */
#undef CONFIG_USE_IRQ				/* we don't need IRQ/FIQ stuff */

#include <asm/hardware.h>

/* Mindspeed version */
#define CONFIG_IDENT_STRING		" Mindspeed 0.05.0cvs NORboot"

/*
 * Linux boot configuration
 */
#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs */
#define CONFIG_SETUP_MEMORY_TAGS	1
//#define CONFIG_INITRD_TAG		1

#define LINUX_BOOTPARAM_ADDR		0x01000100

/*
 * Initial stack configuration
 */
#define CFG_INIT_RAM_ADDR		IRAM_BASEADDR
#define CFG_INIT_SP_OFFSET		0x1000


/*
 * Malloc/stack configuration
 */
#define CFG_MALLOC_LEN			(CFG_ENV_SIZE + 128 * 1024)
#define CFG_GBL_DATA_SIZE		128	/* size in bytes reserved for initial data */

#define CONFIG_STACKSIZE		(32 * 1024)	/* regular stack */


/*
 * SDRAM configuration
 */
#define CONFIG_NR_DRAM_BANKS		1
#define PHYS_SDRAM			0x00000000
#define PHYS_SDRAM_SIZE			0x04000000	/* 64 MiB */


/*
 * Hardware drivers
 */

/*
 * UART configuration
 */
#define CONFIG_UART0


#define CONFIG_BAUDRATE		115200
#define CFG_BAUDRATE_TABLE	{115200, 19200, 38400, 57600, 9600}


/*
 * EMAC driver
 */
#define CONFIG_COMCERTO_EMAC
#define CONFIG_EMAC0

/*
 * MDIO driver
 */
#define CONFIG_MII
#define CFG_FAULT_ECHO_LINK_DOWN
#define CONFIG_EMAC0_MDCLOCK		2500000
#define CONFIG_EMAC0_PHY_ADDR		0x0


/*
 * Shell configuration
 */
#define CONFIG_COMMANDS			(CFG_CMD_FLASH | CFG_CMD_ENV | CFG_CMD_MEMORY | CFG_CMD_RUN | CFG_CMD_NET | \
					 CFG_CMD_MII | CFG_CMD_ELF | CFG_CMD_NAND)

#define	CFG_LONGHELP					/* undef to save memory		*/
#define CFG_PROMPT		"Comcerto-530 > "	/* Monitor Command Prompt */
#define CFG_CBSIZE		256			/* Console I/O Buffer Size */
#define CFG_MAXARGS		16			/* max number of command args */
#define CFG_PBSIZE		(CFG_CBSIZE + sizeof(CFG_PROMPT) + 16)	/* Print Buffer Size */

/*
 * User Interface
 */
#define	CONFIG_EXTRA_ENV_SETTINGS	\
	"tftpdir=.\0"			\
	"nfsdir=/home/nfs/fsminimal-debian_sarge-0.13\0"			\
	"mspname=firmware.axf\0"	\
	"cspname=zImage\0"		\
	"fsname=fsimage.jffs2\0"	\
	"mtdparts=" MTDPARTS_DEFAULT "\0"	\
	"updateboot=tftp 1000000 ${tftpdir}/u-boot.bin; erase 1:0-2; cp.b ${fileaddr} 11000000 ${filesize}\0"	\
	"updatecsp=tftp 1000000 ${tftpdir}/${cspname}; erase 1:4-31; cp.b ${fileaddr} 11040000 ${filesize}\0"   \
	"updatemsp=tftp 1000000 ${tftpdir}/${mspname}; erase 1:32-63; cp.b ${fileaddr} 11200000 ${filesize}\0"  \
	"updatecspNAND=tftp 1000000 ${tftpdir}/${cspname}; nand erase 0 200000; nand write.jffs2 ${fileaddr} 0 ${filesize}\0"	\
	"updatemspNAND=tftp 1000000 ${tftpdir}/${mspname}; nand erase 200000 200000; nand write.jffs2 ${fileaddr} 200000 ${filesize}\0"	\
	"updatefsNAND=tftp 1000000 ${tftpdir}/${fsname}; nand erase 400000 7c00000; nand write.jffs2 ${fileaddr} 400000 ${filesize}\0"	\
	"boottt=run setbootargs; tftp 1000000 ${tftpdir}/${mspname}; loadmsp ${fileaddr} ${filesize}; tftp 2000000 ${tftpdir}/${cspname}; bootcomcerto ${fileaddr}\0"	\
	"bootoo=run setbootargs; loadmsp 11200000 200000; cp.b 11040000 2000000 200000; bootcomcerto 2000000\0"  \
	"bootaa=run setbootargs; nand read.jffs2 1000000 200000 200000; loadmsp 1000000 200000; nand read.jffs2 2000000 0 200000; bootcomcerto 2000000\0" \
	"mtdboot=setenv bootargs root=/dev/mtdblock2 rw rootfstype=jffs2\0"	\
	"nfsboot=setenv bootargs root=/dev/nfs rw nfsroot=${serverip}:${nfsdir}\0"	\
	"addip=setenv bootargs ${bootargs} ip=${ipaddr}:${serverip}:${gatewayip}:${netmask}::eth0\0"	\
	"addtty=setenv bootargs ${bootargs} console=ttyS0,${baudrate}\0"	\
	"addmtd=setenv bootargs ${bootargs} ${mtdparts}\0"	\
	"setbootargs=run mtdboot addtty addip addmtd\0"

#define CONFIG_ETHADDR		00:aa:bb:cc:dd:ee
#define CONFIG_IPADDR		192.168.0.2
#define CONFIG_SERVERIP		192.168.0.3
#define CONFIG_GATEWAYIP	192.168.0.1
#define CONFIG_NETMASK		255.255.255.0
#define CONFIG_BOOTDELAY		3


#include <cmd_confdefs.h>

/* Include basic MMU support if ELF support is included
 *
 * NOTE: keep this stuff after "cmd_confdefs.h" include
 */
#if (CONFIG_COMMANDS & CFG_CMD_ELF)
#define USE_920T_MMU
#endif


#define CFG_LOAD_ADDR			0x1000000	/* default load address */


#define CFG_MEMTEST_START	CFG_LOAD_ADDR		/* memtest works on */
#define CFG_MEMTEST_END		(CFG_MEMTEST_START + 0x800000)

#define BOARD_LATE_INIT
#define MSP_BOTTOM_MEMORY_RESERVED_SIZE	0x1000000	/* 16 MiB reserved for MSP */
#define MSP_TOP_MEMORY_RESERVED_SIZE	0x0100000	/* 1 MiB reserved for MSP */

/*
 * Network Configuration
 */
#define CONFIG_NET_RETRY_COUNT		5

/*
 * Flash Configuration
 */
//#define CFG_FLASH_AM040_DRIVER			/* enable AM040 flash driver */
#undef CFG_FLASH_AM040_DRIVER				/* disable AM040 flash driver */

#define CFG_FLASH_AMLV640U_DRIVER			/* enable AMLV640U flash driver */
//#undef CFG_FLASH_AMLV640U_DRIVER			/* disable AMLV640U flash driver */
#define CFG_FLASH_AMLV640U_SIZE		0x400000	/* (Acessible) Size of the AMLV640U flash device */

//#define CFG_FLASH_CFI_DRIVER			/* enable CFI driver */
#undef CFG_FLASH_CFI_DRIVER			/* disable CFI driver */

#define CFG_MAX_FLASH_SECT		128	/* max # of sectors on one chip */
//#define CFG_FLASH_PROTECTION


#define PHYS_FLASH1			EXP_CSBOOT_BASEADDR	/* Flash Bank #1 */
#define PHYS_FLASH1_SECT_SIZE		0x00010000	/* 64 KiB sectors */

#define CFG_MAX_FLASH_BANKS		1	/* max num of flash banks */
#define CFG_FLASH_BANKS_LIST		{PHYS_FLASH1}

#define CFG_FLASH_ERASE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Write */

/*
 * CFI driver 
 */
#if defined(CFG_FLASH_CFI_DRIVER)
#define CFG_FLASH_CFI				/* flash is CFI conformant      */
#define CFG_FLASH_USE_BUFFER_WRITE		/* use buffered writes (20x faster) */
#define CFG_FLASH_QUIET_TEST

/*
 * Monitor configuration
 */
#define CFG_MONITOR_BASE        	PHYS_FLASH1
#define CFG_MONITOR_LEN         	(3 * PHYS_FLASH1_SECT_SIZE)	/* Reserve 64 KiB for Monitor */

#endif


/*
 * Enviroment in flash
 */
#define CFG_ENV_IS_IN_FLASH

#if defined(CFG_ENV_IS_IN_FLASH)
#define CFG_ENV_ADDR			(PHYS_FLASH1 + 3 * PHYS_FLASH1_SECT_SIZE)	/* Keep 3 sectors for U-boot image */
#define CFG_ENV_SECT_SIZE		PHYS_FLASH1_SECT_SIZE
//#define CFG_ENV_ADDR_REDUND		(CFG_ENV_ADDR + CFG_ENV_SECT_SIZE)
#endif

#define CFG_ENV_SIZE			0x4000	/* Total Size of Environment 16KiB */

#define CONFIG_ENV_OVERWRITE

/*
 * NAND Configuration
 */
#if (CONFIG_COMMANDS & CFG_CMD_NAND)
#define CFG_NAND_BASE			EXP_CSP0_BASEADDR
#define CFG_MAX_NAND_DEVICE		1
#define NAND_MAX_CHIPS			1
#define CONFIG_JFFS2_NAND

#endif

/* NAND GPIOs config */
#define CFG_NAND_BR_GPIO	1
#define CFG_NAND_CE_GPIO	3
#define CFG_NAND_CLE_GPIO	4
#define CFG_NAND_ALE_GPIO	5

/*
 * JFFS2 Configuration
 */
/* mtdparts command line support */
#define CONFIG_JFFS2_CMDLINE
#define MTDIDS_DEFAULT		"nand0=comcerto_nand0,nor0=comcerto_nor0"
#define MTDPARTS_DEFAULT	"mtdparts=comcerto_nand0:2m(csp),2m(msp),124m(fs);comcerto_nor0:192k(bootloader),64k(bootloader env),1792k(csp),2m(msp)"

#define CFG_REFCLKFREQ		10000000	/* 10 MHz */

#define CFG_HZ			1000
#define CFG_HZ_CLOCK		125000000	/* 125 MHz */


#ifdef CONFIG_USE_IRQ
#error CONFIG_USE_IRQ not supported
#endif

#endif /* __CONFIG_H */
