/*
 * (C) Copyright 2006
 * Mindspeed Technologies, Inc. <www.mindspeed.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __CONFIG_H
#define __CONFIG_H
/*
 * High Level Configuration Options
 */
#define CONFIG_COMCERTO			1
#define CONFIG_ARM1136 			1	/* This is an arm1136j-s CPU core */
#define CONFIG_COMCERTO_900		1	/* It's an  SoC */
#define CONFIG_SUPERMOMBASA		1	/* on an Supermombasa Board     */
#undef  CONFIG_USE_IRQ		/* we don't need IRQ/FIQ stuff  */

#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs      */
#define CONFIG_SETUP_MEMORY_TAGS	1
#define CONFIG_INITRD_TAG		1

/*
 * Size of malloc() pool
 */
#define CFG_MALLOC_LEN			(CFG_ENV_SIZE + 128 * 1024)
#define CFG_GBL_DATA_SIZE		128	/* size in bytes reserved for initial data */

/*
 * Memory Mapping
 */

#define CONFIG_NR_DRAM_BANKS		1
#define PHYS_SDRAM			0x00000000
#define PHYS_SDRAM_SIZE			0x08000000	/* 128 MiB */

#define LINUX_BOOTPARAM_ADDR		0x0800100

#define PHYS_FLASH_1			0x80000000	/* Flash Bank #1 */
#define PHYS_FLASH_SIZE			0x00800000	/* 8 MiB */
#define PHYS_FLASH_BANK_SIZE    	0x00800000	/* 8 MiB Banks */
#define PHYS_FLASH_SECT_SIZE    	0x00010000	/* 64 KiB sectors */

#define PHYS_EEPROM_1			0x11000000	/* EEPROM Bank #1 */
#define PHYS_EEPROM_SIZE		0x0080000	/* 512 KiB */
#define PHYS_EEPROM_BANK_SIZE		0x0080000	/* 512 KiB Banks */
#define PHYS_EEPROM_SECT_SIZE		0x00010000	/* 64 KiB sectors */

#define PHYS_NAND_1			0x11400000
#define PHYS_NAND_SIZE			0x80000000

#define CFG_MONITOR_BASE        	PHYS_FLASH_1
#define CFG_MONITOR_LEN         	(PHYS_FLASH_SECT_SIZE)	/* Reserve 64 KiB for Monitor */

#if CFG_MONITOR_BASE < CFG_FLASH_BASE
#define CFG_RAMSTART
#endif

/*
 * Hardware drivers
 */

/* define one of these to choose the UART0  or UART1 as console */
#define CONFIG_UART0
#undef CONFIG_UART1

#undef	CONFIG_HWFLOW		/* don't include RTS/CTS flow control support   */

#undef	CONFIG_MODEM_SUPPORT	/* disable modem initialization stuff */

#define CONFIG_BOOTDELAY		3
/* #define CONFIG_ENV_OVERWRITE		1 */

#define CONFIG_COMMANDS		(CONFIG_CMD_DFL | CFG_CMD_JFFS2 | CFG_CMD_PING)

#include <cmd_confdefs.h>
#define CONFIG_BAUDRATE         115200
#define CFG_BAUDRATE_TABLE	{115200 , 19200, 38400, 57600, 9600 }

#define CFG_PROMPT		"Comcerto-900 > "	/* Monitor Command Prompt */
#define CFG_CBSIZE		256			/* Console I/O Buffer Size */
#define CFG_MAXARGS		16			/* max number of command args */
#define CFG_PBSIZE		(CFG_CBSIZE + sizeof(CFG_PROMPT) + 16)	/* Print Buffer Size */

#define CFG_MEMTEST_START	PHYS_SDRAM
#define CFG_MEMTEST_END		(CFG_MEMTEST_START + PHYS_SDRAM_SIZE)

#define BOARD_LATE_INIT
#define MSP_MEMORY_RESERVED_SIZE	0x800000	/* 8 MiB reserved for MSP */

/*
 * Network Configuration
 */
#define CONFIG_COMCERTO_EMAC
#define CONFIG_NET_RETRY_COUNT		20
#define CONFIG_EMAC0
#define CONFIG_EMAC0_MII		0


//#define CONFIG_NET_MULTI      1

//#define CONFIG_MII            1       /* MII PHY management           */
//#define CONFIG_PHY_ADDR       0       /* PHY address                  */
//#define CONFIG_PHY1_ADDR      1       /* PHY address                  */

#define CFG_FLASH_AM040_DRIVER		1

/*
 * Flash Configuration - Using CFI driver 
 */

#define CFG_FLASH_BASE			PHYS_FLASH_1
#define CFG_FLASH_SIZE			PHYS_FLASH_SIZE
#define CFG_FLASH_CFI			1	/* flash is CFI conformant      */
#define CFG_FLASH_CFI_DRIVER		1	/* use common cfi driver        */
#define CFG_FLASH_USE_BUFFER_WRITE	1	/* use buffered writes (20x faster) */

#define CFG_MAX_FLASH_SECT		128	/* max # of sectors on one chip */
#undef CFG_FLASH_PROTECTION

#define CFG_MAX_FLASH_BANKS		2	/* max num of flash banks */
#define CFG_FLASH_BANKS_LIST		{ PHYS_EEPROM_1, CFG_FLASH_BASE }

#define CFG_FLASH_ERASE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Write */

#define CFG_ENV_IS_IN_FLASH		1

#if defined(CFG_ENV_IS_IN_FLASH)
#if 1
#define CFG_ENV_IN_OWN_SECTOR	1
#define CFG_ENV_ADDR		(PHYS_FLASH_1 + 2 * PHYS_FLASH_SECT_SIZE)
#define CFG_ENV_SIZE		PHYS_FLASH_SECT_SIZE
#define CFG_ENV_SECT_SIZE	PHYS_FLASH_SECT_SIZE

#define CFG_ENV_ADDR_REDUND	(CFG_ENV_ADDR+CFG_ENV_SIZE)
#define CFG_ENV_SIZE_REDUND	PHYS_FLASH_SECT_SIZE
#else
#define CFG_ENV_IN_OWN_SECTOR	1
#define CFG_ENV_ADDR		(PHYS_EEPROM_1 + PHYS_EEPROM_SIZE - 2 * PHYS_FLASH_SECT_SIZE)
#define CFG_ENV_SIZE		(2 * PHYS_FLASH_SECT_SIZE)
#define CFG_ENV_SECT_SIZE	PHYS_FLASH_SECT_SIZE
#endif
#else
#define CFG_ENV_SIZE		0x20000	/* Total Size of Environment */
#endif

#define CFG_LOAD_ADDR		0x600000	/* default load address */

/*
 * NAND Configuration
 */
#if (CONFIG_COMMANDS & CFG_CMD_NAND)
#define CFG_NAND_BASE			PHYS_NAND_1
#define CFG_MAX_NAND_DEVICE		1
#define NAND_MAX_CHIPS			1
#define CONFIG_JFFS2_NAND		1
#define CONFIG_MTD_NAND_VERIFY_WRITE	1
//#define CONFIG_MTD_DEBUG
//#define CONFIG_MTD_DEBUG_VERBOSE	3

#endif

/* NAND GPIOs config */
#define CFG_NAND_BR_GPIO	1
#define CFG_NAND_CE_GPIO	3
#define CFG_NAND_CLE_GPIO	4
#define CFG_NAND_ALE_GPIO	5

/*
 * JFFS2 Configuration
 */
/* mtdparts command line support */
#define CONFIG_JFFS2_CMDLINE
#define MTDIDS_DEFAULT		"nor0=comcertoeeprom.0,nor1=comcertoflash.0"
#define MTDPARTS_DEFAULT	"mtdparts=comcertoflash.0:128k(u-boot),64k(env),64k(renv),-(fs)"

#define	CONFIG_EXTRA_ENV_SETTINGS				\
	"hostname=comcerto900\0"						\
	"netdev=eth0\0"									\
	"nfsargs=setenv bootargs root=/dev/nfs rw "		\
		"nfsroot=${serverip}:${rootpath}\0"				\
	"flashargs=setenv bootargs root=/dev/mtdblock3 rootfstype=\${rootfstype} rw\0"	\
	"rootfstype=jffs2\0" \
	"addip=setenv bootargs ${bootargs} "				\
		"ip=${ipaddr}:${serverip}:${gatewayip}:${netmask}"	\
		":${hostname}:${netdev}:off \0" \
	"addeth=setenv bootargs ${bootargs} " \
	"hwaddress=${netdev},${ethaddr}\0" \
	"addtty=setenv bootargs ${bootargs} console=ttyS0,${baudrate}\0" \
	"flash_self=run flashargs addip addtty;"		\
		"bootm ${kernel_addr}\0"				\
	"boot_nfs=nfs 600000 ${rootpath}/boot/${kernelfile};run nfsargs addeth addip addtty;"     \
	        "bootm 600000\0"						\
	"rootpath=/home/user/devel/CSP_software/distribution/mindspeed-buildroot/build_arm_nofpu/root\0" \
	"kernelfile=uImage\0" \
	"fsfile=rootfs.arm_nofpu.jffs2\0" \
	"updatefs=protect off 2:4-127\;erase 2:4-127;tftp 1000000 ${fsfile};cp.b 1000000 80040000 ${filesize}\0" \
	"updateboot=protect off 1:0-1\;erase 1:0-1;tftp 1000000 u-boot.bin;cp.b 1000000 11000000 ${filesize}\0" \
	"updateenv=protect off 2:2;saveenv\0" \
	""

#ifndef __ASSEMBLY__
/*-----------------------------------------------------------------------
 * Board specific extension for bd_info
 *
 * This structure is embedded in the global bd_info (bd_t) structure
 * and can be used by the board specific code (eg board/...)
 */

struct bd_info_ext {
	/* helper variable for board environment handling
	 *
	 * env_crc_valid == 0    =>   uninitialised
	 * env_crc_valid  > 0    =>   environment crc in flash is valid
	 * env_crc_valid  < 0    =>   environment crc in flash is invalid
	 */
	int env_crc_valid;
};

#endif

#define CFG_REFCLKFREQ		10000000	/* 10 MHz */

#define CFG_HZ			1000
#define CFG_HZ_CLOCK		133000000	/* 133 MHz */

#define CONFIG_STACKSIZE	(32*1024)	/* regular stack */

#ifdef CONFIG_USE_IRQ
#error CONFIG_USE_IRQ not supported
#endif

#endif /* __CONFIG_H */
