/*
 * (C) Copyright 2006
 * Mindspeed Technologies, Inc. <www.mindspeed.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <common.h>
#include <config.h>
#include <asm/mach-types.h>
#include <asm/arch/bsp.h>
#include <asm/hardware.h>

DECLARE_GLOBAL_DATA_PTR;

#if (CONFIG_COMMANDS & CFG_CMD_SPI) || defined(CONFIG_SPI)
extern void spi_hw_init(void);
#endif

/* Initialize SDRAM, ARM and bus CLOCK and instruction cache */
void bsp_init(void)
{
	struct cs_cfg cfg = {
		.memtype = CS_MEMTYPE_SDRAM,
		.baseaddr = PHYS_SDRAM,
		.size = PHYS_SDRAM_SIZE,

		.tras = 0x6,
		.trc = 0x9,
		.trcd = 0x3,
		.trp = 0x3,
		.cl = 0x3,

		.memchip_dtype = 0x1,
		.twr = 0x2,
		.buswidth = 0x1,
		.tmrd = 0x2,
		.trrd = 0x2,

		.refcnt = 0x0408,
		.pwroncnt = 0x0042,
	};

	SoC_pll_cfg(CLK_MODE_SYNC, 2 * CFG_HZ_CLOCK, 0);
	SoC_cs_cfg(EXP_CSSD0, CS_ENABLE, &cfg);

	icache_enable();
}

static void nand_hw_init(void)
{
	struct cs_cfg cfg = {
		.memtype = CS_MEMTYPE_SRAM,
		.buswidth = CS_BUSWIDTH_8BIT,
		.level = CS_ACTIVE_LOW,
		.cmdwidth = 0x9,
		.addrsetup = 0x5,
		.dqm_mode = CS_DQMMODE_NORMAL,
	};

	SoC_cs_cfg(EXP_CSP0, CS_ENABLE, &cfg);

	SoC_gpio_cfg(CFG_NAND_BR_GPIO, GPIO_TYPE_INPUT);
	SoC_gpio_cfg(CFG_NAND_CE_GPIO, GPIO_TYPE_OUTPUT);
	SoC_gpio_cfg(CFG_NAND_CLE_GPIO, GPIO_TYPE_OUTPUT);
	SoC_gpio_cfg(CFG_NAND_ALE_GPIO, GPIO_TYPE_OUTPUT);
}

static void nor_hw_init(void)
{
	struct cs_cfg cfg = {
		.memtype = CS_MEMTYPE_SRAM,

		.buswidth = CS_BUSWIDTH_16BIT,
		.level = CS_ACTIVE_LOW,
		.cmdwidth = 0x9,
		.addrsetup = 0x7,
		.dqm_mode = CS_DQMMODE_NORMAL,
	};

	SoC_cs_cfg(EXP_CSBOOT, CS_ENABLE, &cfg);
}

int board_init(void)
{
	/* arch number of Mindspeed Comcerto */
	gd->bd->bi_arch_number = MACH_TYPE_M825XX;

	/* adress of boot parameters */
	gd->bd->bi_boot_params = LINUX_BOOTPARAM_ADDR;

	nand_hw_init();
	nor_hw_init();

#if (CONFIG_COMMANDS & CFG_CMD_SPI) || defined(CONFIG_SPI)
	spi_hw_init();
#endif

	return 0;
}

int dram_init(void)
{
	gd->bd->bi_dram[0].start = PHYS_SDRAM;
	gd->bd->bi_dram[0].size = PHYS_SDRAM_SIZE;

	return 0;
}

extern void partition_flash(void);

int misc_init_r(void)
{
	return 0;
}

#ifdef BOARD_LATE_INIT
int board_late_init(void)
{
	printf("Reserve MSP memory\n");
	gd->bd->bi_dram[0].start += MSP_BOTTOM_MEMORY_RESERVED_SIZE;
	gd->bd->bi_dram[0].size -= MSP_BOTTOM_MEMORY_RESERVED_SIZE + MSP_TOP_MEMORY_RESERVED_SIZE;
	return 0;
}
#endif
